package com.bcxin.Infrastructures.commands;

import com.bcxin.Infrastructures.exceptions.TenantExceptionAbstract;
import lombok.Getter;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

@Getter
public abstract class CommandAbstract {
    private final Collection<String> inValidatedLogs = new ArrayList<>();

    public void validate() {

    }

    public void addError(String error) {
        this.inValidatedLogs.add(error);
    }

    public boolean IsValid() {
        return CollectionUtils.isEmpty(this.inValidatedLogs);
    }

    public String getErrorResult() {
        if (CollectionUtils.isEmpty(inValidatedLogs)) {
            return null;
        }

        return inValidatedLogs.stream().collect(Collectors.joining(","));
    }

    protected void checkParameter(Runnable runnable) {
        try {
            runnable.run();
        } catch (TenantExceptionAbstract ex) {
            this.addError(ex.getMessage());
        }
    }
}
