package com.bcxin.Infrastructures;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;

import java.util.Collection;

public interface UnitWork {
    /**
     * 返回tid
     *
     * @return
     */
    String beginTransaction();

    /**
     * 提交tid的事务
     *
     * @param tid
     */
    void commit(String tid);

    /**
     *
     */
    void detach(IAggregate aggregate);

    <T extends IAggregate> void detachAll(Collection<T> aggregates);

    void executeTran(Runnable runnable);

    /**
     * 调用commit之后不能再调用这个进行回滚
     * 但是很多异常都是再commit之前发生的
     * @param tid
     */
    void rollback(String tid);

    void executeNewTran(Runnable runnable);
}
