package com.bcxin.Infrastructures;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import lombok.Data;

@Data
public class Pagination<T> implements Serializable {
    private final int pageIndex;
    private final int pageSize;
    private final long totalCount;
    private final List<T> data;
    private  List<String> dynamicCol=null;
    private  List<List<Object>> dynamicData=null;

    public Pagination(int pageIndex, int pageSize, long totalCount, List<T> data) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.data = data;
        this.totalCount = totalCount;
    }

    public static <T> Pagination create(int pageIndex, int pageSize, long totalCount, List<T> data) {
        return new Pagination(pageIndex, pageSize, totalCount, data);
    }

    public long getTotal() {
        return this.totalCount;
    }
}
