/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.validations;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.models.CredentialModel;
import com.bcxin.Infrastructures.validations.Credential;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class CredentialValidator
implements ConstraintValidator<Credential, CredentialModel> {
    private static final Logger log = LoggerFactory.getLogger(CredentialValidator.class);
    private static final Pattern pattern = Pattern.compile("(^[1-9]\\d{5}(\\d{2}((0[1-9])|(10|11|12)))(([0-2][1-9])|10|20|30|31)\\d{3}$)|(^[1-9]\\d{5}((18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12)))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)");

    public boolean isValid(CredentialModel value, ConstraintValidatorContext context) {
        return CredentialValidator.validate(value.getType(), value.getNumber());
    }

    public static int getAge(String idNumber) throws IllegalArgumentException {
        Matcher matcher = pattern.matcher(idNumber);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("\u8eab\u4efd\u8bc1(%s)\u683c\u5f0f\u4e0d\u6b63\u786e!", idNumber));
        }
        String yearMonth = null;
        for (int index = 0; index < matcher.groupCount(); ++index) {
            if (index < 1) continue;
            try {
                yearMonth = matcher.group(index);
                if (!StringUtils.hasLength((String)yearMonth) || yearMonth.length() != 4 && yearMonth.length() != 6) continue;
                break;
            }
            catch (Exception ex) {
                log.error(String.format("\u83b7\u53d6\u8eab\u4efd\u8bc1(%s)\u4e2d\u5e74\u6708\u65e0\u6548", idNumber), (Throwable)ex);
            }
        }
        if (!StringUtils.hasLength(yearMonth) || yearMonth.length() < 4) {
            throw new IllegalArgumentException(String.format("\u8eab\u4efd\u8bc1(%s)\u683c\u5f0f\u4e0d\u6b63\u786e!", idNumber));
        }
        try {
            String yearLabel = yearMonth.substring(0, yearMonth.length() - 2);
            int birthYear = 0;
            birthYear = yearLabel.length() == 2 ? Integer.parseInt(String.format("19%s", birthYear)) : Integer.parseInt(yearLabel);
            Calendar now = Calendar.getInstance();
            int age = now.get(1) - birthYear;
            int birthMonth = Integer.parseInt(yearMonth.substring(yearMonth.length() - 2 - 1));
            int additionalAge = now.get(2);
            if (additionalAge < birthMonth) {
                --age;
            }
            return age;
        }
        catch (Exception ex) {
            log.error(String.format("\u89e3\u6790\u8eab\u4efd\u8bc1(%s)\u4e2d\u5e74\u9f84\u65e0\u6548", idNumber), (Throwable)ex);
            throw new IllegalArgumentException(String.format("\u8eab\u4efd\u8bc1(%s)\u683c\u5f0f\u4e0d\u6b63\u786e!", idNumber));
        }
    }

    public static boolean validate(CredentialType credentialType, String number) {
        if (!StringUtils.hasLength((String)number)) {
            return true;
        }
        if (credentialType == CredentialType.IdCard) {
            Matcher matcher = pattern.matcher(number);
            return matcher.matches();
        }
        return true;
    }
}

