/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.StringUtils;

public class DateUtil {
    public static String format2ShortDate(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    public static String format2ShortDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat("yyyyMMddHHmmss").format(date);
    }

    public static Date fromString(String text) {
        if (!StringUtils.hasLength((String)text)) {
            return null;
        }
        for (String ii : Stream.of("yyyy-MM-dd", "yyyy.MM.dd", "yyyy/MM/dd").collect(Collectors.toList())) {
            try {
                return new SimpleDateFormat(ii).parse(text);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static int countWorkDay(int year, int month) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        int max = c.getActualMaximum(5);
        int count = 0;
        for (int start = 1; start <= max; ++start) {
            c.set(5, start);
            if (!DateUtil.isWorkDay(c)) continue;
            ++count;
        }
        return count;
    }

    public static boolean isWorkDay(Calendar c) {
        int week = c.get(7);
        return week != 1 && week != 7;
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.countWorkDay(2022, 4));
    }
}

