/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.components;

import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.utils.URLUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Component;

public interface WebFileProvider {
    public InputStream download(String var1);

    @Component
    public static class WebFileProviderImpl
    implements WebFileProvider {
        @Override
        public InputStream download(String path) {
            HttpURLConnection connection = null;
            try {
                path = URLUtil.encode(path);
                URL url = new URL(path);
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setDoInput(true);
                connection.setDoInput(true);
                connection.setRequestProperty("Accept-Charset", "utf-8");
                connection.setConnectTimeout(20000);
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                InputStream inputStream = connection.getInputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)output);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(output.toByteArray());
                return byteArrayInputStream;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BadTenantException(String.format("\u6587\u4ef6(%s)\u4e0b\u8f7d\u5931\u8d25! \u5931\u8d25\u539f\u56e0=%s", path, e.getMessage()));
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
    }
}

