<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta
            name="viewport"
            content="width=device-width,initial-scale=1.0,maximum-scale=1.0,user-scalable=no"
    />
    <meta http-equiv="X-UA-Compatible" content="ie=edge" />
    <title>WebOffice</title>
</head>
<body>
<script src="https://cdn.staticfile.org/babel-core/5.8.35/browser.min.js"></script>
<script src="https://cdn.staticfile.org/babel-core/5.8.35/browser-polyfill.min.js"></script>
<script src="/wps/web-office-sdk-solution-v2.0.5.umd.js"></script>
<div>欢迎进入本页面</div>
<script>
    console.log('引入后可以开始使用 jssdk 了！')
    console.log(WebOfficeSDK)
    window.initWps = function(appId,fileId) {
        var initOptions = {
            officeType: WebOfficeSDK.OfficeType.Writer,
            appId: appId,
            fileId: fileId,
            token: "${userId}"
        };
        switch ("${officeType}") {
            case "Spreadsheet":
                initOptions.officeType = WebOfficeSDK.OfficeType.Spreadsheet;
                break;
            case "Presentation":
                initOptions.officeType = WebOfficeSDK.OfficeType.Presentation;
                initOptions.pptOptions = {
                    isShowBottomStatusBar: false, // 是否展示底部状态栏
                    isShowRemarkView: true, // 是否显示备注视图
                    isShowInsertMedia: true, // 是否显示插入音视频入口
                    isShowComment: true, // 是否显示评论相关入口
                    mobile: {
                        isOpenIntoEdit: false, // （Mobile）要有编辑权限，移动端打开时是否进入编辑
                        showPrevTipWhilePlay: true, // （Mobile）播放时向上翻页，是否展示 “上一页” 的提示
                        isShowReviewLogo: false // （Mobile）是否显示审阅左上 logo
                    }
                }
                break;
            case "Pdf":
                initOptions.officeType = WebOfficeSDK.OfficeType.Pdf;
                initOptions.pdfOptions = {
                    isShowComment: true, // 是否显示注解，默认显示
                    isInSafeMode: false, // 是否处于安全模式（安全模式下不能划选文字，不能复制以及不能通过链接跳转），默认不是安全模式
                    isBestScale: true, // 默认以最佳显示比例打开
                    isShowBottomStatusBar: false, // 是否展示底部状态栏
                    disBackScrollPos: true // 是否禁用滚动还原
                };
                break;
            case "Otl":
                initOptions.officeType = WebOfficeSDK.OfficeType.Otl;
                const loadOptions = {
                    workbench: {
                        //增加编辑配置子项，文档头部工具栏及段落操作柄中才可选择使用该功能。
                        editor: [
                            'title',
                            'heading',
                            'fontSize',
                            'bold',
                            'italic',
                            'underline',
                            'deleteLine',
                            'script',
                            'colorStyle',
                            'outlineList',
                            'indent',
                            'align',
                            'find',
                            'picture',
                            'link',
                            'blockquote',
                            'horizonRule',
                            'code',
                            'inlineCode',
                            'emoji',
                            'table',
                            'history'
                        ],
                        view: ['startTab', 'mobileMenu', 'contextMenu', 'mobileReadMenu']
                    }
                };
                initOptions.otlOptions= {
                    loadOptions: loadOptions
                }
                break;
            default:
                initOptions.officeType = WebOfficeSDK.OfficeType.Writer;
                initOptions.wordOptions = {
                    isShowDocMap: false, // 是否开启目录功能，默认开启
                    isBestScale: false, // 打开文档时，默认以最佳比例显示
                    isShowBottomStatusBar: false, // 是否展示底部状态栏
                    mobile: {
                        isOpenIntoEdit: false, // （Mobile）要有编辑权限，移动端打开时是否进入编辑
                        isShowHoverToolbars: false, // （Mobile）是否显示文字底部工具栏
                        isVoiceCommentEnabled: false, // （Mobile）是否允许插入语音评论
                        showFontDownloadNotice: false // （Mobile）是否显示字体下载提示
                    }
                }
                break;
        }

        console.log("当前选项的信息为:")
        console.log(initOptions);
        return WebOfficeSDK.init(initOptions);
    }
</script>

<script>
    window.onload = () => {
        const instance = window.initWps("${appId}", "${fileId}");
        console.log(instance);

        const test = async () => {
            await instance.ready()
            console.log('api ready')
        }
        instance.on('fileOpen', function (data) {
            test()
            console.log('打开成功')
        })
    }
</script>
</body>
</html>