package com.bcxin.utils.constant;

/**
 * @author jianjun.wang
 * @version V1.0
 * @className ResultEnum
 * @packageName com.bcxin.utils.constant
 * @description 返回信息枚举类
 * @data 2019-09-02 13:54
 **/
public enum ResultEnum {
    //这里是可以自己定义的，方便与前端交互即可
    UNKNOWN_ERROR(-1, "未知错误"),
    SUCCESS(200, "请求成功"),
    USER_NOT_EXIST(1, "用户不存在"),
    USER_IS_EXISTS(2, "用户已存在"),
    DATA_IS_NULL(3, "数据为空"),
    ERR_1001(1001, "用户信息不存在"),
//    /** 请求成功 */
//    WPS_SUCCESS(200,"请求成功"),
    /**
     * 请求失败
     */
    FAIL(9999, "请求失败");

    private Integer code;
    private String msg;

    ResultEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
