package com.bcxin.startup;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bcxin.model.domain.Config;
import com.bcxin.service.impl.ConfigService;
import com.bcxin.utils.ConfigUtil;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.util.List;

@Data
@Component
/*执行顺序，order值越大，越早执行*/
@Order(value=1)
public class StartupRunner implements CommandLineRunner {

	@Autowired
	private ConfigService configService;

	//@Value("${file.dir}")
	//private String materialPath;

	@Override
	public void run(String... args) throws Exception {
		System.out.println(">>>>>>>>>>>>>>>服务启动执行，执行加载数据等操作<<<<<<<<<<<<<");
		List<Config> configList = configService.list(new QueryWrapper<Config>());
		for (Config config:configList) {
			//if (config.getSysKey().equals("material_path")) {
			//	ConfigUtil.putValue(config.getSysKey(),materialPath);
			//} else {
				ConfigUtil.putValue(config.getSysKey(), config.getSysValue());
			//}
		}
		System.out.println(">>>>>>>>>>>>>>>服务启动执行，执行加载数据结束<<<<<<<<<<<<<");
	}
	
}
