package com.bcxin.identify.util.common;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Console;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import org.apache.commons.codec.binary.Base64;
import org.springframework.stereotype.Component;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.util.Date;
import java.util.Map;

@Component
public class JwtUtil {
    /**
     * 数据请求返回码
     */
    public static final int RESCODE_SUCCESS = 1000;				//成功
    public static final int RESCODE_SUCCESS_MSG = 1001;			//成功(有返回信息)
    public static final int RESCODE_EXCEPTION = 1002;			//请求抛出异常
    public static final int RESCODE_NOLOGIN = 1003;				//未登陆状态
    public static final int RESCODE_NOEXIST = 1004;				//查询结果为空
    public static final int RESCODE_NOAUTH = 1005;				//无操作权限

    /**
     * jwt
     */
    public static final String JWT_ID = "blb";
    public static final String JWT_SECRET = "sdoDFyzfieqMrisd4H5o5t9weOl6GmSr";
    //	public static final int JWT_TTL = 24*60*60*1000;  //millisecond 1天 客户端去申请token
    public static final int JWT_TTL = 365*24*60*60*1000;  //millisecond 1天 客户端去申请token
    public static final int JWT_REFRESH_INTERVAL = 55*60*1000;  //millisecond token无效的时间间隔
    public static final int JWT_REFRESH_TTL = 7*24*60*60*1000;  //millisecond 7天重新登录的时间间隔

    /**
     * 由字符串生成加密key
     * @return
     */
    private static SecretKey generalKey(String stringKey){
        byte[] encodedKey = Base64.decodeBase64(stringKey);
        SecretKey key = new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
        return key;
    }

    /**
     * 创建jwt，ttlMillis为负数表示不过期
     * @param id
     * @param subject
     * @param ttlMillis
     * @return
     * @throws Exception
     */
    public static String createJWT(String id, String subject, String stringKey, long ttlMillis) throws Exception {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder()
                .setId(id)
                .setIssuedAt(new Date(System.currentTimeMillis()))
                .setSubject(subject)
                .signWith(signatureAlgorithm, generalKey(stringKey));
        if (ttlMillis >= 0) {
            long expMillis = System.currentTimeMillis() + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }
    /**
     * 创建jwt
     * @param subject
     * @return
     */
    public static String createJWT(Map<Object,Object> subject, String stringKey, long ttlMillis) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder()
                .setSubject(JSON.toJSONString(subject)) //主题，就是附带在token中的信息
                .signWith(signatureAlgorithm, generalKey(stringKey)); //选择的算法，和私钥值
        if (ttlMillis >= 0) { //如果过期时间为负数，那么不设置过期时间
            long expMillis = System.currentTimeMillis() + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    /**
     * 创建jwt
     * @param subject
     * @return
     */
    public static String createJWT(Map<String,Object> subject) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder()
                .setSubject(JSON.toJSONString(subject)) //主题，就是附带在token中的信息
                .signWith(signatureAlgorithm, generalKey(JWT_SECRET)); //选择的算法，和私钥值
        if (JWT_REFRESH_TTL >= 0) { //如果过期时间为负数，那么不设置过期时间
            long expMillis = System.currentTimeMillis() + JWT_REFRESH_TTL;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    /**
     * 创建jwt
     * @param subject
     * @return
     */
    public static String createJWT(String subject) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder()
                .setSubject(subject) //主题，就是附带在token中的信息
                .signWith(signatureAlgorithm, generalKey(JWT_SECRET)); //选择的算法，和私钥值
        if (JWT_REFRESH_TTL >= 0) { //如果过期时间为负数，那么不设置过期时间
            long expMillis = System.currentTimeMillis() + JWT_REFRESH_TTL;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    /**
     * 创建jwt
     * @param subject
     * @return
     */
    public static String createJWT(Map<String,Object> subject, String jwt_secret) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder()
                .setSubject(JSON.toJSONString(subject)) //主题，就是附带在token中的信息
                .signWith(signatureAlgorithm, generalKey(jwt_secret)); //选择的算法，和私钥值
        if (JWT_REFRESH_TTL >= 0) { //如果过期时间为负数，那么不设置过期时间
            long expMillis = System.currentTimeMillis() + JWT_REFRESH_TTL;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    /**
     * 创建jwt
     * @param subject
     * @return
     */
    public static String createJWTObject(Object subject) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder()
                .setSubject(JSON.toJSONString(subject)) //主题，就是附带在token中的信息
                .signWith(signatureAlgorithm, generalKey(JWT_SECRET)); //选择的算法，和私钥值
        if (JWT_REFRESH_TTL >= 0) { //如果过期时间为负数，那么不设置过期时间
            long expMillis = System.currentTimeMillis() + JWT_REFRESH_TTL;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    /**
     * 解密jwt
     * @param jwttoken
     * @return
     * @throws Exception
     */
    public static Claims parseJWT(String jwttoken, String stringKey) throws Exception {
        Claims claims = Jwts.parser()
                .setSigningKey(generalKey(stringKey)) //没有私钥是解密不了的
                .parseClaimsJws(jwttoken).getBody();
        return claims;
    }

    public static void main(String[] args) throws Exception  {
        Map<String,Object> p = Maps.newHashMap();
        p.put("url","https://www.bjzgxl.org.cn/pemLocal/docking/download/user/report/pdf?userId=dafdd9d583b37a2f&itemId=9d0ec9530dbe4a936e8662b6d7f37c27&questionId=dd21dbf46c289b2b");
        p.put("fileType","pdf");
//        p.put("groupType","ChatRoom");
//        p.put("sealUrl","http://test2.pss360.cn/getResource.do?path=2019-06-18/156084108649591506.jpg");
//        p.put("sealUrl1","http://test2.pss360.cn/getResource.do?path=2019-06-18/156084108649591506.jpg");

         //固定私钥，测试生产均为同一个
        String token = JwtUtil.createJWT(p);//加密生成token
        System.out.println(token);
//        String token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJvbmVJbWciOiJodHRwczovL2JjeGluLXNhYXMtcHJvZC5vYnMuY24tbm9ydGgtMS5teWh1YXdlaWNsb3VkLmNvbTo0NDMvdXBsb2FkJTJGMjAyMS0wMi0yNCUyRjE2MTQxNDY2NzM5NDE1MTc5NzAuanBnIiwidHdvSW1nIjoiaHR0cHM6Ly9iY3hpbi1zYWFzLXByb2Qub2JzLmNuLW5vcnRoLTEubXlodWF3ZWljbG91ZC5jb206NDQzL3VwbG9hZCUyRjIwMjEtMDItMjQlMkYxNjE0MTQ2NjczOTQxNTE3OTcwLmpwZyJ9";
//        String token = "eyJhbGciOiJIUzI1NiJ9.eyJzdWIiOiJ7XCJzZWFsVXJsMVwiOlwiaHR0cDovL3Rlc3QyLnBzczM2MC5jbi9nZXRSZXNvdXJjZS5kbz9wYXRoPTIwMTktMDYtMTgvMTU2MDg0MTA4NjQ5NTkxNTA2LmpwZ1wiLFwic2VhbFVybFwiOlwiaHR0cDovL3Rlc3QyLnBzczM2MC5jbi9nZXRSZXNvdXJjZS5kbz9wYXRoPTIwMTktMDYtMTgvMTU2MDg0MTA4NjQ5NTkxNTA2LmpwZ1wifSIsImV4cCI6MTYxNDc1Mzc0Nn0.GeMccWoPHugMOC0XZZ_irlkyykLzso8V7lT9JUOq8gU";
//        Claims claims = JwtUtil.parseJWT(token, "sdoDFyzfieqMrisd4H5o5t9weOl6GmSr");
//        String subject = claims.getSubject();
//        Map<String,Object> requestMap = Maps.newHashMap();
//        requestMap.put("token",token);
//        String response = HttpUtil.post("http://localhost:8888/api/gate/companyRegister",requestMap);
//        Console.log("response:{}",response);
//        Console.log(DateUtil.currentSeconds());
    }


}
