package com.bcxin.identify.business.service;

import com.baomidou.mybatisplus.plugins.pagination.PageHelper;
import com.bcxin.identify.business.dao.ComVideoRoomMapper;
import com.bcxin.identify.business.dao.PerVideoRoomMapper;
import com.bcxin.identify.business.domain.ysp.ComVideoRoom;
import com.bcxin.identify.util.PageInfoUtils;
import com.bcxin.identify.util.Result;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <b> 视频调度记录 </b>
 * @author ZXF
 * @create 2020/06/19 0019 17:37
 * @version
 * @注意事项 </b>
 */
@Service
@Transactional
public class ComVideoRoomService {
    @Resource
    private ComVideoRoomMapper comVideoRoomMapper;
    @Resource
    private PerVideoRoomMapper perVideoRoomMapper;

    /**
     * <b> 分页查询调度记录 </b>
     * @author ZXF
     * @create 2020/06/22 0022 10:41
     * @version
     * @注意事项 </b>
     */
    public Result findComVideoRoomPage(ComVideoRoom comVideoRoom) {
        PageHelper.startPage(comVideoRoom.getPageNumber(), comVideoRoom.getPageSize());
        List<Map<String,Object>> list = comVideoRoomMapper.findComVideoRoomPage(comVideoRoom);
        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(list));
    }

    /**
     * <b> 查询调度记录详情 </b>
     * @author ZXF
     * @create 2020/06/22 0022 10:41
     * @version
     * @注意事项 </b>
     */
    public Result getComVideoRoom(ComVideoRoom comVideoRoom) {
        if(comVideoRoom.getComVideoRoomId() == null){
            return Result.fail("comVideoRoomId不能为空");
        }
        comVideoRoom = comVideoRoomMapper.get(comVideoRoom.getComVideoRoomId());
        if(comVideoRoom == null){
            return Result.fail("未找到调度记录信息");
        }
        List<Map<String,String>> pvr = perVideoRoomMapper.findPerVideoRoomByRoomId(comVideoRoom.getComVideoRoomId());
        if(pvr.size() == 0){
            return Result.fail("未找到参会人员信息");
        }
        comVideoRoom.setPList(pvr);
        return Result.success(Result.SUCCESS_QUERY_MSG,comVideoRoom);
    }

    /**
     * <b> 保存调度记录信息 </b>
     * @author ZXF
     * @create 2020/06/22 0022 10:41
     * @version
     * @注意事项 </b>
     */
    public Result insertComVideoRoom(ComVideoRoom comVideoRoom) {
        comVideoRoomMapper.insertComVideoRoom(comVideoRoom);
        return Result.success(Result.SUCCESS);
    }

    /**
     * <b> 设置结束时间 </b>
     * @author ZXF
     * @create 2020/06/22 0022 10:41
     * @version
     * @注意事项 </b>
     */
    public Result updateEndTime(ComVideoRoom comVideoRoom) {
        if(StringUtils.isEmpty(comVideoRoom.getRoomNo())){
            return Result.fail("roomNo不能为空");
        }
        comVideoRoom = comVideoRoomMapper.getByRoomNo(comVideoRoom.getRoomNo());
        if(comVideoRoom == null){
            return Result.fail("房间不存在");
        }
        comVideoRoom.setEndTime(new Date());
        comVideoRoomMapper.updateEndTime(comVideoRoom);
        return Result.success(Result.SUCCESS_QUERY_MSG);
    }
}