package com.bcxin.ars.service;

import java.io.File;
import java.util.Date;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.model.SecurityCompany;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-service.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class SecurityCompanyServiceTest {
	
	@Autowired
	private SecurityCompanyService companyService;
	
	@Before
	public void before() {
		File file = new File("D:/data/ars/test/");
		if(!file.exists()) {
			file.mkdirs();
		}
	}
	
	@Test
	public void testBuildTemplate() throws Exception {
		File file = new File("C:/data/ars/test/" + new Date().getTime() + "_人员导入模板.xls");
		SecurityCompany company = new SecurityCompany();
		company.setId(62l);
		companyService.buildTemplate(company, file);
	}

}
