package com.bcxin.ars.service;

import java.util.List;
import java.util.Map;

import com.bcxin.ars.model.sys.Syscode;
import com.bcxin.ars.service.sys.SyscodeService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.model.Native;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-service.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class NativeServiceTest {
	
	private Logger logger = LoggerFactory.getLogger(NativeServiceTest.class);

	@Autowired
	private NativeService nativeService;

	@Test
	public void testFindAll() {
		Map<Long, List<Native>> result = nativeService.findMap();
		Assert.assertTrue(result.size() > 0);
		List<Native> province = result.get(0l);
		for(Native p : province) {
			logger.info(p.getNativeName());
			List<Native> city = result.get(p.getCode());
			if(city != null) {
				for(Native c : city) {
					logger.info("******" + c.getNativeName());
					List<Native> area = result.get(c.getCode());
					if(area != null) {
						for(Native a : area) {
							logger.info("============" + a.getNativeName());
						}
					}
				}
			}
		}
	}


}
