package com.bcxin.ars.service.util;

import cn.jiguang.common.utils.StringUtils;
import com.abcxin.smart.activiti.WorkFlow;
import com.abcxin.smart.activiti.impl.WorkFlowImpl;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dto.approve.ApproveAreaProDetailDto;
import com.bcxin.ars.dto.approve.ApproveProcessDto;
import com.bcxin.ars.dto.approve.ApproveTempLinkRelaDto;
import com.bcxin.ars.model.Activiti.ActivitiProcess;
import com.bcxin.ars.model.Activiti.ActivitiSequenceFlow;
import com.bcxin.ars.model.Activiti.ActivitiTask;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.approve.ApproveAreaProcess;
import com.bcxin.ars.model.approve.ApproveLinkProDetail;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;

/**
 * 动态生成Activity工作流配置信息
 *
 * @author Administrator
 *
 */
public class ApprovalActivityUtil {

	private static Logger logger = LoggerFactory.getLogger(ApprovalActivityUtil.class);

	/***
	 * 主干流程
	 *
	 * @param approveTempLinkRelaDtos
	 *            一级流程集合
	 * @param processID
	 *            流程唯一标识ID
	 * @param processName
	 *            流程名称
	 * @return
	 */
	public static String oneJson(List<ApproveTempLinkRelaDto> approveTempLinkRelaDtos, String processID,
			String processName, String groupId) throws Exception {
		ActivitiProcess activitiProcess = new ActivitiProcess();
		activitiProcess.setProcessID(processID);
		activitiProcess.setProcessName(processName + "流程配置信息");
		/**
		 * 任务集合
		 */
		List<ActivitiTask> tasks = new ArrayList<>();
		ActivitiTask task = new ActivitiTask();
		/**
		 * 连线集合
		 */
		List<ActivitiSequenceFlow> flows = new ArrayList<ActivitiSequenceFlow>();
		ActivitiSequenceFlow flow = new ActivitiSequenceFlow();
		flow.setFrom("startEvent");
		flow.setTo("task1");
		flows.add(flow);

		task = new ActivitiTask();
		task.setTaskType("1");
		task.setId("task1");
		task.setName("发起申请");
		tasks.add(task);
		int tasknumble = 2;

		flow = new ActivitiSequenceFlow();
		flow.setFrom("task1");
		flow.setTo("task2");
		flows.add(flow);

		// 判断特殊节点：缴费确认下一个节点是不是考试安排，如果是则节点ID改成payConfig
		int index = 0;
		for (ApproveTempLinkRelaDto approveTempLinkRelaDto : approveTempLinkRelaDtos) {
			/**
			 * 任务集合
			 */
			//增加时间戳，避免processID重复
			long ct = System.currentTimeMillis();
			// 考试安排特殊处理
			if (StringUtil.equals(approveTempLinkRelaDto.getLinkType(), Constants.APPROVAL_NUM_KS)) {

				// 生成特殊的子节点
				specialThirdJson(processName, "考试安排", "exam"+ct, approveTempLinkRelaDto.getLinkType(),
						approveTempLinkRelaDto.getLinkName(), "999");

				task = new ActivitiTask();
				task.setTaskType("3");
				task.setChildTaskId("process-exam"+ct);
				task.setId("payConfig");
				task.setName(approveTempLinkRelaDto.getLinkName());
				task.setCandidateGroup("exam");
				tasks.add(task);

				// 增加任务 通过与不通过的分支
				task = new ActivitiTask();
				task.setTaskType("2");
				task.setId("gateway" + tasknumble);
				tasks.add(task);

				// 如果有考试安排上最后的flow要修改
				if (!StringUtil.equals(approveTempLinkRelaDtos.get(index - 1).getLinkType(),
						Constants.APPROVAL_NUM_JF)) {
					// 缴费确认环节与考试安排环节不相邻
					flows.get(flows.size() - 1).setTo("payConfig");
					flow = new ActivitiSequenceFlow();
					flow.setFrom("payConfig");
					flow.setTo("gateway" + tasknumble);
					flows.add(flow);
				} else {
					// 缴费确认环节与考试安排环节相邻
					flow = new ActivitiSequenceFlow();
					flow.setFrom("payConfig");
					flow.setTo("gateway" + tasknumble);
					flow.setName("通过");
					flow.setConditionExpression("${msg=='通过'}");
					flows.add(flow);
				}

				// 如果有考试安排需要在发起申请的时候增加人物 通过与不通过的分支
				// 原本的连线去除
				flows.remove(1);

				// 增加节点
				task = new ActivitiTask();
				task.setTaskType("2");
				task.setId("gateway1");
				tasks.add(task);

				flow = new ActivitiSequenceFlow();
				flow.setFrom("task1");
				flow.setTo("gateway1");
				flows.add(flow);

				flow = new ActivitiSequenceFlow();
				flow.setFrom("gateway1");
				flow.setTo("task2");
				flow.setName("未考试");
				flow.setConditionExpression("${testState!='1'}");
				flows.add(flow);

				// 未通过直接结束流程
				flow = new ActivitiSequenceFlow();
				flow.setFrom("gateway" + tasknumble);
				flow.setTo("endEvent");
				flow.setName("不通过");
				flow.setConditionExpression("${msg=='不通过'}");
				flows.add(flow);

				flow = new ActivitiSequenceFlow();
				flow.setFrom("gateway1");
				flow.setTo("task" + (tasknumble + 1));
				flow.setName("已考试");
				flow.setConditionExpression("${testState=='1'}");
				flows.add(flow);

				flow = new ActivitiSequenceFlow();
				flow.setFrom("gateway" + tasknumble);
				flow.setTo("task" + (tasknumble + 1));
				flow.setName("通过");
				flow.setConditionExpression("${msg=='通过'}");
				flows.add(flow);

				tasknumble++;

				// 缴费确认特殊处理
			}else if (StringUtil.equals(approveTempLinkRelaDto.getLinkType(), Constants.APPROVAL_NUM_JF)) {

				// 生成特殊的子节点
				specialThirdJson(processName, "缴费确认", "payment"+ct, approveTempLinkRelaDto.getLinkType(),
						approveTempLinkRelaDto.getLinkName(), "00499");

				task = new ActivitiTask();
				task.setTaskType("3");
				task.setChildTaskId("process-payment"+ct);
				task.setId("task" + tasknumble);
				task.setName(approveTempLinkRelaDto.getLinkName());
				task.setCandidateGroup("payment");
				tasks.add(task);

				flow = new ActivitiSequenceFlow();
				flow.setFrom("task" + tasknumble);
				// 判断特殊节点：“缴费确认”环节下一个环节是不是考试安排，如果是指向缴费确认环节ID改成payConfig(考试安排)
				if (index + 1 <= approveTempLinkRelaDtos.size()) {
					if (StringUtil.equals(approveTempLinkRelaDtos.get(index + 1).getLinkType(),
							Constants.APPROVAL_NUM_KS)) {
						flow.setTo("payConfig");
					} else {
						flow.setTo("task" + (tasknumble + 1));
					}
				} else {
					flow.setTo("task" + (tasknumble + 1));
				}
				flows.add(flow);

				// 下一个节点取消缴费则打回原节点
				flow = new ActivitiSequenceFlow();
				// 判断特殊节点：“缴费确认”环节下一个环节是不是考试安排，如果是指向缴费确认环节ID改成payConfig
				if (index + 1 <= approveTempLinkRelaDtos.size()) {
					if (StringUtil.equals(approveTempLinkRelaDtos.get(index + 1).getLinkType(),
							Constants.APPROVAL_NUM_KS)) {
						flow.setFrom("payConfig");
					} else {
						flow.setFrom("task" + (tasknumble + 1));
					}
				} else {
					flow.setFrom("task" + (tasknumble + 1));
				}
				flow.setTo("task" + tasknumble);
				flow.setName("取消缴费");
				flow.setConditionExpression("${msg=='取消缴费'}");
				flows.add(flow);

				tasknumble++;
				// 报名确认，
			}
			else if (StringUtil.equals(approveTempLinkRelaDto.getLinkType(), Constants.APPROVAL_NUM_BM)) {
				// 生成特殊的子节点
				specialThirdJson(processName, "报名确认", "signup"+ct, approveTempLinkRelaDto.getLinkType(),
						approveTempLinkRelaDto.getLinkName(), "00497");

				task = new ActivitiTask();
				task.setTaskType("3");
				task.setChildTaskId("process-signup"+ct);
				task.setId("task" + tasknumble);
				task.setCandidateGroup("signup");
				task.setName(approveTempLinkRelaDto.getLinkName());
				tasks.add(task);

				// 报名通过才能走下一个节点

				flow = new ActivitiSequenceFlow();
				flow.setFrom("task" + tasknumble);
				flow.setTo("task" + (tasknumble + 1));
				flow.setName("通过");
				flow.setConditionExpression("${msg=='通过'}");
				flows.add(flow);

				tasknumble++;
				// 指纹获取处理
			}
			else if (StringUtil.equals(approveTempLinkRelaDto.getLinkType(), Constants.APPROVAL_NUM_ZW)) {
				// 生成特殊的子节点
				specialThirdJson(processName, "指纹获取处理", "fingerprint"+ct, approveTempLinkRelaDto.getLinkType(),
						approveTempLinkRelaDto.getLinkName(), "00498");

				task = new ActivitiTask();
				task.setTaskType("3");
				task.setChildTaskId("process-fingerprint"+ct);
				task.setId("task" + tasknumble);
				task.setCandidateGroup("fingerprint");
				task.setName(approveTempLinkRelaDto.getLinkName());
				tasks.add(task);

				// 只有通过的分支没有不通过

				flow = new ActivitiSequenceFlow();
				flow.setFrom("task" + tasknumble);
				flow.setTo("task" + (tasknumble + 1));
				flows.add(flow);

				tasknumble++;
			}
			else if (StringUtil.equals(approveTempLinkRelaDto.getLinkType(), Constants.APPROVAL_NUM_ZPMJ)) {
				// 指派民警
				// 生成特殊的子节点
				specialThirdJson(processName, Constants.APPROVAL_NAME_ZPMJ, Constants.ACTIVITI_ASSIGNPOLICE,
						approveTempLinkRelaDto.getLinkType(), approveTempLinkRelaDto.getLinkName(), groupId);

				task = new ActivitiTask();
				task.setTaskType(Constants.ACTIVITI_TASKTYPE3);
				task.setChildTaskId(Constants.ACTIVITI_PROCESS + Constants.CROSSBAR + Constants.ACTIVITI_ASSIGNPOLICE);
				task.setId(Constants.ACTIVITI_TASK + tasknumble);
				task.setCandidateGroup(Constants.ACTIVITI_ASSIGNPOLICE);
				task.setName(approveTempLinkRelaDto.getLinkName());
				tasks.add(task);

				// 2018年6月12日13:09:42指派民警 通过与不通过的分支
				task = new ActivitiTask();
				task.setTaskType(Constants.ACTIVITI_TASKTYPE2);
				task.setId(Constants.ACTIVITI_GATEWAY + tasknumble);
				tasks.add(task);

				flow = new ActivitiSequenceFlow();
				flow.setFrom(Constants.ACTIVITI_TASK + tasknumble);
				flow.setTo(Constants.ACTIVITI_GATEWAY + tasknumble);
				flows.add(flow);

				flow = new ActivitiSequenceFlow();
				flow.setFrom(Constants.ACTIVITI_GATEWAY + tasknumble);
				flow.setTo("task1");
				flow.setName("不通过");
				flow.setConditionExpression("${msg=='不通过'}");
				flows.add(flow);

				flow = new ActivitiSequenceFlow();
				flow.setFrom(Constants.ACTIVITI_GATEWAY + tasknumble);
				flow.setTo(Constants.ACTIVITI_TASK + (tasknumble + 1));
				flow.setName("通过");
				flow.setConditionExpression("${msg=='通过'}");
				flows.add(flow);

				tasknumble++;
			}
			else {
				task = new ActivitiTask();
				task.setTaskType("3");
				task.setId("task" + tasknumble);
				task.setName(approveTempLinkRelaDto.getLinkName());
				task.setChildTaskId("process-" + approveTempLinkRelaDto.getApproveAreaProId().toString());
				tasks.add(task);

				// 增加任务 通过与不通过的分支
				task = new ActivitiTask();
				task.setTaskType(Constants.ACTIVITI_TASKTYPE2);
				task.setId(Constants.ACTIVITI_GATEWAY + tasknumble);
				tasks.add(task);

				flow = new ActivitiSequenceFlow();
				flow.setFrom(Constants.ACTIVITI_TASK + tasknumble);
				flow.setTo(Constants.ACTIVITI_GATEWAY + tasknumble);
				flows.add(flow);

				flow = new ActivitiSequenceFlow();
				flow.setFrom(Constants.ACTIVITI_GATEWAY + tasknumble);
				flow.setTo("task1");
				flow.setName("不通过");
				flow.setConditionExpression("${msg=='不通过'}");
				flows.add(flow);

				flow = new ActivitiSequenceFlow();
				flow.setFrom(Constants.ACTIVITI_GATEWAY + tasknumble);
				flow.setTo(Constants.ACTIVITI_TASK + (tasknumble + 1));
				flow.setName("通过");
				flow.setConditionExpression("${msg=='通过'}");
				flows.add(flow);

				tasknumble++;
			}
			index++;
		}
		// 如果最后为指纹获取处理
		if (StringUtil.isEmpty(flows.get(flows.size() - 1).getName())) {
			flows.remove(flows.size() - 1);
			flow = new ActivitiSequenceFlow();
			flow.setFrom("task" + (tasknumble - 1));
			flow.setTo("endEvent");
			flows.add(flow);
		} else {
			flows.remove(flows.size() - 1);
			flow = new ActivitiSequenceFlow();
			flow.setFrom("gateway" + (tasknumble - 1));
			flow.setConditionExpression("${msg=='通过'}");
			flow.setName("通过");
			flow.setTo("endEvent");
			flows.add(flow);
		}
		// 如果有考试安排在最后的flow要修改
		if (StringUtil.equals(flows.get(flows.size() - 2).getName(), "已考试")) {
			flows.get(flows.size() - 2).setTo("endEvent");
		}

		activitiProcess.setTasks(tasks);
		activitiProcess.setFlows(flows);
		String processJson = JSON.toJSONString(activitiProcess);
		logger.debug(processJson);
		WorkFlow workFlow = new WorkFlowImpl();
		try {
			workFlow.createProess(processJson);
		} catch (Exception e) {
			logger.error(e.getMessage(),e);
			throw new Exception(e.getMessage());
		}
		return processJson;
	}

	/**
	 * 一级子流程
	 *
	 * @param approveProcessDto
	 * @param approveLinkProDetail
	 * @return
	 */
	public static String secondJson(ApproveProcessDto approveProcessDto, ApproveLinkProDetail approveLinkProDetail,
			ApproveTempLinkRelaDto approveTempLinkRelaDto) throws Exception {
		ActivitiProcess activitiProcess = new ActivitiProcess();
		activitiProcess.setProcessID("process-" + approveLinkProDetail.getId().toString());
		activitiProcess.setProcessName(approveTempLinkRelaDto.getTempName() + "-" + approveTempLinkRelaDto.getLinkName()
				+ approveProcessDto.getMinOrgname() + "流程明细信息一级");
		/**
		 * 任务集合
		 */
		List<ActivitiTask> tasks = new ArrayList<>();
		ActivitiTask task = new ActivitiTask();
		/**
		 * 连线集合
		 */
		List<ActivitiSequenceFlow> flows = new ArrayList<ActivitiSequenceFlow>();
		ActivitiSequenceFlow flow = new ActivitiSequenceFlow();
		flow.setFrom("startEvent");
		flow.setTo("task1");
		// flow.setName("开始流程");
		flows.add(flow);

		int tasknumble = 1;

		Long provinceApproveAreaProcessId = approveProcessDto.getpApproveAreaProcess();
		Long cityApproveAreaProcessId = approveProcessDto.getcApproveAreaProcess();
		Long areaApproveAreaProcessId = approveProcessDto.getaApproveAreaProcess();
		Long gajApproveAreaProcessId = approveProcessDto.getgApproveAreaProcess();
		// 2 从最低级开始
		if (gajApproveAreaProcessId != null) {
			task = new ActivitiTask();
			task.setTaskType("3");
			task.setId("task" + tasknumble);
			task.setName("第" + tasknumble + "级审批");
			task.setChildTaskId("process-" + gajApproveAreaProcessId.toString());
			tasks.add(task);

			flow = new ActivitiSequenceFlow();
			flow.setFrom("task" + tasknumble);
			flow.setTo("task" + (tasknumble + 1));
			flows.add(flow);
			tasknumble++;
		}
		if (areaApproveAreaProcessId != null) {
			task = new ActivitiTask();
			task.setTaskType("3");
			task.setId("task" + tasknumble);
			task.setName("第" + tasknumble + "级审批");
			task.setChildTaskId("process-" + areaApproveAreaProcessId.toString());
			tasks.add(task);

			flow = new ActivitiSequenceFlow();
			flow.setFrom("task" + tasknumble);
			flow.setTo("task" + (tasknumble + 1));
			flows.add(flow);
			tasknumble++;
		}
		if (cityApproveAreaProcessId != null) {
			task = new ActivitiTask();
			task.setTaskType("3");
			task.setId("task" + tasknumble);
			task.setName("第" + tasknumble + "级审批");
			task.setChildTaskId("process-" + cityApproveAreaProcessId.toString());
			tasks.add(task);

			flow = new ActivitiSequenceFlow();
			flow.setFrom("task" + tasknumble);
			flow.setTo("task" + (tasknumble + 1));
			flows.add(flow);
			tasknumble++;
		}
		if (provinceApproveAreaProcessId != null) {
			task = new ActivitiTask();
			task.setTaskType("3");
			task.setId("task" + tasknumble);
			task.setName("第" + tasknumble + "级审批");
			task.setChildTaskId("process-" + provinceApproveAreaProcessId.toString());
			tasks.add(task);

			flow = new ActivitiSequenceFlow();
			flow.setFrom("task" + tasknumble);
			flow.setTo("task" + (tasknumble + 1));
			flows.add(flow);
			tasknumble++;
		}

		flows.remove(flows.size() - 1);
		flow = new ActivitiSequenceFlow();
		flow.setFrom("task" + (tasknumble - 1));
		flow.setTo("endEvent");
		flows.add(flow);
		activitiProcess.setTasks(tasks);
		activitiProcess.setFlows(flows);

		String processJson = JSON.toJSONString(activitiProcess);
		WorkFlow workFlow = new WorkFlowImpl();
		try {
			workFlow.createProess(processJson);
		} catch (Exception e) {
			logger.error(e.getMessage(),e);
			throw new Exception(e.getMessage());
		}
		return processJson;
	}

	/**
	 * 二级子流程修改s
	 *
	 * @param approveAreaProcessList
	 */

	public static void thirdJsonUpdate(List<ApproveAreaProcess> approveAreaProcessList) throws Exception {

		ApproveAreaProcess approveAreaProcess = approveAreaProcessList.get(0);
		ActivitiProcess activitiProcess = JSON.parseObject(approveAreaProcess.getProcessInfo(), ActivitiProcess.class);

		// 将最后一个task的ID 修改为"annals"
		List<ActivitiTask> tasks = activitiProcess.getTasks();
		List<ActivitiSequenceFlow> flows = activitiProcess.getFlows();
		tasks.get(tasks.size() - 2).setId("annals");
		// 将倒数第三和第四条连线修改
		flows.get(flows.size() - 3).setFrom("annals");
		flows.get(flows.size() - 4).setTo("annals");
		String processJson = JSON.toJSONString(activitiProcess);
		WorkFlow workFlow = new WorkFlowImpl();
		try {
			workFlow.createProess(processJson);
		} catch (Exception e) {
			logger.error(e.getMessage(),e);
			throw new Exception(e.getMessage());
		}

		// 倒数第二层可能为之前的最后一层
		if (approveAreaProcessList.size() > 1) {
			ApproveAreaProcess approveAreaProcess2 = approveAreaProcessList.get(1);
			ActivitiProcess activitiProcess2 = JSON.parseObject(approveAreaProcess2.getProcessInfo(),
					ActivitiProcess.class);
			List<ActivitiTask> tasks2 = activitiProcess2.getTasks();
			List<ActivitiSequenceFlow> flows2 = activitiProcess2.getFlows();
			// 节点的数量（类型为1）
			String number = String.valueOf(tasks2.size() / 2);
			// 将倒数第二个Id进行修改
			tasks2.get(tasks2.size() - 2).setId("task" + number);
			// 将倒数第三和第四条连线修改
			flows2.get(flows2.size() - 3).setFrom("task" + number);
			flows2.get(flows2.size() - 4).setTo("task" + number);
			String processJson2 = JSON.toJSONString(activitiProcess2);
			WorkFlow workFlow2 = new WorkFlowImpl();
			try {
				workFlow2.createProess(processJson2);
			} catch (Exception e) {
				logger.error(e.getMessage(),e);
				throw new Exception(e.getMessage());
			}
		}
	}

	/**
	 * 二级子流程生成特殊环节类型 报名确认 缴费确认 指纹获取 考试安排 指派民警
	 *
	 * @return
	 */
	public static void specialThirdJson(String processName, String specialName, String specialNameId, String linkType,
			String LinkName, String groupId) throws Exception {

		if (StringUtil.isEmpty(groupId)) {
			groupId = "999";
		}
		ActivitiProcess activitiProcess = new ActivitiProcess();
		activitiProcess.setProcessID("process-" + specialNameId);
		activitiProcess.setProcessName(processName + specialName + "流程配置信息二级");

		List<ActivitiTask> tasks = new ArrayList<>();
		ActivitiTask task = new ActivitiTask();
		// 任务数目标志
		/**
		 * 连线集合
		 */
		List<ActivitiSequenceFlow> flows = new ArrayList<ActivitiSequenceFlow>();
		ActivitiSequenceFlow flow = new ActivitiSequenceFlow();

		flow.setFrom("startEvent");
		flow.setTo(specialNameId);
		// flow.setName("开始流程");
		flows.add(flow);

		task = new ActivitiTask();
		task.setTaskType(Constants.ACTIVITI_TASKTYPE1);
		task.setId(specialNameId);
		task.setName(LinkName);
		task.setCandidateGroup(groupId);
		tasks.add(task);

		if (Constants.APPROVAL_NUM_ZPMJ.equals(linkType)) {
			// 指派民警特殊处理 增加民警审批环节
			flow = new ActivitiSequenceFlow();
			flow.setFrom(specialNameId);
			flow.setTo(Constants.ACTIVITI_POLICEMAN);
			flows.add(flow);

			int tasknumble = 1;
			task = new ActivitiTask();
			task.setTaskType(Constants.ACTIVITI_TASKTYPE1);
			task.setId(Constants.ACTIVITI_POLICEMAN);
			task.setCandidateGroup(Constants.ACTIVITI_POLICEMAN);
			task.setName(Constants.APPROVAL_NAME_MJ);
			tasks.add(task);

			// 增加任务 通过与不通过的分支
			task = new ActivitiTask();
			task.setTaskType(Constants.ACTIVITI_TASKTYPE2);
			task.setId(Constants.ACTIVITI_GATEWAY + tasknumble);
			tasks.add(task);

			flow = new ActivitiSequenceFlow();
			flow.setFrom(Constants.ACTIVITI_POLICEMAN);
			flow.setTo(Constants.ACTIVITI_GATEWAY + tasknumble);
			flows.add(flow);

			flow = new ActivitiSequenceFlow();
			flow.setFrom(Constants.ACTIVITI_GATEWAY + tasknumble);
			flow.setTo("endEvent");
			flow.setName("不通过");
			flow.setConditionExpression("${msg=='不通过'}");
			flows.add(flow);

			flow = new ActivitiSequenceFlow();
			flow.setFrom(Constants.ACTIVITI_GATEWAY + tasknumble);
			flow.setTo("endEvent");
			flow.setName("通过");
			flow.setConditionExpression("${msg=='通过'}");
			flows.add(flow);
		} else {
			flow = new ActivitiSequenceFlow();
			flow.setFrom(specialNameId);
			flow.setTo("endEvent");
			flows.add(flow);
		}

		activitiProcess.setTasks(tasks);
		activitiProcess.setFlows(flows);
		String processJson = JSON.toJSONString(activitiProcess);
		WorkFlow workFlow = new WorkFlowImpl();
		try {
			workFlow.createProess(processJson);
		} catch (Exception e) {
			logger.error(e.getMessage(),e);
			throw new Exception(e.getMessage());
		}
	}

	/**
	 * 二级子流程
	 *
	 * @param approveAreaProDetailDtoList
	 * @param approveAreaProcess
	 * @param police
	 * @return
	 */
	public static String thirdJson(List<ApproveAreaProDetailDto> approveAreaProDetailDtoList,
			ApproveAreaProcess approveAreaProcess, Police police, ApproveTempLinkRelaDto approveTempLinkRelaDto)
			throws Exception {

		ActivitiProcess activitiProcess = new ActivitiProcess();
		activitiProcess.setProcessID("process-" + approveAreaProcess.getId().toString());
		activitiProcess.setProcessName(approveTempLinkRelaDto.getTempName() + "-" + approveTempLinkRelaDto.getLinkName()
				+ police.getOrgname() + "流程配置信息二级");
		/**
		 * 任务集合
		 */
		List<ActivitiTask> tasks = new ArrayList<>();
		ActivitiTask task = new ActivitiTask();
		// 任务数目标志
		int tasknumble = 1;
		/**
		 * 连线集合
		 */
		List<ActivitiSequenceFlow> flows = new ArrayList<ActivitiSequenceFlow>();
		ActivitiSequenceFlow flow = new ActivitiSequenceFlow();

		flow.setFrom("startEvent");
		flow.setTo("task1");
		// flow.setName("开始流程");
		flows.add(flow);
		// 3 插入节点和线
		for (ApproveAreaProDetailDto approveAreaProDetailDto : approveAreaProDetailDtoList) {
			// 3.1多人审批规则
			// 流转
			if (StringUtil.equals(approveAreaProDetailDto.getManyApproveRule(), Constants.APPROVAL_RULES_CIRCULATION)) {
				// 或签
				String perIds = "";
				for (String perId : approveAreaProDetailDto.getPerIds().split(",")) {
					perIds = perIds + perId + ",";
				}
				if (StringUtils.isNotEmpty(perIds)) {
					perIds = perIds.substring(0, perIds.length() - 1);
				}
				task = new ActivitiTask();
				task.setTaskType("1");
				task.setId("task" + tasknumble);
				task.setName(approveAreaProDetailDto.getPositionName());
				task.setCandidateGroup(perIds);
				tasks.add(task);
				task = new ActivitiTask();
				task.setTaskType("2");
				task.setId("gateway" + tasknumble);
				tasks.add(task);

				flow = new ActivitiSequenceFlow();
				flow.setFrom("task" + tasknumble);
				flow.setTo("gateway" + tasknumble);
				flows.add(flow);

				flow = new ActivitiSequenceFlow();
				flow.setFrom("gateway" + tasknumble);
				flow.setTo("endEvent");
				flow.setName("不通过");
				flow.setConditionExpression("${msg=='不通过'}");
				flows.add(flow);

				flow = new ActivitiSequenceFlow();
				flow.setFrom("gateway" + tasknumble);
				flow.setTo("task" + (tasknumble + 1));
				flow.setName("通过");
				flow.setConditionExpression("${msg=='通过'}");
				flows.add(flow);
				tasknumble++;
			} else if (StringUtil.equals(approveAreaProDetailDto.getManyApproveRule(),
					Constants.APPROVAL_RULES_COUNTERSIGN)) {
				// 会签
				for (String perId : approveAreaProDetailDto.getPerIds().split(",")) {
					task = new ActivitiTask();
					task.setTaskType("1");
					task.setId("task" + tasknumble);
					task.setName(approveAreaProDetailDto.getPositionName());
					task.setCandidateGroup(perId);
					tasks.add(task);

					task = new ActivitiTask();
					task.setTaskType("2");
					task.setId("gateway" + tasknumble);
					tasks.add(task);

					flow = new ActivitiSequenceFlow();
					flow.setFrom("task" + tasknumble);
					flow.setTo("gateway" + tasknumble);
					flows.add(flow);

					flow = new ActivitiSequenceFlow();
					flow.setFrom("gateway" + tasknumble);
					flow.setTo("endEvent");
					flow.setName("不通过");
					flow.setConditionExpression("${msg=='不通过'}");
					flows.add(flow);

					flow = new ActivitiSequenceFlow();
					flow.setFrom("gateway" + tasknumble);
					flow.setTo("task" + (tasknumble + 1));
					flow.setName("通过");
					flow.setConditionExpression("${msg=='通过'}");
					flows.add(flow);
					tasknumble++;
				}
			} else if (StringUtil.equals(approveAreaProDetailDto.getManyApproveRule(),
					Constants.APPROVAL_RULES_OR_CHECK)) {
				// 或签
				String perIds = "";
				for (String perId : approveAreaProDetailDto.getPerIds().split(",")) {
					perIds = perIds + perId + ",";
				}
				if (StringUtils.isNotEmpty(perIds)) {
					perIds = perIds.substring(0, perIds.length() - 1);
				}
				task = new ActivitiTask();
				task.setTaskType("1");
				task.setId("task" + tasknumble);
				task.setName(approveAreaProDetailDto.getPositionName());
				task.setCandidateGroup(perIds);
				tasks.add(task);
				task = new ActivitiTask();
				task.setTaskType("2");
				task.setId("gateway" + tasknumble);
				tasks.add(task);

				flow = new ActivitiSequenceFlow();
				flow.setFrom("task" + tasknumble);
				flow.setTo("gateway" + tasknumble);
				flows.add(flow);

				flow = new ActivitiSequenceFlow();
				flow.setFrom("gateway" + tasknumble);
				flow.setTo("endEvent");
				flow.setName("不通过");
				flow.setConditionExpression("${msg=='不通过'}");
				flows.add(flow);

				flow = new ActivitiSequenceFlow();
				flow.setFrom("gateway" + tasknumble);
				flow.setTo("task" + (tasknumble + 1));
				flow.setName("通过");
				flow.setConditionExpression("${msg=='通过'}");
				flows.add(flow);
				tasknumble++;

			} else {
				task = new ActivitiTask();
				task.setTaskType("1");
				task.setId("task" + tasknumble);
				task.setName(approveAreaProDetailDto.getPositionName());
				task.setCandidateGroup(approveAreaProDetailDto.getPerIds());
				tasks.add(task);

				task = new ActivitiTask();
				task.setTaskType("2");
				task.setId("gateway" + tasknumble);
				tasks.add(task);

				flow = new ActivitiSequenceFlow();
				flow.setFrom("task" + tasknumble);
				flow.setTo("gateway" + tasknumble);
				flows.add(flow);

				flow = new ActivitiSequenceFlow();
				flow.setFrom("gateway" + tasknumble);
				flow.setTo("endEvent");
				flow.setName("不通过");
				flow.setConditionExpression("${msg=='不通过'}");
				flows.add(flow);

				flow = new ActivitiSequenceFlow();
				flow.setFrom("gateway" + tasknumble);
				flow.setTo("task" + (tasknumble + 1));
				flow.setName("通过");
				flow.setConditionExpression("${msg=='通过'}");
				flows.add(flow);

				tasknumble++;

			}
		}
		flows.remove(flows.size() - 1);
		flow = new ActivitiSequenceFlow();
		flow.setFrom("gateway" + (tasknumble - 1));
		flow.setTo("endEvent");
		flow.setName("通过");
		flow.setConditionExpression("${msg=='通过'}");
		flows.add(flow);
		activitiProcess.setTasks(tasks);
		activitiProcess.setFlows(flows);
		String processJson = JSON.toJSONString(activitiProcess);
		WorkFlow workFlow = new WorkFlowImpl();
		try {
			workFlow.createProess(processJson);
		} catch (Exception e) {
			logger.error(e.getMessage(),e);
			throw new Exception(e.getMessage());
		}
		return processJson;
	}

}
