package com.bcxin.ars.service.singleLogin.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.singleLogin.SingleUserDTO;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.gx.SingleLoginResponseResult;
import com.bcxin.ars.service.impl.SingleUserLoginBaseServiceImpl;
import com.bcxin.ars.service.singleLogin.SingleLoginService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.HttpClientUtils;
import com.bcxin.ars.util.NNRESTFulConstants;
import com.bcxin.ars.util.StringUtil;
import com.bjtoon.uia.sdk.exception.UiaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;

/***
 * 南宁单点登陆实现层
 */
@Service("singleLoginServiceNNImpl")
@Transactional
public class SingleLoginServiceNNImpl extends SingleUserLoginBaseServiceImpl implements SingleLoginService {
    /**
     * 缓存
     */
    @Autowired
    private ConfigUtils configUtils;
    /***
     * 日志
     */
    private static Logger logger = LoggerFactory.getLogger(SingleLoginServiceNNImpl.class);
    @Override
    public User getUserInfo(SingleUserDTO userInfo) {
        //查询是否存在sql中 不存在添加
        User user = null;
        /**
         * 消息
         */
        String accessToken = "";
        try {
            //获取token
            accessToken =  getAccessToken(null) ;
            if (StringUtil.isNotEmpty(accessToken)){
                //设置凭证
                userInfo.setAccessToken(accessToken);
                SingleLoginResponseResult singleLoginResponseResult = getAuthentication(userInfo);
                if (singleLoginResponseResult!=null && NNRESTFulConstants.CODE_SUCCESS.equals(singleLoginResponseResult.getCode())) {
                    //根据认证中心的user获取用户信息
                    user  = super.findByUsername(userInfo.getUser(),String.valueOf(Constants.PLATFORM_POLICE));
                }
            }
        } catch (UiaException e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return user;
    }
    /***
     * 获取认证信息
     * @return
     */
    public SingleLoginResponseResult getAuthentication(SingleUserDTO userInfo){
        SingleLoginResponseResult singleLoginResponseResult = null;
        try {
            String url =configUtils.getValueByKey(NNRESTFulConstants.NNSINGLELOGINURL)+ NNRESTFulConstants.AUTH;
            HashMap<String, Object> paramMap = new HashMap<>();
            paramMap.put("clientId", configUtils.getValueByKey(NNRESTFulConstants.NNCLIENTID));
            paramMap.put("access_token", userInfo.getAccessToken());
            paramMap.put("sign",userInfo.getSign());
            paramMap.put("key", userInfo.getKey());
            paramMap.put("loginName",userInfo.getLoginName());
            String json = HttpClientUtils.doPostByBody(url,paramMap);
            singleLoginResponseResult =  JSON.parseObject(json, SingleLoginResponseResult.class);
        } catch (UiaException e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return singleLoginResponseResult;

    }
    /***
     * 获取凭证
     * @return
     */
    @Override
    public String getAccessToken(String code){
        String tokenMsg ="";
        //核心请求客户端，构建后可复用
        try {
            String url =configUtils.getValueByKey(NNRESTFulConstants.NNSINGLELOGINURL)+ NNRESTFulConstants.TOKEN;
            HashMap<String, Object> paramMap = new HashMap<>();
            paramMap.put("clientId", configUtils.getValueByKey(NNRESTFulConstants.NNCLIENTID));
            paramMap.put("clientSecret",configUtils.getValueByKey(NNRESTFulConstants.NNCLIENTSECRET));
            String json = HttpClientUtils.doPostByBody(url,paramMap);
            SingleLoginResponseResult singleLoginResponseResult =  JSON.parseObject(json, SingleLoginResponseResult.class);
            if("200".equals(singleLoginResponseResult.getCode())){
                tokenMsg = singleLoginResponseResult.getData();
            }
        } catch (UiaException e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return tokenMsg;
    }
    @Override
    public AjaxResult handle(SingleUserDTO dto,HttpServletRequest request) {
        return login(dto,request);
    }
    /***
     * 登陆
     */
    @Override
    public AjaxResult login(SingleUserDTO userInfo,HttpServletRequest request) {
        /**
         *  1.获取第三方单点登陆的用户信息
         */
        User u =  getUserInfo(userInfo);
        if(u==null){
            return new AjaxResult(false,"失败");
        }else {
            /**
             * 2.登陆
             */
            return webLogin(u.getUsername(), u.getPassword(), u.getPlatform(), Constants.GX_NW_Code,request);
        }
    }
}
