package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.TrainChangeworkexperienceDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.TrainChangeworkexperienceSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.TrainChangeworkexperience;
import com.bcxin.ars.service.sb.TrainChangeworkexperienceService;
import com.bcxin.ars.service.util.ArsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = TrainChangeworkexperience.class)
public class TrainChangeworkexperienceServiceImpl implements TrainChangeworkexperienceService{

	@Autowired
	private TrainChangeworkexperienceDao workexperienceDao;
	
	@Autowired
	private ArsUtil arsUtil;
	
	
	@Override
	public TrainChangeworkexperience findById(long id) {
		return workexperienceDao.findById(id);
	}

	@Override
	public void saveOrUpdate(TrainChangeworkexperience workexperience) {
		User currentUser = arsUtil.getCurrentUser();
		if(workexperience.getId() == null){
			workexperience.setActive(true);
			workexperience.setCreateTime(new Date());
			workexperience.setUpdateTime(new Date());
			workexperience.setUpdateBy(currentUser.getUsername());
			workexperienceDao.save(workexperience);
		}else{
			TrainChangeworkexperience dbTrainChangeworkexperience = workexperienceDao.findById(workexperience.getId());
			dbTrainChangeworkexperience.setUpdateTime(new Date());
			dbTrainChangeworkexperience.setCompanyname(workexperience.getCompanyname());
			dbTrainChangeworkexperience.setEnddate(workexperience.getEnddate());
			dbTrainChangeworkexperience.setPost(workexperience.getPost());
			dbTrainChangeworkexperience.setStartdate(workexperience.getStartdate());
			dbTrainChangeworkexperience.setUpdateBy(currentUser.getUsername());
			dbTrainChangeworkexperience.setUpdateTime(new Date());
			workexperienceDao.update(dbTrainChangeworkexperience);
		}
		
	}

	@Override
	public TrainChangeworkexperienceSearchDto search(TrainChangeworkexperienceSearchDto dto) {
		TrainChangeworkexperienceSearchDto resultDto = new TrainChangeworkexperienceSearchDto();
		List<TrainChangeworkexperience> list =  workexperienceDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(workexperienceDao.searchCount(dto));
		return resultDto;
	}

	@Override
	public void delete(Long workexperienceId) {
		User currentUser = arsUtil.getCurrentUser();
		TrainChangeworkexperience workexperience = workexperienceDao.findById(workexperienceId);
		workexperience.setUpdateBy(currentUser.getUsername());
		workexperience.setUpdateTime(new Date());
		workexperienceDao.delete(workexperience);
	}

	@Override
	public void deleteByTrainChangeId(Long trainChangeId) {
		User currentUser = arsUtil.getCurrentUser();
		TrainChangeworkexperience workexperience = new TrainChangeworkexperience();
		workexperience.setTrainChangeId(trainChangeId);
		workexperience.setUpdateBy(currentUser.getUsername());
		workexperience.setUpdateTime(new Date());
		workexperienceDao.deleteByTrainChangeId(workexperience);
	}

	@Override
	public List<TrainChangeworkexperience> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return workexperienceDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void saveOrUpdateForDS(TrainChangeworkexperience trainChangeworkexperience) {
		if (trainChangeworkexperience.getActive() == null){
			trainChangeworkexperience.setActive(true);
		}
		TrainChangeworkexperience dbTrainChangeworkexperience = workexperienceDao.findById(trainChangeworkexperience.getId());
        if (dbTrainChangeworkexperience != null) {
        	if(trainChangeworkexperience.getUpdateTime().getTime() > dbTrainChangeworkexperience.getUpdateTime().getTime()){
				workexperienceDao.update(trainChangeworkexperience);
			}
        } else {
        	workexperienceDao.saveForDS(trainChangeworkexperience);
        }
	}

	@Override
	public List<TrainChangeworkexperience> findByTrainChangeId(Long trainChangeId) {
		return workexperienceDao.findByTrainChangeId(trainChangeId);
	}

}
