package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.SubsidiaryDao;
import com.bcxin.ars.dao.sb.SubsidiaryDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SubsidiarySearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.sb.Subsidiary;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.SbSubsidiaryBaseService;
import com.bcxin.ars.service.sb.SubsidiaryService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import com.bcxin.ars.webservice.Bafwgsfgsglry;
import com.bcxin.ars.webservice.Bafwgsfgsxx;
import com.bcxin.ars.webservice.ClientUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Subsidiary.class)
public class SubsidiaryServiceImpl implements SubsidiaryService{
	private Logger logger = LoggerFactory.getLogger(SubsidiaryServiceImpl.class);



	@Autowired
	private SubsidiaryDao subsidiaryDao;

	@Autowired
	private SubsidiaryDaoAop subsidiaryDaoAop;

	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private PoliceDao policeDao;
	@Autowired
	private ApprovalUtil approvalUtil;
	@Autowired
	private ApprovalDAO approvalDAO;

	@Autowired
	private SecurityPersonDao securityPersonDao;

	@Autowired
	private SecurityCompanyDao securityCompanyDao;

    @Autowired
    private SbSubsidiaryBaseService sbSubsidiaryBaseService;
	@Autowired
	private ClientUtil clientUtil;
	@Override
	public Subsidiary findById(long id) {

		Subsidiary result  =  subsidiaryDao.findById(id);
		if(result!=null){
			//查询审批信息
			result.setApproval(approvalDAO.findBybusinessidAndType(result.getId(),BusinessType.BAGSZGS));

			//查询机构信息
			Police police = policeDao.findById(result.getOrgid());
			result.setPolice(police);
		}
		return result;
	}
	@Override
	public List<Subsidiary> findByBatchId(List<Approval> approvalList){
		return subsidiaryDao.findByBatchId(approvalList);
	}

	@Override
	public void saveOrUpdate(Subsidiary subsidiary) {
		User currentUser = arsUtil.getCurrentUser();
		if(currentUser.getPlatform() == 2 || currentUser.getPlatform() == 4){
			subsidiary.setUserid(currentUser.getId());
		}

		/**
		 * 最后一级机构id处理
		 */
		if(subsidiary.getOrgid() == null){
			if(subsidiary.getDistrictOrgId() != null){
				subsidiary.setOrgid(Long.parseLong(subsidiary.getDistrictOrgId()));
			}else if(subsidiary.getCityOrgId() != null){
				subsidiary.setOrgid(Long.parseLong(subsidiary.getCityOrgId()));
			}
		}

		if(subsidiary.getId() == null){
			if(!subsidiary.getApprovalstate().equals(Constants.APPROVALSTATE_WTJ)){
				//开发任务 #10165
				Subsidiary checkSubsidiary = subsidiaryDao.findApproveBySoncompanyname(subsidiary);
				if(checkSubsidiary != null){
					throw  new ArsException(subsidiary.getSoncompanyname() + "已备案，不能重复备案！");
				}
			}

			subsidiary.setActive(true);
			subsidiary.setCreateTime(new Date());
			subsidiary.setUpdateTime(new Date());
			subsidiary.setUpdateBy(currentUser.getUsername());
			//TODO
			//待审批或暂存
			subsidiaryDao.save(subsidiary);

			//TODO 保存审批信息
			if(subsidiary.getApprovalstate().equals(ApprovalState.DSH)) {
				approvalUtil.saveApproval(BusinessType.BAGSZGS,subsidiary.getId(),Constants.ACTIVITI_PROCESS_SUBSIDIARY);
			}
		}else{
			if(!subsidiary.getApprovalstate().equals(Constants.APPROVALSTATE_WTJ)){
				//开发任务 #10165
				Subsidiary checkSubsidiary = subsidiaryDao.findApproveBySoncompanyname(subsidiary);
				if(checkSubsidiary != null && checkSubsidiary.getId().longValue() != subsidiary.getId().longValue()){
					throw  new ArsException(subsidiary.getSoncompanyname() + "已备案，不能重复备案！");
				}
			}


			Subsidiary dbSubsidiary = subsidiaryDao.findById(subsidiary.getId());
			boolean activity = true;
			if(StringUtil.isNotEmpty(dbSubsidiary.getApprovalstate()) && dbSubsidiary.getApprovalstate().equals(ApprovalState.DSH)){
				if(dbSubsidiary.getOrgid().toString().equals(subsidiary.getOrgid().toString())){
					activity = false;
					if(!dbSubsidiary.getCompanyname().equals(subsidiary.getCompanyname())) {
						Approval approval = approvalDAO.findBybusinessidAndType(subsidiary.getId(), BusinessType.BAGSZGS);
						if (approval != null) {
							approvalUtil.updateContent(approval, subsidiary.getCompanyname());
						}
					}
				}
			}
			if(ApprovalState.WTJ.equals(subsidiary.getApprovalstate())){
				BeanUtils.copyPropertiesIgnore(subsidiary,dbSubsidiary,"active,createTime,userid",true);
			}else{

				BeanUtils.copyPropertiesIgnore(subsidiary,dbSubsidiary,true);
			}

			dbSubsidiary.setUpdateTime(new Date());
			dbSubsidiary.setUpdateBy(currentUser.getUsername());
			///待审批
			if(!(subsidiary.getApprovalstate()!=null &&!"".equals(subsidiary.getApprovalstate()) && !subsidiary.getApprovalstate().equals(ApprovalState.DSH))){
				dbSubsidiary.setApprovalstate(ApprovalState.DSH);
				dbSubsidiary.setChargecensorstatus("");
				dbSubsidiary.setLegalcensorstatus("");

			}
			//TODO
			//dbSubsidiary.setUserid(currentUser.getId().intValue());
			subsidiaryDaoAop.update(dbSubsidiary);
			//TODO 保存审批信息
			if(activity && ApprovalState.DSH.equals(dbSubsidiary.getApprovalstate())){
				approvalUtil.saveApproval(BusinessType.BAGSZGS,dbSubsidiary.getId(),Constants.ACTIVITI_PROCESS_SUBSIDIARY);
			}

            if(dbSubsidiary.getApprovalstate().equals(ApprovalState.SHTG)) {//V1.0.9--#5973

            	SbSubsidiaryBase sbSubsidiaryBase = new SbSubsidiaryBase();
            	sbSubsidiaryBase.setActive(true);
            	sbSubsidiaryBase.setBusinessPlace(dbSubsidiary.getProvince()+dbSubsidiary.getCity()+dbSubsidiary.getDistrict());
            	sbSubsidiaryBase.setCode(dbSubsidiary.getLicencenum());
            	sbSubsidiaryBase.setCompanyName(dbSubsidiary.getCompanyname());
            	sbSubsidiaryBase.setCreateTime(new Date());
            	//TODO
//            	sbSubsidiaryBase.setFilingAuthorityCode(filingAuthorityCode);//备案机关编码
//            	sbSubsidiaryBase.setFilingAuthorityDate(filingAuthorityDate);//备案机关日期
//            	sbSubsidiaryBase.setFilingAuthorityName(filingAuthorityName);//备案机关名称

				sbSubsidiaryBase.setMoneyPrincipal(dbSubsidiary.getChargename());
            	sbSubsidiaryBase.setMoneyPrincipalId(dbSubsidiary.getChargecardnumber());
            	sbSubsidiaryBase.setMoneyPrincipalPhone(dbSubsidiary.getChargephone());
            	sbSubsidiaryBase.setRegisterAddress(dbSubsidiary.getAddress());
            	sbSubsidiaryBase.setUpdateBy(currentUser.getUsername());
            	sbSubsidiaryBase.setUpdateTime(new Date());
//            	sbSubsidiaryBase.setUser(user);
            	sbSubsidiaryBase.setUserid(dbSubsidiary.getUserid());
            	sbSubsidiaryBaseService.saveOrUpdate(sbSubsidiaryBase);
						//分公司基本信息 TODO
						new Thread(() -> {
							try {
								buildWebServiceEntity(sbSubsidiaryBase);
							} catch (Exception e) {
								logger.error(e.getMessage(),e);
							}

						}).start();
						//分公司主要管理员 TODO
						new Thread(() -> {
							try {
								Bafwgsfgsglry bafwgsfgsglry =new Bafwgsfgsglry();
								//保安服务公司编码
								bafwgsfgsglry.setBagsbm(dbSubsidiary.getLicencenum());
								//子公司名称
								bafwgsfgsglry.setFgsmc(dbSubsidiary.getCompanyname());
								//主要管理人员证件号码
								bafwgsfgsglry.setSfzh(dbSubsidiary.getChargecardnumber());
								//姓名
								bafwgsfgsglry.setXm(dbSubsidiary.getChargename());
								//证件类型
								bafwgsfgsglry.setZjlx("01");
								//职务
								bafwgsfgsglry.setZw(dbSubsidiary.getChargepost());
								//总公司保安服务许可证号
								bafwgsfgsglry.setBafwxkz(dbSubsidiary.getLicencenum());
								//调用send方法完成对接
								clientUtil.send(Constants.XXBA_BAFWGSFGSGLRY,bafwgsfgsglry);
							} catch (Exception e) {
								logger.error(e.getMessage(),e);
							}
						}).start();
				}
		}
		
	}
	/**
	 * 创建WebService数据实体类
	 *
	 * @param dbSbSubsidiaryBase
	 */
	private void buildWebServiceEntity(SbSubsidiaryBase dbSbSubsidiaryBase) throws Exception {
        Bafwgsfgsxx bafwgsfgsxx = new Bafwgsfgsxx();
        Map<String, KeyAndDefauleVal> map = new HashMap<String, KeyAndDefauleVal>();
        //TODO 公司编码没有
       // map.put("bagsbm", new KeyAndDefauleVal("publicSecurityLicenseNumber", company.getPublicSecurityLicenseNumber()));
        map.put("fgsmc", new KeyAndDefauleVal("companyName", dbSbSubsidiaryBase.getCompanyName()));
        map.put("xxdz", new KeyAndDefauleVal("registerAddress", null));
        map.put("jydxz", new KeyAndDefauleVal("businessPlace", null));
        map.put("bajgbm", new KeyAndDefauleVal("filingAuthorityCode", null));
        map.put("bajgmc", new KeyAndDefauleVal("filingAuthorityName", null));
//        map.put("barq", new KeyAndDefauleVal("filingAuthorityDate", dbSbSubsidiaryBase.getFilingAuthorityDate()));
        //无
        map.put("zcdz", new KeyAndDefauleVal("registerAddress", ""));
        map.put("jydz", new KeyAndDefauleVal("registerAddress", ""));
        map.put("bz1", new KeyAndDefauleVal("filingAuthorityName", ""));
        map.put("bz2", new KeyAndDefauleVal("filingAuthorityName", ""));
        map.put("bz3", new KeyAndDefauleVal("filingAuthorityName", ""));
        //从外部获取
        map.put("bafwxkz", new KeyAndDefauleVal("publicSecurityLicenseNumber", dbSbSubsidiaryBase.getCode()));
        try {
            EntityForWebServiceUtil.copy(map, dbSbSubsidiaryBase, bafwgsfgsxx);
            clientUtil.send(Constants.XXBA_BAFWGSFGSXX, bafwgsfgsxx);
        } catch (Exception e) {
			logger.error(e.getMessage(),e);
        }
	}
	@Override
	public void saveOrUpdateForDS(Subsidiary subsidiary) {
		
		if(subsidiary.getActive() == null){
			subsidiary.setActive(true);
		}
		
		Subsidiary dbSubsidiary = subsidiaryDao.findById(subsidiary.getId());
		if (dbSubsidiary != null) {
			if(subsidiary.getUpdateTime().getTime() > dbSubsidiary.getUpdateTime().getTime()){
                subsidiary.setChargecensorstatus(dbSubsidiary.getChargecensorstatus());
                subsidiary.setLegalcensorstatus(dbSubsidiary.getLegalcensorstatus());
				subsidiaryDaoAop.update(subsidiary);
			}
		} else {
			subsidiaryDao.save(subsidiary);
		}
	}

	@Override
	public SubsidiarySearchDto search(SubsidiarySearchDto dto) {
		SubsidiarySearchDto resultDto = new SubsidiarySearchDto();

		User currentUser = arsUtil.getCurrentUser();
		//机构信息
		Police police = policeDao.findById(currentUser.getOrgid());
		String areacode =  police.getAreacode();
		if(areacode.endsWith("0000")){//省
			dto.setDistrict(areacode.substring(0,2)+"____");
		}else if(areacode.endsWith("00")){//市
			dto.setDistrict(areacode.substring(0,4)+"__");
		}else{//区
			dto.setDistrict(areacode);
		}


		List<Subsidiary> list =  subsidiaryDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(subsidiaryDao.searchCount(dto));
		return resultDto;
	}

	@Override
	public Subsidiary findByUser(Long userid) {
		// TODO Auto-generated method stub
		return subsidiaryDao.findByUser(userid);
	}

	@Override
	public List<Subsidiary> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return subsidiaryDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public List<Subsidiary> findAll() {
		return subsidiaryDao.findAll();
	}

	@Override
	public PageResult searchSubsidiaryList_table(Map<Object, Object> p) {
		User currentUser = arsUtil.getCurrentUser();
		//机构信息
		Police police = currentUser.getPolice();

		String areacode = "";
		if (p.get("areaCode") != null) {
			areacode = p.get("areaCode").toString();
		} else {
			if (police != null) {
				areacode = police.getAreacode();
			}

		}



			if (StringUtil.isNotEmpty(areacode)) {
				if (areacode.endsWith("0000")) {//省
					p.put("district", areacode.substring(0, 2) + "____");
				} else if (areacode.endsWith("00")) {//市
					p.put("district", areacode.substring(0, 4) + "__");
				} else {//区
					p.put("district", areacode);
				}
				if (police.getOrgtype().equals("4")) {
					p.put("orgid", police.getId());
				}
			}

		if (police != null) {
			if (police.getOrgtype().equals("4")) {
				p.put("orgid", police.getId());
			}
		}


		return new PageResult(subsidiaryDao.countSubsidiaryList(p), subsidiaryDao.searchSubsidiaryList(p));
	}



	@Override
	public void searchForPage(SubsidiarySearchDto dto, AjaxPageResponse<Subsidiary> page) {
		arsUtil.setPoliceSearch(dto);
		subsidiaryDao.searchForPage(dto,page);
	}
	@Override
	public void saveOrUpdateForApproval(Subsidiary subsidiary) {
		subsidiary.setUpdateTime(new Date());
		subsidiaryDaoAop.update(subsidiary);
	}

	@Override
	public void updateCensorStatus(Subsidiary subsidiary) {
		subsidiaryDaoAop.update(subsidiary);
	}

	@Override
	public void saveOrUpdateForApprovalImport(Subsidiary subsidiary) {
		subsidiaryDaoAop.update(subsidiary);
	}
	@Override
	public
	void saveOrUpdateForApprovalBatchImport(List<Subsidiary> subsidiary){
		subsidiaryDaoAop.updateBatch(subsidiary);
	}


}
