package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.ShareholderDao;
import com.bcxin.ars.dao.sb.ShareholderDaoAop;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.ShareholderSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Shareholder;
import com.bcxin.ars.service.sb.ShareholderService;
import com.bcxin.ars.service.util.ArsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Shareholder.class)
public class ShareholderServiceImpl implements ShareholderService{

	@Autowired
	private ShareholderDao shareholderDao;

	@Autowired
	private ShareholderDaoAop shareholderDaoAop;

	@Autowired
	private ArsUtil arsUtil;
	
	
	@Override
	public Shareholder findById(long id) {
		return shareholderDao.findById(id);
	}

	@Override
	public Shareholder findByName(String name) {
		return shareholderDao.findByName( name);
	}

	@Override
	public void saveOrUpdate(Shareholder shareholder) {
		User currentUser = arsUtil.getCurrentUser();
		if(shareholder.getId() == null){
			shareholder.setActive(true);
			shareholder.setCreateTime(new Date());
			shareholder.setUpdateTime(new Date());
			shareholder.setUpdateBy(currentUser.getUsername());
			shareholderDao.save(shareholder);
		}else{
			Shareholder dbShareholder = shareholderDao.findById(shareholder.getId());
			dbShareholder.setUpdateTime(new Date());
			dbShareholder.setUpdateBy(currentUser.getUsername());
			dbShareholder.setUpdateTime(new Date());
			dbShareholder.setName(shareholder.getName());
			dbShareholder.setPercentage(shareholder.getPercentage());
			dbShareholder.setCensorstatus(shareholder.getCensorstatus());
			dbShareholder.setIdnumber(shareholder.getIdnumber());
			dbShareholder.setType(shareholder.getType());
			shareholderDao.update(dbShareholder);
		}
	}

	@Override
	public void saveOrUpdateForDS(Shareholder shareholder) {
		if(shareholder.getActive() == null){
			shareholder.setActive(true);
		}
		
		Shareholder dbShareholder = shareholderDao.findById(shareholder.getId());
		if (dbShareholder != null) {
			if(shareholder.getUpdateTime().getTime() > dbShareholder.getUpdateTime().getTime()){
            	shareholder.setCensorstatus(dbShareholder.getCensorstatus());
				shareholderDao.update(shareholder);
			}
		} else {
			shareholderDao.saveForDS(shareholder);
		}
	}

	@Override
	public ShareholderSearchDto search(ShareholderSearchDto dto) {
		ShareholderSearchDto resultDto = new ShareholderSearchDto();
		List<Shareholder> list =  shareholderDao.search(dto);
		resultDto.setData(list);
		if(dto.isPaging()) {
			resultDto.setTotalCount(shareholderDao.searchCount(dto));
		}
		return resultDto;
	}

	@Override
	public List<Shareholder> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return shareholderDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void deleteBySid(String sponsorlicenseid){
		shareholderDao.deleteBySid(sponsorlicenseid);
	}

	@Override
	public void updateCensorStatus(Shareholder shareholder) {
		shareholderDaoAop.updateCensorStatus(shareholder);
	}
}
