package com.bcxin.ars.service.sb.impl;


import com.bcxin.ars.dao.sb.SecAssociationRatingDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.SecAssociationRatingPageSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.SecAssociationRating;
import com.bcxin.ars.service.sb.SecAssociationRatingService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 保安协会等级评定Service业务层处理
 * 
 * @author lin
 * @date 2021-04-20
 */
@Service
public class SecAssociationRatingServiceImpl implements SecAssociationRatingService {
    
    Logger logger = LoggerFactory.getLogger(SecAssociationRatingServiceImpl.class);
    
    @Autowired
    private SecAssociationRatingDao secAssociationRatingDao;


    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private IdWorker idWorker;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public int delete(SecAssociationRating secAssociationRating) {
        User currentUser = arsUtil.getCurrentUser();
        secAssociationRating.setUpdateTime(new Date());
        secAssociationRating.setUpdateBy(currentUser.getUsername());
        return secAssociationRatingDao.delete(secAssociationRating);
    }

    @Override
    public int save(SecAssociationRating secAssociationRating) {
        User currentUser = arsUtil.getCurrentUser();
        if(secAssociationRating.getId() == null){
            secAssociationRating.setId(idWorker.nextId());
            secAssociationRating.setActive(true);
            secAssociationRating.setCreateTime(new Date());
            secAssociationRating.setUserId(currentUser.getId());
            secAssociationRating.setApproveState(Constants.APPLYSTATUS_DSH);
        }else{
            SecAssociationRating dbSecAssociationRating = secAssociationRatingDao.findById(secAssociationRating.getId());
            BeanUtils.copyPropertiesIgnore(secAssociationRating,dbSecAssociationRating,true);
            BeanUtils.copyPropertiesIgnore(dbSecAssociationRating,secAssociationRating,false);
            secAssociationRating.setApproveUserId(currentUser.getId());
            secAssociationRating.setApproveName(currentUser.getUsername());
        }

        if(Constants.APPLYSTATUS_DSH.equals(secAssociationRating.getApproveState())){
            SecAssociationRating dbSecAssociationRating = secAssociationRatingDao.findByComName(secAssociationRating.getComName());
            if(dbSecAssociationRating != null && dbSecAssociationRating.getId() != secAssociationRating.getId()){
                throw new ArsException(secAssociationRating.getComName()+" 已存在受理记录！");
            }
            dbSecAssociationRating = secAssociationRatingDao.findByUserId(currentUser.getId());
            if(dbSecAssociationRating != null && dbSecAssociationRating.getId() != secAssociationRating.getId()){
                throw new ArsException("本账号存在待受理的记录。请等待审批完再提交！");
            }
        }

        secAssociationRating.setUpdateBy(currentUser.getUsername());
        secAssociationRating.setUpdateTime(new Date());
        secAssociationRating.setUpdateflag(true);
        return secAssociationRatingDao.save(secAssociationRating);
    }

    @Override
    public void approve(SecAssociationRating secAssociationRating) {
        User currentUser = arsUtil.getCurrentUser();
        SecAssociationRating dbSecAssociationRating = secAssociationRatingDao.findById(secAssociationRating.getId());
        BeanUtils.copyPropertiesIgnore(secAssociationRating,dbSecAssociationRating,true);
        BeanUtils.copyPropertiesIgnore(dbSecAssociationRating,secAssociationRating,false);
        secAssociationRating.setApproveUserId(currentUser.getId());
        secAssociationRating.setApproveName(currentUser.getRealname());
        secAssociationRating.setApproveTime(new Date());
        secAssociationRating.setUpdateBy(currentUser.getUsername());
        secAssociationRating.setUpdateTime(new Date());
        secAssociationRating.setUpdateflag(true);
        secAssociationRatingDao.save(secAssociationRating);
    }

    @Override
    public SecAssociationRating findById(Long id) {
        return secAssociationRatingDao.findById(id);
    }

    @Override
    public void searchForPage(SecAssociationRatingPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
        secAssociationRatingDao.searchForPage(dto,page);
    }

    @Override
    public void importBatch(List<SecAssociationRating> list) {
        List<SecAssociationRating> dbList = secAssociationRatingDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (SecAssociationRating secAssociationRating : list) {
                secAssociationRating.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        secAssociationRating.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, secAssociationRating.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            secAssociationRatingDao.saveBatch(list);
        }
    }

    @Override
    public List<SecAssociationRating> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return secAssociationRatingDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<SecAssociationRating> findDSOutList(String startDate) {
        return secAssociationRatingDao.findDSOutList(startDate);
    }

    @Override
    public List<SecAssociationRating> findByBatchId(List<SecAssociationRating> list) {
        return secAssociationRatingDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(SecAssociationRating secAssociationRating) {
        User currentUser = arsUtil.getCurrentUser();
        secAssociationRating.setUpdateTime(new Date());
        secAssociationRating.setUpdateBy(currentUser.getUsername());
        secAssociationRatingDao.updateSelective(secAssociationRating);
    }
}
