package com.bcxin.ars.service.sb.impl;

import com.bcxin.ars.dao.sb.PrintDesignDao;
import com.bcxin.ars.model.sb.PrintDesign;
import com.bcxin.ars.service.sb.PrintDesignService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
/**
 * @author  wjb
 * @desc 打印设计Service实现类
 * @date 2018年10月15日16:52:42
 */
@Service
@Transactional
public class PrintDesignServiceImpl implements PrintDesignService {

	@Autowired
	private PrintDesignDao printDesignDao;

	@Override
	public Long save(PrintDesign printDesign) {
		return printDesignDao.save(printDesign);
	}

	@Override
	public PrintDesign findById(Integer id) {
		return printDesignDao.findById(id);
	}

	@Override
	public List<PrintDesign> findByAreacode(String areacode, String type) {
		return printDesignDao.findByAreacode(areacode,type);
	}

	@Override
	public void update(PrintDesign printDesign) {
		// TODO Auto-generated method stub
		printDesignDao.update(printDesign);
	}

}
