package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.PersonworkexperienceDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.PersonworkexperienceSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Personworkexperience;
import com.bcxin.ars.service.sb.PersonworkexperienceService;
import com.bcxin.ars.service.util.ArsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Personworkexperience.class)
public class PersonworkexperienceServiceImpl implements PersonworkexperienceService{

	@Autowired
	private PersonworkexperienceDao personworkexperienceDao;
	
	@Autowired
	private ArsUtil arsUtil;
	
	
	@Override
	public Personworkexperience findById(long id) {
		return personworkexperienceDao.findById(id);
	}

	@Override
	public void saveOrUpdate(Personworkexperience personworkexperience) {
		User currentUser = arsUtil.getCurrentUser();
		if(personworkexperience.getId() == null){
			personworkexperience.setActive(true);
			personworkexperience.setCreateTime(new Date());
			personworkexperience.setUpdateTime(new Date());
			personworkexperience.setUpdateBy(currentUser.getUsername());
			personworkexperienceDao.save(personworkexperience);
		}else{
			Personworkexperience dbPersonworkexperience = personworkexperienceDao.findById(personworkexperience.getId());
			dbPersonworkexperience.setUpdateBy(currentUser.getUsername());
			dbPersonworkexperience.setUpdateTime(new Date());

			dbPersonworkexperience.setCompanyname(personworkexperience.getCompanyname());
			dbPersonworkexperience.setEnddate(personworkexperience.getEnddate());
			dbPersonworkexperience.setLiveReason(personworkexperience.getLiveReason());
			dbPersonworkexperience.setPost(personworkexperience.getPost());
			dbPersonworkexperience.setRemarks(personworkexperience.getRemarks());
			dbPersonworkexperience.setStartdate(personworkexperience.getStartdate());
			dbPersonworkexperience.setWorkContent(personworkexperience.getWorkContent());
			personworkexperienceDao.update(dbPersonworkexperience);
		}
	}

	@Override
	public void saveOrUpdateForDS(Personworkexperience personworkexperience) {
		
		if(personworkexperience.getActive() == null){
			personworkexperience.setActive(true);
		}
		
		if(!personworkexperience.getActive()){
			personworkexperienceDao.delete(personworkexperience);
		}else{
			Personworkexperience dbPersonworkexperience = personworkexperienceDao.findById(personworkexperience.getId());
			if (dbPersonworkexperience != null) {
				if(personworkexperience.getUpdateTime().getTime() > dbPersonworkexperience.getUpdateTime().getTime()){
					personworkexperienceDao.update(personworkexperience);
				}
			} else {
				personworkexperienceDao.saveForDS(personworkexperience);
			}
		}
	}

	@Override
	public PersonworkexperienceSearchDto search(PersonworkexperienceSearchDto dto) {
		PersonworkexperienceSearchDto resultDto = new PersonworkexperienceSearchDto();
		List<Personworkexperience> list =  personworkexperienceDao.search(dto);
		resultDto.setData(list);
		if(dto.isPaging()) {
			resultDto.setTotalCount(personworkexperienceDao.searchCount(dto));
		}
		return resultDto;
	}

	@Override
	public List<Personworkexperience> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return personworkexperienceDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void delete(Personworkexperience personworkexperience) {
		User currentUser = arsUtil.getCurrentUser();
		personworkexperience.setUpdateBy(currentUser.getUsername());
		personworkexperience.setUpdateTime(new Date());
		personworkexperienceDao.delete(personworkexperience);
	}

	@Override
	public List<Personworkexperience> searchByPid(Long pid) {
		return personworkexperienceDao.searchByPid(pid);
	}

}
