package com.bcxin.ars.service.sb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.log.LogMessageDao;
import com.bcxin.ars.dao.sb.OrderDetailDao;
import com.bcxin.ars.dao.sb.OrderInfoDao;
import com.bcxin.ars.dao.sb.OrderPayInfoDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dto.BKTNewOrderDTO;
import com.bcxin.ars.dto.BKTNewOrderPersonDTO;
import com.bcxin.ars.dto.OrderDetailDTO;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.log.LogMessage;
import com.bcxin.ars.model.sb.OrderDetail;
import com.bcxin.ars.model.sb.OrderInfo;
import com.bcxin.ars.model.sb.OrderPayInfo;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.service.sb.OrderInfoService;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.HttpClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * Created by 苏 on 2017/5/19.
 */
@Service
@Transactional
public class OrderInfoServiceImpl implements OrderInfoService {



    private static Logger logger = LoggerFactory.getLogger(ManagementInfoServiceImpl.class);
    /**
     * 百课堂返回状态--成功
     */
    static public String IS_SUCCESS = "0";

    @Autowired
    private OrderInfoDao orderInfoDAO;

    @Autowired
    private OrderDetailDao orderDetailDao;
    @Autowired
    private OrderPayInfoDao orderPayInfoDao;

    @Autowired
    private IdGeneratorUtil idGeneratorUtil;
    @Autowired
    private ConfigDao configDao;

    @Autowired
    private LogMessageDao logMessageDao;
    @Autowired
    private PersoncertificateDao personcertificateDao;
    @Override
    public OrderInfo fingById(Long id) {
       return orderInfoDAO.findById(id);
    }
    @Override
    public OrderInfo  findByDetailId(Long id){
        return orderInfoDAO.findByDetailId(id);
    }

    @Override
    public void insert(OrderInfo orderInfo) {
        orderInfoDAO.insert(orderInfo);
    }

    @Override
    public void update(OrderInfo orderInfo) {
        orderInfoDAO.update(orderInfo);
    }
    @Override
    public void  saveOrder(String payStatus, OrderInfo orderInfo, Date date){
        if (Constants.ORDERSTATUS_PAY.equals(payStatus)) {
            //更新订单
            orderInfo.setOrderStatus(payStatus);
            orderInfo.setUpdateTime(date);
            orderInfo.setPaySuccessTime(date);
            orderInfoDAO.update(orderInfo);

            //遍历人员订单批量更新保安员证的支付状态
            List<OrderDetail> orderDetailList = orderDetailDao.selectOrderDetailByInfoId(orderInfo.getId());
            if (orderDetailList != null && orderDetailList.size() > 0) {
                //modefy by zjh time：2018年9月10日 14:16:11 订单通过时候需要修改保安员报名表中的订单id跟订单名称Øs
                List<OrderDetailDTO> orderDetailDTOList=new ArrayList<>();
                OrderDetailDTO orderDetailDTO;
                for (OrderDetail orderDetail:orderDetailList){
                    orderDetailDTO=new OrderDetailDTO();
                    BeanUtils.copyPropertiesIgnore(orderDetail,orderDetailDTO);
                    orderDetailDTO.setTrainOrgID(orderInfo.getBktOrgId());
                    orderDetailDTO.setTrainOrgName(orderInfo.getBktOrgName());
                    orderDetailDTOList.add(orderDetailDTO);
                }
                orderDetailDao.bktUpdatefeeStateByBatchID(orderDetailDTOList);
            }
            this.bKTPayInterface(orderInfo,orderDetailList);

        }
        //更新支付信息
        OrderPayInfo orderPayInfo=new OrderPayInfo();
        orderPayInfo.setCreateTime(date);
        orderPayInfo.setActive(true);
        orderPayInfo.setCreateBy(orderInfo.getCreateBy());
        orderPayInfo.setIsPaySuccess(payStatus);
        orderPayInfo.setOrderInfoId(orderInfo.getId());
        orderPayInfo.setId(idGeneratorUtil.createID());
        orderPayInfoDao.insert(orderPayInfo);

    }

    private void bKTPayInterface(OrderInfo orderInfo, List<OrderDetail> orderDetailList) {

        //获取百课堂配置地址
        Config configURL = configDao.findByKey(Constants.BKT_DATA_URL);
        LogMessage logMessage = new LogMessage();
        logMessage.setLogger_title("百课堂新订单同步");
        logMessage.setCreateTime(new Date());
        try {
        if (configURL != null && configURL.getValue() != null) {
            //"http://192.168.30.99:8888/"
            String url = configURL.getValue() + Constants.BTK_NEWORDER;
            BKTNewOrderDTO bktNewOrderDTO=new BKTNewOrderDTO();
            Map data=new HashMap();
            bktNewOrderDTO.setTrackid(orderInfo.getBktCourseId());
            bktNewOrderDTO.setOrganID(orderInfo.getBktOrgId());
            bktNewOrderDTO.setSumPrice(orderInfo.getOrderSumMoney());
            bktNewOrderDTO.setPrice(orderInfo.getOrderSumMoney());
            List<BKTNewOrderPersonDTO> systemLearnOrderPeoples=new ArrayList<>();
            BKTNewOrderPersonDTO bktNewOrderPersonDTO;
            List<Personcertificate> personcertificates=new ArrayList<>();
            Personcertificate personcertificate;
            for (OrderDetail orderDetail:orderDetailList){
                personcertificate=new Personcertificate();
                personcertificate.setBbdPersonID(orderDetail.getSbPersoncertificateId());
                personcertificates.add(personcertificate);
            }
            List<Personcertificate> dbPersoncertificateList = personcertificateDao.findByBatchPersonId(personcertificates);
            for (Personcertificate dbpersoncertificate : dbPersoncertificateList) {
                bktNewOrderPersonDTO=new BKTNewOrderPersonDTO();
                bktNewOrderPersonDTO.setMobile(dbpersoncertificate.getPhone());
                bktNewOrderPersonDTO.setIdentitynumber(dbpersoncertificate.getCardnumber());
                bktNewOrderPersonDTO.setFullname(dbpersoncertificate.getName());
                bktNewOrderPersonDTO.setTruename(dbpersoncertificate.getName());
                bktNewOrderPersonDTO.setBbdPersonID(dbpersoncertificate.getId());
                systemLearnOrderPeoples.add(bktNewOrderPersonDTO);
            }
            bktNewOrderDTO.setSystemLearnOrderPeoples(systemLearnOrderPeoples);
            data.put("data",JSON.toJSONString(bktNewOrderDTO));
            //地址访问
            String btkRtn = HttpClientUtils.doPost(url,data,"utf-8");

            if (btkRtn != null) {
                //转成json
                JSONObject jsonObject = JSONObject.parseObject(btkRtn);
                //获取状态值
                String retType = jsonObject.get("retType").toString();

                //判断非空且
                if (!StringUtils.isEmpty(retType) && Constants.BTK_IS_SUCCESS.equals(retType)) {
                    logger.info("百课堂新订单同步成功");
                } else {
                    logger.info("百课堂新订单同步失败");
                }
                String retrunData ="";
                if (jsonObject.get("data")!=null){
                     retrunData = jsonObject.get("data").toString();
                }
                String message ="";
                if (jsonObject.get("msg")!=null){
                    message=jsonObject.get("msg").toString();
                }
                if (!StringUtils.isEmpty(retrunData)) {
                    logMessage.setLogger_context(retrunData);
                }else if(!StringUtils.isEmpty(message)){
                    logMessage.setLogger_context(message);
                }
                //保存错误日志
                logMessageDao.save(logMessage);
            }

        }
        } catch (Exception e) {
            logMessage.setLogger_context(e.toString());
            //保持错误日志
            logMessageDao.save(logMessage);
            logger.error(e.getMessage(),e);
        }

    }
}
