package com.bcxin.ars.service.sb.impl;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.dao.sb.ConfesscompanypersonDao;
import com.bcxin.ars.dto.sb.ConfesscompanypersonSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Confesscompanyperson;
import com.bcxin.ars.service.sb.ConfesscompanypersonService;
import com.bcxin.ars.service.util.ArsUtil;

@Service
@Transactional
public class ConfesscompanypersonServiceImpl implements ConfesscompanypersonService{

	@Autowired
	private ConfesscompanypersonDao confesscompanypersonDao;
	
	@Autowired
	private ArsUtil arsUtil;
	
	
	@Override
	public Confesscompanyperson findById(long id) {
		return confesscompanypersonDao.findById(id);
	}

	@Override
	public void saveOrUpdate(Confesscompanyperson confesscompanyperson) {
		User currentUser = arsUtil.getCurrentUser();
		if(confesscompanyperson.getId() == null){
			confesscompanyperson.setActive(true);
			confesscompanyperson.setCreateTime(new Date());
			confesscompanyperson.setUpdateTime(new Date());
			confesscompanyperson.setUpdateBy(currentUser.getUsername());


			confesscompanypersonDao.save(confesscompanyperson);
		}else{
			Confesscompanyperson dbConfesscompanyperson = confesscompanypersonDao.findById(confesscompanyperson.getId());
			dbConfesscompanyperson.setUpdateTime(new Date());
			dbConfesscompanyperson.setCompanyname(confesscompanyperson.getCompanyname());
			dbConfesscompanyperson.setPost(confesscompanyperson.getPost());
			dbConfesscompanyperson.setUpdateBy(currentUser.getUsername());
			dbConfesscompanyperson.setUpdateTime(new Date());
			
			dbConfesscompanyperson.setAddress(confesscompanyperson.getAddress());
			dbConfesscompanyperson.setBirth(confesscompanyperson.getBirth());
			dbConfesscompanyperson.setCardnumber(confesscompanyperson.getCardnumber());
			dbConfesscompanyperson.setCulture(confesscompanyperson.getCulture());
			dbConfesscompanyperson.setEducation(confesscompanyperson.getEducation());
			dbConfesscompanyperson.setName(confesscompanyperson.getName());
			dbConfesscompanyperson.setNation(confesscompanyperson.getNation());
			dbConfesscompanyperson.setPhone(confesscompanyperson.getPhone());
			dbConfesscompanyperson.setPlace(confesscompanyperson.getPlace());
			dbConfesscompanyperson.setPolitics(confesscompanyperson.getPolitics());
			dbConfesscompanyperson.setSex(confesscompanyperson.getSex());
			dbConfesscompanyperson.setTitle(confesscompanyperson.getTitle());
			
			confesscompanypersonDao.update(dbConfesscompanyperson);
		}
		
	}

	@Override
	public ConfesscompanypersonSearchDto search(ConfesscompanypersonSearchDto dto) {
		ConfesscompanypersonSearchDto resultDto = new ConfesscompanypersonSearchDto();
		List<Confesscompanyperson> list =  confesscompanypersonDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(confesscompanypersonDao.searchCount(dto));
		return resultDto;
	}

}
