package com.bcxin.ars.service.msg.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.msg.NewsnoticeRecipientDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.msg.NewsnoticeRecipient;
import com.bcxin.ars.service.msg.NewsnoticeRecipientService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = NewsnoticeRecipient.class)
@DataSyncOutAnnotation(getClazz = NewsnoticeRecipient.class)
public class NewsnoticeRecipientServiceImpl implements NewsnoticeRecipientService {

	/**
	 * 日志
	 */
	public static final Logger logger = LoggerFactory.getLogger(NewsnoticeRecipientServiceImpl.class);

	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private NewsnoticeRecipientDao newsnoticeRecipientDao;

	@Override
	public List<NewsnoticeRecipient> findDSOutList(String startDate) {
		return newsnoticeRecipientDao.searchFromInToOutForExport(startDate);
	}

	@Override
	public void saveOrUpdateForImport(NewsnoticeRecipient newsnoticeRecipient) {
		try {

			newsnoticeRecipient.setUpdateflag(false);

			NewsnoticeRecipient dbNewsnoticeRecipient = newsnoticeRecipientDao.findById(newsnoticeRecipient.getId());
			if(dbNewsnoticeRecipient == null){
				newsnoticeRecipient.setUpdateTime(DateUtil.dateAdd2(DateUtil.DATATYPE_SECOND, newsnoticeRecipient.getUpdateTime(), 1));
				newsnoticeRecipientDao.saveForDS(newsnoticeRecipient);
			}else{
				if(newsnoticeRecipient.getUpdateTime().getTime() > dbNewsnoticeRecipient.getUpdateTime().getTime()){
					newsnoticeRecipient.setUpdateTime(DateUtil.dateAdd2(DateUtil.DATATYPE_SECOND, newsnoticeRecipient.getUpdateTime(), 1));
					newsnoticeRecipientDao.updateForDS(newsnoticeRecipient);
				}
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			logger.error(e.getMessage(), e);
		}
	}

	@Override
	public List<NewsnoticeRecipient> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return newsnoticeRecipientDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void saveOrUpdateForDS(NewsnoticeRecipient newsnoticeRecipient) {
		newsnoticeRecipient.setUpdateflag(false);
		if(newsnoticeRecipient.getActive() == null){
			newsnoticeRecipient.setActive(true);
		}
		//和数据进行比较有就更新无就创建
		NewsnoticeRecipient dbnewsnoticeRecipient = newsnoticeRecipientDao.findById(newsnoticeRecipient.getId());
		if (dbnewsnoticeRecipient != null) {
			if(newsnoticeRecipient.getUpdateTime().getTime() > dbnewsnoticeRecipient.getUpdateTime().getTime()){
				newsnoticeRecipientDao.updateForDS(newsnoticeRecipient);
			}
		} /*else {
			newsnoticeRecipientDao.saveForDS(newsnoticeRecipient);
		}*/
	}

	@Override
	public void importBatch(List<NewsnoticeRecipient> list) {
		List<NewsnoticeRecipient> dbList = newsnoticeRecipientDao.findByBatchId(list);
		//去掉重复的
		//通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
		list.removeAll(dbList);

		if (list.size()>0){
			for(NewsnoticeRecipient detail:list){
				detail.setUpdateflag(false);
				try {
					detail.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, detail.getUpdateTime(), 1));
				}catch (Exception e){
					logger.error(e.getMessage(),e);
				}
			}
			//批量保存
			newsnoticeRecipientDao.saveBatch(list);
		}
	}
}
