package com.bcxin.ars.service.msg.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.abcxin.smart.validator.enums.SyncType;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.msg.*;
import com.bcxin.ars.dto.*;
import com.bcxin.ars.dto.msg.NewsnoticePoliceSearchDto;
import com.bcxin.ars.dto.page.NewsnoticePolicePageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.msg.*;
import com.bcxin.ars.service.msg.NewsnoticePoliceService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

@Service
@Transactional
@DataSyncAnnotation(getClazz = NewsnoticePolice.class,getSeq=30000,getDataSyncType = SyncType.SYNC)
@DataSyncOutAnnotation(getClazz = NewsnoticePolice.class,getSeq=30000,getDataSyncType = SyncType.SYNC,getMethodName="saveOrUpdateForImport",getImportType = ImportType.FOREACH)
public class NewsnoticePoliceServiceImpl implements NewsnoticePoliceService {
    /***
     *  日志
     */
    private static final Logger logger = LoggerFactory.getLogger(NewsnoticePoliceServiceImpl.class);

    @Autowired
    private NewsnoticePoliceDao newsnoticePoliceDao;

    @Autowired
    private NewsnoticeCompanyDao newsnoticeCompanyDao;

    @Autowired
    private SysAttachmentDao sysAttachmentDao;

    @Autowired
    private NewsnoticeRecipientDao newsnoticeRecipientDao;


    @Autowired
    private NewsCompanyRelationshipDao newsCompanyRelationshipDao;

    @Autowired
    private SecurityCompanyDao securityCompanyDao;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private IdGeneratorUtil idGeneratorUtil;

    @Autowired
    private SAASInterfaceUtil saasInterfaceUtil;

    @Autowired
    private ConfigUtils configUtils;

    @Override
    public void saveOrUpdate(NewsnoticePolice notice) {
        User currentUser = arsUtil.getCurrentUser();
        //发送时间
        if (StringUtil.isNotEmpty(notice.getTemporaryState()) && notice.getTemporaryState().equals(Constants.MSG_TEMPORARYSTATE_SEND)) {
            notice.setSendTime(new Date());
        }
        //为空则新增
        if (notice.getId() == null) {
            notice.setActive(true);
            notice.setCreateTime(new Date());
            notice.setUpdateTime(new Date());
            notice.setUpdateBy(currentUser.getUsername());
            notice.setSendId(currentUser.getId());
            notice.setSendName(currentUser.getRealname());
            notice.setSendOrgName(currentUser.getPolice().getOrgname());
            notice.setSendOrgId(currentUser.getPolice().getId());
            notice.setAreaCode(currentUser.getPolice().getAreacode());
            notice.setUndoState(Constants.DOSTATE);
            notice.setUpdateflag(true);
            newsnoticePoliceDao.save(notice);
        } else {
            NewsnoticePolice dbNotice = newsnoticePoliceDao.findById(notice.getId());
            dbNotice.setNewsContext(notice.getNewsContext());
            dbNotice.setNewsTitle(notice.getNewsTitle());
            dbNotice.setReplyAtt(notice.getReplyAtt());
            dbNotice.setUpdateTime(new Date());
            dbNotice.setUpdateBy(currentUser.getRealname());
            dbNotice.setTemporaryState(notice.getTemporaryState());
            dbNotice.setNoticeperson(notice.getNoticeperson());
            dbNotice.setUndoState(Constants.DOSTATE);
            if (notice.getUnreadnum() != null) {
                dbNotice.setUnreadnum(notice.getUnreadnum());
            }
            //如果发送时间为空更设置值
            if(dbNotice.getSendTime()==null) {
                dbNotice.setSendTime(notice.getSendTime());
            }
            dbNotice.setUpdateflag(true);
            newsnoticePoliceDao.update(dbNotice);
        }
        if (notice.getSysAttachmentIds() != null && notice.getSysAttachmentIds().length > 0) {
            SysAttachment dbSysAttachment = null;
            for (Long sysAttachmentId : notice.getSysAttachmentIds()) {
                dbSysAttachment = sysAttachmentDao.findById(sysAttachmentId);
                dbSysAttachment.setBusinessid(notice.getId());
                dbSysAttachment.setBusinesstype(Constants.FILE_BUSINESSTYPE_MSG_POLICE);
                dbSysAttachment.setUpdateBy(currentUser.getUsername());
                dbSysAttachment.setUpdateTime(new Date());

                dbSysAttachment.setUpdateflag(true);
                sysAttachmentDao.update(dbSysAttachment);
            }
        }

        if (notice.getUeditorImageIds() != null && notice.getUeditorImageIds().length > 0) {
            SysAttachment dbSysAttachment = null;
            for (Long ueditorImageId : notice.getUeditorImageIds()) {
                dbSysAttachment = sysAttachmentDao.findById(ueditorImageId);
                dbSysAttachment.setBusinessid(notice.getId());
                dbSysAttachment.setBusinesstype(Constants.FILE_BUSINESSTYPE_UEDITOR);
                dbSysAttachment.setUpdateBy(currentUser.getUsername());
                dbSysAttachment.setUpdateTime(new Date());

                dbSysAttachment.setUpdateflag(true);
                sysAttachmentDao.update(dbSysAttachment);
            }
        }

        if (notice.getCompanyIds() != null && notice.getCompanyIds().length > 0) {
            int i = 0;
            NewsCompanyRelationship relationship = new NewsCompanyRelationship();
            relationship.setNewsnoticeId(notice.getId());
            relationship.setUpdateBy(currentUser.getUsername());
            relationship.setUpdateTime(new Date());

            newsCompanyRelationshipDao.deleteByNoticePoliceId(relationship);
            for (String companyId : notice.getCompanyIds()) {
                relationship = new NewsCompanyRelationship();
                relationship.setActive(true);
                relationship.setCreateTime(new Date());
                relationship.setCompanyname(notice.getCompanyNames()[i]);
                relationship.setCompanyId(Long.parseLong(companyId));
                relationship.setNewsnoticeId(notice.getId());
                relationship.setUpdateBy(currentUser.getUsername());
                relationship.setUpdateTime(new Date());

                relationship.setUpdateflag(true);

                newsCompanyRelationshipDao.save(relationship);
                i++;
            }
        }
        if (notice.getRelationIds() != null && notice.getRelationIds().length > 0) {
            int i = 0;
            NewsnoticeRecipient recipient = new NewsnoticeRecipient();
            recipient.setNoticePoliceId(notice.getId());
            recipient.setUpdateTime(new Date());
            recipient.setUpdateBy(currentUser.getUsername());
            newsnoticeRecipientDao.deleteByNoticePoliceId(recipient);
            for (String relationId : notice.getRelationIds()) {
                recipient = new NewsnoticeRecipient();
                recipient.setActive(true);
                recipient.setCreateTime(new Date());
                recipient.setRelationId(relationId);
                recipient.setType(notice.getTypes()[i]);
                recipient.setUpdateBy(currentUser.getUsername());
                recipient.setUpdateTime(new Date());
                recipient.setNoticePoliceId(notice.getId());
                recipient.setUpdateflag(true);
                newsnoticeRecipientDao.save(recipient);
                i++;
            }
        }

        if (StringUtil.isNotEmpty(notice.getTemporaryState()) && notice.getTemporaryState().equals(Constants.MSG_TEMPORARYSTATE_SEND)) {
            NewsnoticeCompany newsnoticeCompany = null;
            for (String companyId : notice.getCompanyIds()) {
                newsnoticeCompany = new NewsnoticeCompany();
                newsnoticeCompany.setActive(true);
                newsnoticeCompany.setCompanyId(Long.parseLong(companyId));
                newsnoticeCompany.setCreateTime(new Date());
                newsnoticeCompany.setNewscontext(notice.getNewsContext());
                newsnoticeCompany.setNewsnoticeid(notice.getId());
                newsnoticeCompany.setNewstitle(notice.getNewsTitle());
                newsnoticeCompany.setReadstate(Constants.READSTATUS_UNREAD);
                newsnoticeCompany.setSendname(currentUser.getRealname());
                newsnoticeCompany.setSendorgname(currentUser.getPolice().getOrgname());
                newsnoticeCompany.setUpdateBy(currentUser.getUsername());
                newsnoticeCompany.setUpdateTime(new Date());
                newsnoticeCompany.setUpdateflag(true);
                newsnoticeCompany.setUndoState(Constants.DOSTATE);
                newsnoticeCompany.setReplyAtt(notice.getReplyAtt());
                newsnoticeCompany.setId(idGeneratorUtil.createID());

                newsnoticeCompanyDao.save(newsnoticeCompany);
            }
        }
    }

    @Override
    public PageResult queryTable(NewsnoticePoliceSearchDto searchDto) {
        arsUtil.setPoliceSearch(searchDto);
        List<NewsnoticePolice> list = newsnoticePoliceDao.search(searchDto);
        Long count = newsnoticePoliceDao.searchCount(searchDto);
        return new PageResult(count.intValue(), list);
    }

    @Override
    public void delete(Long noticeId) {
        User currentUser = arsUtil.getCurrentUser();
        NewsnoticePolice dbNotice = newsnoticePoliceDao.findById(noticeId);
        if (dbNotice != null) {
            dbNotice.setActive(false);
            dbNotice.setUpdateBy(currentUser.getUsername());
            dbNotice.setUpdateTime(new Date());
            newsnoticePoliceDao.delete(dbNotice);
        }
    }

    @Override
    public void recall(Long noticeId) {
        User currentUser = arsUtil.getCurrentUser();
        NewsnoticePolice dbNotice = newsnoticePoliceDao.findById(noticeId);
        if (dbNotice != null) {
            dbNotice.setUndoState("1");
            dbNotice.setUpdateBy(currentUser.getUsername());
            dbNotice.setUpdateTime(new Date());
            dbNotice.setUpdateflag(true);
            //dbNotice.setUnreadnum(0);
            //dbNotice.setReadnum(0);
            newsnoticePoliceDao.recall(dbNotice);

            NewsnoticeCompany newsnoticeCompany = new NewsnoticeCompany();
            newsnoticeCompany.setNewsnoticeid(noticeId);
            newsnoticeCompany.setUpdateBy(currentUser.getUsername());
            newsnoticeCompany.setUpdateTime(new Date());
            newsnoticeCompany.setUpdateflag(true);
            newsnoticeCompanyDao.recallByNoticePoliceId(newsnoticeCompany);
        }
    }

    @Override
    public NewsnoticePolice findById(Long noticeId) {
        return newsnoticePoliceDao.findById(noticeId);
    }

    @Override
    public void batchDelete(Long[] noticeIds) {
        User currentUser = arsUtil.getCurrentUser();
        for (Long noticeId : noticeIds) {
            NewsnoticePolice dbNotice = newsnoticePoliceDao.findById(noticeId);
            if (dbNotice != null) {
                dbNotice.setActive(false);
                dbNotice.setUpdateBy(currentUser.getUsername());
                dbNotice.setUpdateTime(new Date());
                dbNotice.setUpdateflag(true);
                newsnoticePoliceDao.delete(dbNotice);
            }
        }
    }

    @Override
    public NewsnoticePolice findAllById(Long noticeId) {
        NewsnoticePolice newsnoticePolice = newsnoticePoliceDao.findById(noticeId);
        newsnoticePolice.setSysAttachments(sysAttachmentDao.findAllByBusiness(newsnoticePolice.getId().toString(), Constants.FILE_BUSINESSTYPE_MSG_POLICE));
        newsnoticePolice.setRecipients(newsCompanyRelationshipDao.findByNoticePoliceId(newsnoticePolice.getId()));
        newsnoticePolice.setOriginalRecipients(newsnoticeRecipientDao.findByNoticePoliceId(newsnoticePolice.getId()));

        if (newsnoticePolice.getTemporaryState().equals(Constants.MSG_TEMPORARYSTATE_SEND)) {
            //类型为公安
            if(Constants.NEWSTYPE_POLICE.equals(newsnoticePolice.getNewsType())){
                newsnoticePolice.setNoticeCompanys(newsnoticeCompanyDao.findByNoticePoliceIdForUser(newsnoticePolice.getId()));
            }else{
                //类型为公司
                newsnoticePolice.setNoticeCompanys(newsnoticeCompanyDao.findByNoticePoliceId(newsnoticePolice.getId()));
            }
        }
        return newsnoticePolice;
    }

    @Override
    public List<NewsnoticePolice> findDSOutList(String startDate) {
        return newsnoticePoliceDao.searchFromInToOutForExport(startDate);
    }

    @Override
    public List<NewsnoticePolice> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return newsnoticePoliceDao.searchForDataSynchronization(searchDto);
    }

    /**
     * @Author: wangcy
     * @Description:内网同步数据
     * @Date: 2018/03/08 0008 15:36
     */
    @Override
    public void saveOrUpdateForDS(NewsnoticePolice newsnoticePolice) {
        newsnoticePolice.setUpdateflag(false);
        if (newsnoticePolice.getActive() == null) {
            newsnoticePolice.setActive(true);
        }
        //和数据进行比较有就更新无就创建
        NewsnoticePolice dbnewsnoticePolice = newsnoticePoliceDao.findById(newsnoticePolice.getId());
        if (dbnewsnoticePolice != null) {
            if (dbnewsnoticePolice.getActive() != newsnoticePolice.getActive() || (StringUtil.isNotEmpty(dbnewsnoticePolice.getUndoState()) && !dbnewsnoticePolice.getUndoState().equals(newsnoticePolice.getUndoState()))) {
                newsnoticePolice.setActive(dbnewsnoticePolice.getActive());
                newsnoticePolice.setUndoState(dbnewsnoticePolice.getUndoState());
                if(dbnewsnoticePolice.getUpdateflag()){
                    newsnoticePolice.setUpdateflag(true);
                }
                newsnoticePoliceDao.updateForDS(newsnoticePolice);
            } else if (newsnoticePolice.getUpdateTime().getTime() > dbnewsnoticePolice.getUpdateTime().getTime()) {
                newsnoticePoliceDao.updateForDS(newsnoticePolice);
            }
        }
    }

    @Override
    public List<ZTree> getPoliceUserTree() {
        NewsnoticePoliceSearchDto  searchDto =  new NewsnoticePoliceSearchDto();
        User currentUser = arsUtil.getCurrentUser();
        searchDto.setUserid(currentUser.getId());
        searchDto.setPath(currentUser.getPolice().getPath());
        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {//省z
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {//区
                searchDto.setAreaCode(areacode);
            }
        }
        List<ZTree> list = newsnoticePoliceDao.getPoliceUserTree(searchDto);
        Map<String,Integer> countMap = new HashMap<String,Integer>();
        for(ZTree zTree: list){
            if(zTree.getType().equals("1")){
                String[] keys = zTree.getPath().split("/");

                for (String key : keys) {
                    if(StringUtil.isNotEmpty(key)){
                        Integer count = countMap.get(key);
                        if(count == null){
                            count = 0;
                        }
                        countMap.put(key,++count);
                    }
                }
            }
        }
        for(ZTree zTree: list){
            zTree.setPath(null);
            if(zTree.getType().equals("0")){
                zTree.setName(zTree.getName()+"("+countMap.get(zTree.getId()) +")");
            }
        }

        return list;
    }

    @Override
    public void saveOrUpdateForImport(NewsnoticePolice newsnoticePolice) {
        try {
            newsnoticePolice.setUpdateflag(false);
            NewsnoticePolice dbNewsnoticePolice = newsnoticePoliceDao.findById(newsnoticePolice.getId());
            if (dbNewsnoticePolice == null) {
                //新增
                newsnoticePolice.setUpdateTime(DateUtil.dateAdd2(DateUtil.DATATYPE_SECOND, newsnoticePolice.getUpdateTime(), 1));
                //发送给保安人员或企业消息 TODO
                sendMsg(newsnoticePolice);
                newsnoticePoliceDao.saveForDS(newsnoticePolice);
            } else {

                //删除或撤消
                if (dbNewsnoticePolice.getActive() != newsnoticePolice.getActive() || (StringUtil.isNotEmpty(newsnoticePolice.getUndoState()) && !newsnoticePolice.getUndoState().equals(dbNewsnoticePolice.getUndoState()))) {
                    //删除或撤消 保安人员或企业消息 TODO
                    delMsg(dbNewsnoticePolice);
                    dbNewsnoticePolice.setActive(newsnoticePolice.getActive());
                    dbNewsnoticePolice.setUndoState(newsnoticePolice.getUndoState());
                    //有删除或撤消设置为最新
                    dbNewsnoticePolice.setUpdateTime(new Date());
                    newsnoticePoliceDao.updateForDS(dbNewsnoticePolice);
                } else if (newsnoticePolice.getUpdateTime().getTime() > dbNewsnoticePolice.getUpdateTime().getTime()) {
                    //时间上加1秒
                    newsnoticePolice.setUpdateTime(DateUtil.dateAdd2(DateUtil.DATATYPE_SECOND, newsnoticePolice.getUpdateTime(), 1));
                    if (!dbNewsnoticePolice.getTemporaryState().equals(newsnoticePolice.getTemporaryState())) {
                        //发送给保安人员或企业消息 TODO
                        sendMsg(newsnoticePolice);
                    }
                    newsnoticePoliceDao.updateForDS(newsnoticePolice);
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    /****
     * 发送消息给公共安全服务平台
     * @param newsnoticePolice 公安消息
     */
    private void delMsg(NewsnoticePolice newsnoticePolice) {
        try {
            //没有删除且没有撤消才
            if(newsnoticePolice.getActive()  && Constants.DOSTATE.equals(newsnoticePolice.getUndoState()) ) {
                //发送消息给公共安全服务平台
                SAASMessage message = new SAASMessage();
                message.setId(newsnoticePolice.getMessageIdSaaS());
                message.setMessageType(Constants.MESSAGETYPE_050301);
                List<SAASMessage> list = new ArrayList<>();
                list.add(message);
                SAASMessageDto messageDto = new SAASMessageDto();
                messageDto.setMessageJson(JSON.toJSONString(list));
                saasInterfaceUtil.delSaasMsg(messageDto);
                //发送消息给公共安全服务平台
            }
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
            throw new ArsException("公共服务平台消息发送失败ID"+newsnoticePolice.getId());
        }
    }

    /****
     * 发送消息给公共安全服务平台
     * @param newsnoticePolice 公安消息
     */
    private void sendMsg(NewsnoticePolice newsnoticePolice) {
        try {
            //没有删除且没有撤消才
            if(newsnoticePolice.getActive()  && Constants.DOSTATE.equals(newsnoticePolice.getUndoState()) ) {
                //标题
                String title = newsnoticePolice.getNewsTitle();
                //内容
                String content = newsnoticePolice.getNewsContext();
                //获取公司列表
                List<NewsnoticeCompany> newsnoticeCompanyList = newsnoticeCompanyDao.findByNoticePoliceId(newsnoticePolice.getId());

                if(newsnoticeCompanyList.size() > 0){
                    List<Long> idList = newsnoticeCompanyList.stream().map(NewsnoticeCompany::getCompanyId).collect(Collectors.toList());
                    List<SaaSCompany> saaSCompanyList = securityCompanyDao.findUserNameByBatchId(idList);
                    saaSCompanyList.stream().map(SaaSCompany::getComId).collect(Collectors.joining(",", "", ""));
                    //获取附件列表
                    List<SysAttachment> sysAttachmentList = sysAttachmentDao.findAllByBusiness(newsnoticePolice.getId().toString(), Constants.FILE_BUSINESSTYPE_MSG_POLICE);
                    //发送消息给公共安全服务平台
                    SAASMessageDto messageDto = new SAASMessageDto();
                    messageDto.setTitle(title);
                    messageDto.setContent(content);
                    //公司ID列表
                    if(saaSCompanyList!=null && saaSCompanyList.size()>0) {
                        messageDto.setComIds(saaSCompanyList.stream().map(SaaSCompany::getComId).collect(Collectors.joining(",", "", "")));
                    }
                    //附件列表
                    StringBuffer enclosureUrl = new StringBuffer();
                    if(sysAttachmentList!=null && sysAttachmentList.size()>0) {
                        Config webHost = configUtils.getConfigByKey(Constants.WEBHOST);
                        for (SysAttachment at : sysAttachmentList
                                ) {
                            if (webHost != null) {
                                enclosureUrl.append(webHost.getValue());
                            }
                            enclosureUrl.append(Constants.ATTACHMENT_URL).append(at.getId()).append("||");
                            enclosureUrl.append(at.getFileName().replaceAll("||","").replaceAll("&&","")).append("&&");
                        }
                        //去掉最后一个多余的逗号
                        enclosureUrl.deleteCharAt(enclosureUrl.length() - 1);
                        enclosureUrl.deleteCharAt(enclosureUrl.length() - 1);
                    }
                    messageDto.setEnclosureUrl(enclosureUrl.toString());
                    //发件人设置机构名称
                    messageDto.setSendPer(newsnoticePolice.getSendOrgName());
                    //如果要发送给人员，则获取列表信息
                    messageDto.setNoticePerson(newsnoticePolice.getNoticeperson());
                    //消息类型
                    messageDto.setMessageType(Constants.MESSAGETYPE_050301);
                    //区域编码
                    messageDto.setPoliceRegionId(newsnoticePolice.getAreaCode());
                    //是否回调
                    messageDto.setIsNeedCallBackBBD(Constants.NEEDCALLBACKBBD_YES);
                    AjaxResult result = saasInterfaceUtil.sendSaasMsg(messageDto);
                    if (result.isSuccessful()) {
                        //存储公共服务平台消息ID，用于后续已读消息使用
                        newsnoticePolice.setMessageIdSaaS(result.getData().toString());
                    }/*else{
                        throw new ArsException("公共服务平台消息发送失败ID"+newsnoticePolice.getId());
                    }*/
                    //发送消息给公共安全服务平台

                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
            throw new ArsException("公共服务平台消息发送失败ID"+newsnoticePolice.getId());
        }
    }

    @Override
    public void searchForPage(NewsnoticePolicePageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
        newsnoticePoliceDao.searchForPage(dto,page);
    }
}
