package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyScheduleDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.SecurityCompanySchedule;
import com.bcxin.ars.service.SecurityCompanyScheduleService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = SecurityCompanySchedule.class)
public class SecurityCompanyScheduleServiceImpl implements SecurityCompanyScheduleService {

	@Autowired
	private IdGeneratorUtil idGeneratorUtil;
	@Autowired
	private SecurityCompanyScheduleDao securityCompanyScheduleDao;
	
	@Autowired
	private ArsUtil arsUtil;

	@Override
	public List<SecurityCompanySchedule> findByCompanyId(Long companyId) {
		return securityCompanyScheduleDao.findByCompanyId(companyId);
	}

	@Override
	public SecurityCompanySchedule findById(Long id) {
		return securityCompanyScheduleDao.findById(id);
	}

	@Override
	public void saveOrUpdate(SecurityCompanySchedule schedule) {
		SecurityCompanySchedule dbSchedule = securityCompanyScheduleDao.findById(schedule.getId());
		if(dbSchedule == null) {
			if(null == schedule.getId()){
				schedule.setId(idGeneratorUtil.createID());
			}
			schedule.setNativeCode(arsUtil.getCurrentNatvie());
			schedule.setCreateTime(new Date());
			schedule.setUpdateTime(schedule.getCreateTime());
			schedule.setUpdateBy(arsUtil.getCurrentUser().getRealname());
			securityCompanyScheduleDao.save(schedule);
		} else {

			if(dbSchedule != null) {
				dbSchedule.setUpdateTime(new Date());
				dbSchedule.setUpdateBy(arsUtil.getCurrentUser().getRealname());
				if(schedule.getName() != null && schedule.getName().trim().length() > 0) {
					dbSchedule.setName(schedule.getName());
				}
				if(schedule.getStartTime() != null && schedule.getStartTime().trim().length() > 0) {
					dbSchedule.setStartTime(schedule.getStartTime());
				}
				if(schedule.getEndTime() != null && schedule.getEndTime().trim().length() > 0) {
					dbSchedule.setEndTime(schedule.getEndTime());
				}
				securityCompanyScheduleDao.update(dbSchedule);
			}
		}
	}

	@Override
	public void saveOrUpdateForDS(SecurityCompanySchedule schedule) {

		if(schedule.getActive() == null){
			schedule.setActive(true);
		}
		
		if(!schedule.getActive()){
			securityCompanyScheduleDao.delete(schedule);
			return;
		}
		SecurityCompanySchedule dbSchedule = findById(schedule.getId());
		if(dbSchedule == null) {
			securityCompanyScheduleDao.saveForDS(schedule);
		} else {
			if(schedule.getUpdateTime().getTime() > dbSchedule.getUpdateTime().getTime()){
				securityCompanyScheduleDao.update(schedule);
			}
		}
	}
	
	@Override
	public void delete(SecurityCompanySchedule schedule) {
		SecurityCompanySchedule dbSchedule = securityCompanyScheduleDao.findById(schedule.getId());
		if(dbSchedule != null && dbSchedule.getCompanyId().longValue() == schedule.getCompanyId().longValue()) {
			schedule.setUpdateTime(new Date());
			securityCompanyScheduleDao.delete(schedule);
		}
	}
	@Override
	public long findByCompanyIdWithTask(long id){

		return securityCompanyScheduleDao.findByCompanyIdWithTask(id);
	}

	@Override
	public List<SecurityCompanySchedule> searchForDataSynchronization( DataSynchronizationSearchDto searchDto) {
		return securityCompanyScheduleDao.searchForDataSynchronization(searchDto);
	}
}
