package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SbPunishDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbPunishSearchDto;
import com.bcxin.ars.model.SbPunish;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.SbPunishService;
import com.bcxin.ars.service.util.ArsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = SbPunish.class)
public class SbPunishServiceImpl implements SbPunishService {

	@Autowired
	private SbPunishDao sbPunishDao;

	@Autowired
	private SecurityPersonDao securityPersonDao;


	@Autowired
	private ArsUtil arsUtil;

	/**
	 * 保存或更新
	 * @param sbPunish
	 */
	@Override
	public void saveOrUpdate(SbPunish sbPunish) {
        User user = arsUtil.getCurrentUser();
		//判断是否存在，如果存在则为更新否则为保存
		SbPunish dbSbPunish = sbPunishDao.findById(sbPunish.getId());
		if(dbSbPunish != null) {
			//设置修改时间
			dbSbPunish.setUpdateTime(new Date());
			//设置修改者
			dbSbPunish.setUpdateBy(user.getRealname());
			//如果不为空，则更新相应字段的值
			if(!StringUtils.isEmpty(sbPunish.getDepartname())) {
				dbSbPunish.setDepartname(sbPunish.getDepartname());
			}
			if(!StringUtils.isEmpty(sbPunish.getEmployeeid())) {
				dbSbPunish.setEmployeeid(sbPunish.getEmployeeid());
			}
			if(!StringUtils.isEmpty(sbPunish.getIdNumber())) {
				dbSbPunish.setIdNumber(sbPunish.getIdNumber());
			}
			if(!StringUtils.isEmpty(sbPunish.getName())) {
				dbSbPunish.setName(sbPunish.getName());
			}
			if(!StringUtils.isEmpty(sbPunish.getRemarks())) {
				dbSbPunish.setRemarks(sbPunish.getRemarks());
			}

			if(!StringUtils.isEmpty(sbPunish.getPunishContext())) {
				dbSbPunish.setPunishContext(sbPunish.getPunishContext());
			}
			if(!StringUtils.isEmpty(sbPunish.getPunishDate())) {
				dbSbPunish.setPunishDate(sbPunish.getPunishDate());
			}
			if(!StringUtils.isEmpty(sbPunish.getPunishReason())) {
				dbSbPunish.setPunishReason(sbPunish.getPunishReason());
			}
			dbSbPunish.setIsByPolice(sbPunish.getIsByPolice());
			dbSbPunish.setPunishCompany(sbPunish.getPunishCompany());

			sbPunishDao.update(dbSbPunish);
		}else{
			if(user.getPlatform()==2){
				sbPunish.setUserid(user.getId());
			}
			//修改时间，创建时间在保存的时候一样
			sbPunish.setCreateTime(new Date());
			sbPunish.setUpdateTime(sbPunish.getCreateTime());
			//默认可用
			sbPunish.setActive(true);
			sbPunish.setUpdateBy(user.getUsername());
			sbPunishDao.save(sbPunish);
		}
		}

	/**
	 * 删除
	 * @param sbPunish
	 */

	@Override
	public void delete(SbPunish sbPunish) {
		sbPunish.setUpdateTime(new Date());
		sbPunishDao.delete(sbPunish);
	}

	/**
	 *根据ID查询
	 * @param id
	 */
	@Override
	public SbPunish findById(long id){
		return sbPunishDao.findById(id);
	}

	/**
	 * 查询
	 * @param dto
	 * @return
	 */
	@Override
	public SbPunishSearchDto search(SbPunishSearchDto dto) {
		SbPunishSearchDto resultDto = new SbPunishSearchDto();
		List<SbPunish> list =  sbPunishDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(sbPunishDao.count(dto));
		return resultDto;
	}

	@Override
	public List<SbPunish> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return sbPunishDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void saveOrUpdateForDS(SbPunish sbPunish) {

		if(sbPunish.getActive() == null){
			sbPunish.setActive(true);
		}
		
		if(!sbPunish.getActive()){
			sbPunishDao.delete(sbPunish);
		}else{
			SbPunish dbSbPunish = sbPunishDao.findById(sbPunish.getId());
			if(dbSbPunish == null){
				sbPunishDao.saveForDS(sbPunish);
			}else{
				if(sbPunish.getUpdateTime().getTime() > dbSbPunish.getUpdateTime().getTime()){
					sbPunishDao.update(sbPunish);
				}
			}
		}
	}

	@Override
	public void saveOrUpdateForSAAS(List<SbPunish> sbPunishList) {
		User user = arsUtil.getCurrentUser();
		//判断是否存在，如果存在则为更新否则为保存

		if(null!=sbPunishList&&null!=sbPunishList.get(0)){
			List<SbPunish> dbSbPunishlist = sbPunishDao.findByPenaltyId(sbPunishList.get(0).getPenaltyId());
			//如果不为空，则更新相应字段的值
			if(null!=dbSbPunishlist&&dbSbPunishlist.size()>0) {
				sbPunishDao.deleteByPenaltyId(sbPunishList.get(0).getPenaltyId());
			}
		}

		for (SbPunish sbPunish: sbPunishList) {
			if(user.getPlatform()==2){
				sbPunish.setUserid(user.getId());
			}
			//修改时间，创建时间在保存的时候一样
			sbPunish.setCreateTime(new Date());
			sbPunish.setUpdateTime(sbPunish.getCreateTime());
			//默认可用
			sbPunish.setActive(true);
			sbPunish.setUpdateBy(user.getUsername());
			sbPunishDao.save(sbPunish);
		}
	}

	@Override
	public List<SbPunish> findByPenaltyId(Long id) {
		return sbPunishDao.findByPenaltyId(id);
	}

	@Override
	public void deleteByPenaltyId(Long penaltyId) {
		sbPunishDao.deleteByPenaltyId(penaltyId);
	}
}


