package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.PersonBaseInfoDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.PersonBaseImg;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.service.PersonBaseInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * @author linqinglin
 * @date 2019/09/19 0019 13:51
 */
@Service
//@DataSyncAnnotation(getClazz = PersonBaseInfo.class,getMethodName = "updateFlagForOutToIn",getImportType = ImportType.BATCH)
//@DataSyncOutAnnotation(getClazz = PersonBaseInfo.class)
public class PersonBaseInfoServiceImpl implements PersonBaseInfoService {

    @Autowired
    private PersonBaseInfoDao personBaseInfoDao;

    @Override
    public List<String> findUnGetBaseInfoList() {
        List<String> list = personBaseInfoDao.findUnGetBaseInfoListFormApproval();
        if(list.size()<1){
            list = personBaseInfoDao.findUnGetBaseInfoListFormPerson();
        }
        if(list.size()<1){
            list = personBaseInfoDao.findUnGetBaseInfoListFormOldData();
        }
        return list;
    }

    @Override
    public void save(PersonBaseInfo personBaseInfo) {
        personBaseInfo.setUpdateTime(new Date());
        personBaseInfo.setUpdateflag(true);
        personBaseInfoDao.insert(personBaseInfo);
    }

    /**
     * @Decription:外到内更新修改标志
     * @param list
     * @return
     */
    @Override
    public void updateFlagForOutToIn(List<PersonBaseInfo> list) {
        personBaseInfoDao.updateFlagForOutToIn(list);
    }

    /**
     * 搜索同步到内网的数据
     * @param dto
     * @return
     */
    @Override
    public List<PersonBaseInfo> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return personBaseInfoDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<PersonBaseInfo> findDSOutList(String startDate) {
        return personBaseInfoDao.searchForExport(startDate);
    }

    /**
     * 批量导入
     * @param list
     */
    @Override
    public void importBatch(List<PersonBaseInfo> list){
        List<PersonBaseInfo> dbList = personBaseInfoDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);

        if (list.size()>0){
            for(PersonBaseInfo detail:list){
                detail.setUpdateflag(false);
                try {
                    detail.setUpdateTime(com.bcxin.ars.util.DateUtil.dateAdd(com.bcxin.ars.util.DateUtil.DATATYPE_SECOND, detail.getUpdateTime(), 1));
                }catch (Exception e){

                }
            }
            //批量保存
            personBaseInfoDao.saveBatch(list);
        }
    }

    @Override
    public List<PersonBaseImg> findByConver() {
        return personBaseInfoDao.findByConver();
    }

    @Override
    public void updateImgBlob(PersonBaseImg personBaseImg) {
        personBaseInfoDao.updateImg(personBaseImg);
    }

    @Override
    public PersonBaseInfo findByIdNum(String idNum) {
        return personBaseInfoDao.findByIdNum(idNum);
    }

    @Override
    public List<PersonBaseImg> createData(String fzrq) {
        return personBaseInfoDao.prc_createData(fzrq);
    }
}
