package com.bcxin.ars.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.dao.NativeDao;
import com.bcxin.ars.model.Native;
import com.bcxin.ars.service.NativeService;

@Service
@Transactional
public class NativeServiceImpl implements NativeService {
	
	@Autowired
	private NativeDao nativeDao;
	
	@Override
	public Native findByCode(Long code) {
		return nativeDao.findByCode(code);
	}

	@Override
	public List<Native> findProvince() {
		return nativeDao.findProvince();
	}

	@Override
	public List<Native> findByParentCode(Long code) {
		return nativeDao.findByParentCode(code);
	}

	@Override
	public Map<Long, List<Native>> findMap() {
		List<Native> nativeList = nativeDao.findAll();
		List<Native> province = new ArrayList<Native>();
		Map<Long, List<Native>> data = new HashMap<Long, List<Native>>();
		for(Native na : nativeList) {
			if(na.getParentCode() == null) {
				province.add(na);
			} else {
				if(data.get(na.getParentCode()) != null) {
					List<Native> dd = data.get(na.getParentCode());
					dd.add(na);
					data.put(na.getParentCode(), dd);
				} else {
					List<Native> dd = new ArrayList<Native>();
					dd.add(na);
					data.put(na.getParentCode(), dd);
				}
			}
		}
		data.put(0L, province);
		return data;
	}

	@Override
	public List<Native> findAll() {
		return nativeDao.findAll();
	}
	
}
