package com.bcxin.ars.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.dao.EduDao;
import com.bcxin.ars.model.Edu;
import com.bcxin.ars.service.EduService;

@Service
@Transactional
public class EduServiceImpl implements EduService {

	@Autowired
	private EduDao eduDao;
	
	@Override
	public List<Edu> findAll() {
		return eduDao.findAll();
	}
	
	@Override
	public Map<Long, Edu> findMap() {
		List<Edu> eduList = eduDao.findAll();
		Map<Long, Edu> result = new HashMap<Long, Edu>();
		for(Edu edu : eduList) {
			result.put(edu.getId(), edu);
		}
		return result;
	}

	@Override
	public Edu findById(Long id) {
		return eduDao.findById(id);
	}

}
