package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.CyCheckDao;
import com.bcxin.ars.dto.sb.CyCheckSearchDto;
import com.bcxin.ars.model.CyCheck;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.CyCheckService;
import com.bcxin.ars.service.sb.impl.InvestorServiceImpl;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.webservice.Badwjdjcxx;
import com.bcxin.ars.webservice.ClientUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;

@Service
@Transactional
public class CyCheckServiceImpl implements CyCheckService {


    private static Logger logger = LoggerFactory.getLogger(CyCheckServiceImpl.class);

    @Autowired
    private CyCheckDao cyCheckDao;


    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private ClientUtil clientUtil;
    /**
     * 保存或更新
     *
     * @param cyCheck
     */
    @Override
    public void saveOrUpdate(CyCheck cyCheck) {
        User user = arsUtil.getCurrentUser();
        //判断是否存在，如果存在则为更新否则为保存
        CyCheck dbCyCheck = cyCheckDao.findById(cyCheck.getId());
        if (dbCyCheck != null) {
            //设置修改时间
            dbCyCheck.setUpdateTime(new Date());
            //设置修改者
            dbCyCheck.setUpdateBy(user.getRealname());
            //如果不为空，则更新相应字段的值
            if (!StringUtils.isEmpty(cyCheck.getCheckContext())) {
                dbCyCheck.setCheckContext(cyCheck.getCheckContext());
            }
            if (!StringUtils.isEmpty(cyCheck.getCheckDate())) {
                dbCyCheck.setCheckDate(cyCheck.getCheckDate());
            }
            if (!StringUtils.isEmpty(cyCheck.getCheckResult())) {
                dbCyCheck.setCheckResult(cyCheck.getCheckResult());
            }
            if (!StringUtils.isEmpty(cyCheck.getCompanyName())) {
                dbCyCheck.setCompanyName(cyCheck.getCompanyName());
            }
            if (!StringUtils.isEmpty(cyCheck.getNumno())) {
                dbCyCheck.setNumno(cyCheck.getNumno());
            }
            if (!StringUtils.isEmpty(cyCheck.getCompanyNo())) {
                dbCyCheck.setCompanyNo(cyCheck.getCompanyNo());
            }

            cyCheckDao.update(dbCyCheck);

        } else {
            cyCheck.setUserid(user.getId());
            //修改时间，创建时间在保存的时候一样
            cyCheck.setCreateTime(new Date());
            cyCheck.setUpdateTime(cyCheck.getCreateTime());
            //默认可用
            cyCheck.setActive(true);
            cyCheck.setUpdateBy(user.getUsername());
            cyCheckDao.save(cyCheck);
            
            //部级接口对接
            new Thread(()->{ //异步处理
				try {
					Badwjdjcxx badwjdjcxx = new Badwjdjcxx();
                    //TODO 单位编码，须13位
                    badwjdjcxx.setBagsbm("1234567890123");
                    //被检查单位类型
                    badwjdjcxx.setJclx("1");
                    //检查日期
					badwjdjcxx.setJcrq(cyCheck.getCheckDate().replaceAll("-",""));
					//主要检查人员身份号码
                    badwjdjcxx.setSfzh(user.getIdNumber());
                    //检查类别
                    badwjdjcxx.setJclb("1");
					//调用send方法完成对接
                    clientUtil.send(Constants.XXBA_BADWJDJCXX,badwjdjcxx);
				} catch(Exception e) {
                    logger.error(e.getMessage(),e);
				}
			}).start();
        }
    }

    /**
     * 删除
     *
     * @param cyCheck
     */
    public void delete(CyCheck cyCheck) {
        cyCheck.setUpdateTime(new Date());
        cyCheckDao.delete(cyCheck);
    }

    /**
     * 根据ID查询
     *
     * @param id
     * @return
     */
    @Override
    public CyCheck findById(long id) {
        return cyCheckDao.findById(id);
    }

    /**
     * 统计条数
     *
     * @return
     */
    @Override
    public long count(CyCheckSearchDto dto) {
        return cyCheckDao.count(dto);
    }

    /**
     * 查询
     *
     * @param dto
     * @return
     */
    @Override
    public CyCheckSearchDto search(CyCheckSearchDto dto) {
        CyCheckSearchDto resultDto = new CyCheckSearchDto();
        List<CyCheck> list = cyCheckDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(cyCheckDao.count(dto));
        return resultDto;
    }

    @Override
    public List<CyCheck> searchForExportData(CyCheckSearchDto dto) {
        return cyCheckDao.searchForExportData(dto);
    }

    @Override
    public void saveOrUpdateForDS(CyCheck cyCheck) {
        if (cyCheck.getActive() == null) {
            cyCheck.setActive(true);
        }

        if (!cyCheck.getActive()) {
            cyCheckDao.delete(cyCheck);
            return;
        }
        Long cyCheckId = 0l;
        if (cyCheck.getId() != null) {
            cyCheckId = cyCheck.getId();
        }
        CyCheck dbCyCheck = findById(cyCheckId);
        if (dbCyCheck == null) {
            cyCheckDao.saveForDS(cyCheck);
        } else {
            cyCheckDao.update(cyCheck);
        }
    }
}


