package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.CyAssociationDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.CyAssociationPageSearchDto;
import com.bcxin.ars.model.CyAssociation;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.CyAssociationService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.BuildWebServiceEntity;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.webservice.Baxhxx;
import com.bcxin.ars.webservice.ClientUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
/**
 * 保安协会Service实现类
 *
 * @author linqinglin
 * @Date 2020-08-05 22:14:24
 */
@Service
@Transactional
public class CyAssociationServiceImpl implements CyAssociationService {

	Logger logger = LoggerFactory.getLogger(CyAssociationServiceImpl.class);

	@Autowired
	private CyAssociationDao cyAssociationDao;

	@Autowired
	private ConfigUtils configUtils;

	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private ClientUtil clientUtil;

	@Override
	public int delete(CyAssociation cyAssociation) {
		User currentUser = arsUtil.getCurrentUser();
		cyAssociation.setUpdateTime(new Date());
		cyAssociation.setUpdateBy(currentUser.getUsername());
		return cyAssociationDao.delete(cyAssociation);
	}

	@Override
	public int save(CyAssociation cyAssociation) {
		User currentUser = arsUtil.getCurrentUser();
		if(cyAssociation.getId() == null){
			cyAssociation.setCreateTime(new Date());

			//部级接口对接
			new Thread(()->{ //异步处理
				try {
					//确定对接的属性对应关系
					//源实体类的列，目标实体类的列
					String[] srccol = {"name","hzName","phone","address"};
					String[] desccol = {"baxhmc","hzxm","hzdh","xhxz"};
					//key中存放的是特殊情况下的列，1源实体类没有，而目标实体类必填的2源实体类跟目标实体类值类型不匹配的，比如性别等，value存放特殊列的值。如果没有，则放空
					String[] key = {};
					String[] value = {};
					//生成实体
					Object desc = BuildWebServiceEntity.buildWebServiceEntity(srccol,desccol,cyAssociation,new Baxhxx(),key,value);
					Baxhxx baxhxx =(Baxhxx)desc;
					//调用send方法完成对接
					clientUtil.send(Constants.XXBA_BAXHXX,baxhxx);

				} catch(Exception e) {
					e.printStackTrace();
				}
			}).start();
		}else{
			CyAssociation dbCyAssociation = cyAssociationDao.findById(cyAssociation.getId());
			BeanUtils.copyPropertiesIgnore(cyAssociation,dbCyAssociation,true);
			BeanUtils.copyPropertiesIgnore(dbCyAssociation,cyAssociation,false);
		}
		cyAssociation.setUserId(currentUser.getId());
		cyAssociation.setActive(true);
		cyAssociation.setUpdateBy(currentUser.getUsername());
		cyAssociation.setUpdateTime(new Date());
		cyAssociation.setUpdateflag(true);
		cyAssociation.setAreaCode(currentUser.getPolice().getAreacode());
		return cyAssociationDao.save(cyAssociation);
	}

	@Override
	public CyAssociation findById(Long id) {
		return cyAssociationDao.findById(id);
	}

	@Override
	public void searchForPage(CyAssociationPageSearchDto dto, AjaxPageResponse page) {
		arsUtil.setPoliceSearch(dto);
		cyAssociationDao.searchForPage(dto,page);
	}

	@Override
	public void importBatch(List<CyAssociation> list) {
		List<CyAssociation> dbList = cyAssociationDao.findByBatchId(list);
		//去掉重复的
		//通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
		list.removeAll(dbList);
		if (list.size()>0){
			for (CyAssociation cyAssociation : list) {
				cyAssociation.setUpdateflag(false);
				try {
					if(!configUtils.isIntranet()){
						cyAssociation.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, cyAssociation.getUpdateTime(), 1));
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			cyAssociationDao.saveBatch(list);
		}
	}

	@Override
	public List<CyAssociation> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
		return cyAssociationDao.searchForDataSynchronization(dto);
	}

	@Override
	public List<CyAssociation> findDSOutList(String startDate) {
		return cyAssociationDao.findDSOutList(startDate);
	}

	@Override
	public List<CyAssociation> findByBatchId(List<CyAssociation> list) {
		return cyAssociationDao.findByBatchId(list);
	}

	@Override
	public void updateSelective(CyAssociation cyAssociation) {
		User currentUser = arsUtil.getCurrentUser();
		cyAssociation.setUpdateTime(new Date());
		cyAssociation.setUpdateBy(currentUser.getUsername());
		cyAssociationDao.updateSelective(cyAssociation);
	}
}
