package com.bcxin.ars.service.exam.impl;

import cn.hutool.http.HttpUtil;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.exam.TrainExamInfoDao;
import com.bcxin.ars.dao.exam.TrainExamPersonDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.sys.MessageLogDao;
import com.bcxin.ars.dao.task.AppNoticeDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.exam.TrainExamInfoDto;
import com.bcxin.ars.dto.exam.TrainExamInfoSearchDto;
import com.bcxin.ars.dto.exam.TrainExamPersonSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.exam.TrainExamInfo;
import com.bcxin.ars.model.exam.TrainExamPerson;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.task.AppNotice;
import com.bcxin.ars.service.exam.TrainExamInfoService;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.*;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 考试信息管理
 *
 * @author zhangye
 * @since 1.1
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = TrainExamInfo.class)
public class TrainExamInfoServiceImpl implements TrainExamInfoService {
	private static Logger logger = LoggerFactory.getLogger(TrainExamInfoServiceImpl.class);
	@Autowired
	private TrainExamInfoDao trainExamInfoDao;

	@Autowired
	private TrainExamPersonDao trainExamPersonDao;

	@Autowired
	private SecurityPersonDao securityPersonDao;

	@Autowired
	private AppNoticeDao appNoticeDao;

	@Autowired
	private MessageLogDao messageLogDao;

	@Autowired
	private ConfigDao configDao;

	@Autowired
	private PersoncertificateDao personcertificateDao;

	@Override
	public PageResult query(TrainExamInfoSearchDto trainExamInfoSearchDto) {
		AjaxPageResponse<TrainExamInfoSearchDto> page = new AjaxPageResponse<TrainExamInfoSearchDto>();
		if (trainExamInfoSearchDto.getOffset() == 0) {
			page.setPageNumber(1);
		} else {
			int pageNumber = (trainExamInfoSearchDto.getOffset() / trainExamInfoSearchDto.getLimit()) + 1;
			page.setPageNumber(pageNumber);
		}
		page.setPageSize(trainExamInfoSearchDto.getLimit());
		trainExamInfoDao.query(trainExamInfoSearchDto, page);
		return new PageResult((int) page.getTotal(), page.getData());
	}

	@Override
	public void save(TrainExamInfoDto trainExamInfoDto, User user) {
		// 判断考试名称是否重复
		List<TrainExamInfo> list = trainExamInfoDao.findListByExamName(trainExamInfoDto);
		if (list != null && list.size() > 0) {
			throw new ArsException("考试名称已经存在，不能重复添加!");
		} else {
			try {
				SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				if (StringUtils.isNotEmpty(trainExamInfoDto.getComputerStartDateStr())) {
					trainExamInfoDto.setComputerStartDate(dateFormat.parse(trainExamInfoDto.getComputerStartDateStr()));
				}
				if (StringUtils.isNotEmpty(trainExamInfoDto.getComputerEndDateStr())) {
					trainExamInfoDto.setComputerEndDate(dateFormat.parse(trainExamInfoDto.getComputerEndDateStr()));
				}

				if (StringUtils.isNotEmpty(trainExamInfoDto.getStaminaStartDateStr())) {
					trainExamInfoDto.setStaminaStartDate(dateFormat.parse(trainExamInfoDto.getStaminaStartDateStr()));
				}
				if (StringUtils.isNotEmpty(trainExamInfoDto.getStaminaEndDateStr())) {
					trainExamInfoDto.setStaminaEndDate(dateFormat.parse(trainExamInfoDto.getStaminaEndDateStr()));
				}
			} catch (Exception e) {
				e.printStackTrace();
				throw new ArsException("日期格式错误!");
			}
			IdWorker idWorker = new IdWorker();
			trainExamInfoDto.setId(idWorker.nextId());
			trainExamInfoDto.setActive(true);
			trainExamInfoDto.setCreateTime(new Date());
			trainExamInfoDto.setCreateBy(user.getUsername());
			trainExamInfoDto.setUpdateTime(new Date());
			trainExamInfoDto.setUpdateBy(user.getUsername());
			trainExamInfoDto.setExamState(Constants.EXAMSTATE_NORMAL);
			trainExamInfoDto.setAreaCode(user.getCityAreaCode());
			trainExamInfoDao.insert(trainExamInfoDto);
		}
	}

	@Override
	public TrainExamInfoDto update(TrainExamInfoDto trainExamInfoDto, User user) {
		if (trainExamInfoDto.getId() == null) {
			throw new ArsException("考试ID不能为空!");
		}
		TrainExamInfo trainExamInfo = trainExamInfoDao.selectByPrimaryKey(trainExamInfoDto.getId());
		if (trainExamInfo == null) {
			throw new ArsException("查找不到考试信息!");
		}
		// 判断考试名称是否重复
		List<TrainExamInfo> list = trainExamInfoDao.findListByExamName(trainExamInfoDto);
		if (list != null && list.size() > 0) {
			throw new ArsException("考试名称已经存在，不能重复添加!");
		}
		// 判断考试人员是否发送考试通知，如果是则不能修改
		TrainExamPersonSearchDto trainExamPersonSearchDto = new TrainExamPersonSearchDto();
		trainExamPersonSearchDto.setExamID(trainExamInfoDto.getId());
		trainExamPersonSearchDto.setScoreMsgState(Constants.SCOREMSGSTATECODE_YES);
		List<TrainExamPerson> exitScoreMsgList = trainExamPersonDao.list(trainExamPersonSearchDto);
		if (exitScoreMsgList != null && exitScoreMsgList.size() > 0) {
			throw new ArsException("该考试存在着成绩通知过考生，发送成绩通知人员后将进入审批环节，故不能修改考试信息!");
		}
		try {
			SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			if (StringUtils.isNotEmpty(trainExamInfoDto.getComputerStartDateStr())) {
				trainExamInfoDto.setComputerStartDate(dateFormat.parse(trainExamInfoDto.getComputerStartDateStr()));
			}
			if (StringUtils.isNotEmpty(trainExamInfoDto.getComputerEndDateStr())) {
				trainExamInfoDto.setComputerEndDate(dateFormat.parse(trainExamInfoDto.getComputerEndDateStr()));
			}
			if (StringUtils.isNotEmpty(trainExamInfoDto.getStaminaStartDateStr())) {
				trainExamInfoDto.setStaminaStartDate(dateFormat.parse(trainExamInfoDto.getStaminaStartDateStr()));
			}
			if (StringUtils.isNotEmpty(trainExamInfoDto.getStaminaEndDateStr())) {
				trainExamInfoDto.setStaminaEndDate(dateFormat.parse(trainExamInfoDto.getStaminaEndDateStr()));
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new ArsException("理论、实操日期格式转换错误!");
		}
		trainExamInfoDto.setUpdateTime(new Date());
		trainExamInfoDto.setUpdateBy(user.getUsername());
		trainExamInfoDao.updateByPrimaryKey(trainExamInfoDto);
		// 查询已录入成绩，但未发送成绩通知，则重新计算成绩
		trainExamPersonSearchDto = new TrainExamPersonSearchDto();
		trainExamPersonSearchDto.setExamID(trainExamInfoDto.getId());
		trainExamPersonSearchDto.setScoreMsgState(Constants.SCOREMSGSTATECODE_NO);
		List<TrainExamPerson> exitScoreList = trainExamPersonDao.getScorelist(trainExamPersonSearchDto);
		if (exitScoreList != null && exitScoreList.size() > 0) {
			for (TrainExamPerson dbTrainExamPerson : exitScoreList) {
				int writtenRatio = trainExamInfoDto.getWrittenRatio();// 笔试成绩比例
				int operateRatio = trainExamInfoDto.getOperateRatio();// 体能成绩比例
				int writtenPassScore = trainExamInfoDto.getWrittenPassScore(); // 笔试成绩通过分数
				int operatePassScore = trainExamInfoDto.getOperatePassScore();// 体能成绩通过分数
				int examStandard = trainExamInfoDto.getExamStandard();// 合格标准
				int operateScore = dbTrainExamPerson.getOperateScore();// 体能成绩
				int writtenScore = dbTrainExamPerson.getWrittenScore();// 笔试成绩
				Boolean isOperate = false, isWritten = false;
				// 判断考试类型
				if (trainExamInfoDto.getIsComputerExam() > 0 && trainExamInfoDto.getIsStamina() < 1) {
					operateScore = 0;
					isWritten = true;
				} else if (trainExamInfoDto.getIsComputerExam() < 1 && trainExamInfoDto.getIsStamina() > 0) {
					writtenScore = 0;
					isOperate = true;
				} else {
					isWritten = true;
					isOperate = true;
				}
				// 后判断考试规则
				if (trainExamInfoDto.getExamRules() == Constants.EXAMRULES_ONE) {
					BigDecimal sumScore = BigDecimal.valueOf(operateScore + writtenScore);
					dbTrainExamPerson.setSumScore(sumScore);
					if (writtenScore >= writtenPassScore && operateScore >= operatePassScore) {
						dbTrainExamPerson.setTestState(Constants.TESTSTATE_YES);// 总成绩大于等于双科及格分数则考试状态为合格
					} else {
						dbTrainExamPerson.setTestState(Constants.TESTSTATE_NO);
					}
				} else if (trainExamInfoDto.getExamRules() == Constants.EXAMRULES_TOW) {
					BigDecimal sumScore = BigDecimal
							.valueOf((operateScore * operateRatio + writtenScore * writtenRatio) * 0.01);
					dbTrainExamPerson.setSumScore(sumScore);
					if (sumScore.compareTo(BigDecimal.valueOf(Long.valueOf(examStandard))) >= 0) {
						dbTrainExamPerson.setTestState(Constants.TESTSTATE_YES);// 总成绩大于等于合格标准则考试状态为合格
					} else {
						dbTrainExamPerson.setTestState(Constants.TESTSTATE_NO);
					}
				}
				if (isOperate) {
					dbTrainExamPerson.setOperateScore(operateScore);
				}
				if (isWritten) {
					dbTrainExamPerson.setWrittenScore(writtenScore);
				}
				dbTrainExamPerson.setUpdateTime(new Date());
				trainExamPersonDao.updateScore(dbTrainExamPerson);
			}
		}
		trainExamInfoDto = trainExamInfoDao.selectByPrimaryKey(trainExamInfoDto.getId());
		return trainExamInfoDto;
	}

	@Override
	public TrainExamInfo selectByPrimaryKey(Long examID) {
		if (examID == null) {
			throw new ArsException("考试ID不能为空!");
		}
		TrainExamInfo trainExamInfo = trainExamInfoDao.selectByPrimaryKey(examID);
		if (trainExamInfo == null) {
			throw new ArsException("查找不到考试信息!");
		}
		return trainExamInfoDao.selectByPrimaryKey(examID);
	}

	@Override
	public List<TrainExamInfo> list(TrainExamInfoDto trainExamInfoDto) {
		return trainExamInfoDao.list(trainExamInfoDto);
	}

	@Override
	public int cancel(TrainExamInfoDto trainExamInfoDto, User user) {
		if (trainExamInfoDto.getId() == null) {
			throw new ArsException("考试ID不能为空!");
		}
		TrainExamInfo trainExamInfo = trainExamInfoDao.selectByPrimaryKey(trainExamInfoDto.getId());
		if (trainExamInfo == null) {
			throw new ArsException("查找不到考试信息!");
		}
		// 判断考场人员是否已录入成绩，如果录入则不能取消
		List<TrainExamPerson> exitsList = trainExamPersonDao.exitScore(trainExamInfoDto.getId());
		if (exitsList != null && exitsList.size() > 0) {
			throw new ArsException("该考试存在着已经录入成绩人员，取消考试失败!");
		} else {
			// 取消整场考试,则发送取消通知给考试人员
			TrainExamPersonSearchDto trainExamPersonSearchDto = new TrainExamPersonSearchDto();
			trainExamPersonSearchDto.setExamID(trainExamInfoDto.getId());
			// 已发送考试安排人员列表
			trainExamPersonSearchDto.setNoticeState(Constants.NOTICESTATECODE_YES);
			List<TrainExamPerson> list = trainExamPersonDao.list(trainExamPersonSearchDto);
			if (list != null && list.size() > 0) {
				// 考试信息通知：取消考试安排
				List<Long> bbdPersonIDs = new ArrayList<Long>(); // 考试报名ID列表
				List<Long> examPersons = new ArrayList<Long>(); // 考试人员ID列表
				Config config = configDao.findByKey(Constants.POLICE);
				for (TrainExamPerson item : list) {
					examPersons.add(item.getId());
					try {
						Personcertificate personcertificate = personcertificateDao.findById(item.getBbdPersonID());
						if (personcertificate != null) {
							bbdPersonIDs.add(item.getId());
							// 外网：发送考试通知给考生
							if (config != null && StringUtil.isNotEmpty(config.getValue())
									&& "0".equals(config.getValue())) {
								// 取消考试安排短信通知
								String title = "";// 标题
								String appContent = "";// APP通知
								String msgContent = ""; // 短信通知
								String name = item.getFullname();
								SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy年MM月dd日");
								SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
								title = Constants.EXAM_CANCEL_NOTE_TITLE;
								appContent = Constants.APPROVAL_PERSONCERTIFICATE_EXAM_CANCEL_CONTENT_APP_V1171;
								appContent = appContent.replace("{name}", name)
										.replace("{examDate}", dateFormat.format(trainExamInfo.getComputerStartDate()))
										.replace("{examStart}", timeFormat.format(trainExamInfo.getComputerEndDate()))
										.replace("{examEnd}", timeFormat.format(trainExamInfo.getComputerEndDate()))
										.replace("{staminaDate}",
												dateFormat.format(trainExamInfo.getStaminaStartDate()))
										.replace("{staminaStartDate}",
												timeFormat.format(trainExamInfo.getStaminaStartDate()))
										.replace("{staminaEndDate}",
												timeFormat.format(trainExamInfo.getStaminaEndDate()));
								msgContent = Constants.APPROVAL_PERSONCERTIFICATE_EXAM_CANCEL_CONTENT_MSG_V1171;
								this.sendMsg(personcertificate, title, msgContent, appContent);
							}
						}
					} catch (Exception e) {
						// 消息发送失败不处理，因为使考试取消后考试人员状态要跟资格证人员考试安排状态一致
						logger.error("TrainExamInfoServiceImpl-cancel内网考试安排导出外网后发送考试取消通知失败:" + e.getMessage());
						continue;
					}
				}
				if (bbdPersonIDs != null && bbdPersonIDs.size() > 0) {
					// 批量设置考试安排信息
					if (config != null && StringUtil.isNotEmpty(config.getValue()) && "1".equals(config.getValue())) {
						// 公安内网
						personcertificateDao.updateInnerBatchCancelByExamPersonIds(bbdPersonIDs);
					} else {
						// 公安外网
						personcertificateDao.updateOutBatchCancelByExamPersonIds(bbdPersonIDs);
					}
				}
				// 批量设置考试人员考试通知都未发送，考试状态为不合格
				if (examPersons != null && examPersons.size() > 0) {
					trainExamPersonDao.updateBatchNotNoticeStateByPrimaryKey(examPersons);
				}
			}
			trainExamInfoDto.setExamState(Constants.EXAMSTATE_CANCEL);
			trainExamInfoDto.setUpdateTime(new Date());
			trainExamInfoDto.setUpdateBy(user.getUsername());
			return trainExamInfoDao.updateExamStateByPrimaryKey(trainExamInfoDto);
		}
	}

	@Override
	public Map<String, Object> exportExamData() {
		Map<String, Object> mapData = new HashMap<String, Object>();
		// 导出考试信息
		TrainExamInfo trainExamInfoQuery = new TrainExamInfo();
		Calendar updateTime = Calendar.getInstance();
		Date today = new Date();
		updateTime.setTime(today);
		updateTime.add(Calendar.DATE, -3);// 导出最近三天内更新过的数据
		trainExamInfoQuery.setUpdateTime(updateTime.getTime());
		List<TrainExamInfo> trainExamInfoList = trainExamInfoDao.list(trainExamInfoQuery);// 导出全部
		mapData.put("TrainExamInfo", trainExamInfoList);
		// 导出考试人员
		TrainExamPersonSearchDto dto = new TrainExamPersonSearchDto();
		dto.setUpdateTime(updateTime.getTime());
		List<TrainExamPerson> trainExamPersonList = trainExamPersonDao.list(dto);
		mapData.put("TrainExamPerson", trainExamPersonList);
		return mapData;
	}

	@Override
	public void importExamData(Map<String, Object> examData) {
		String trainUrl = "";
		Config config = configDao.findByKey(Constants.TRAIN);
		trainUrl = config.getValue();
		if (examData != null && examData.size() > 0) {
			// 考试信息
			List<TrainExamInfo> trainExamInfoList = null;
			List<TrainExamPerson> trainExamPersonList = null;
			String trainExamInfoJson = "";
			String trainExamPersonJson = "";
			if (examData.get("TrainExamInfo") != null) {
				trainExamInfoJson = examData.get("TrainExamInfo").toString();
				trainExamInfoList = JSONObject.parseArray(trainExamInfoJson, TrainExamInfo.class);
				// 需要发送取消考试通知列表
				List<TrainExamInfo> cancelTrainExamInfoList = new ArrayList<TrainExamInfo>();
				if (trainExamInfoList != null && trainExamInfoList.size() > 0) {
					// 判断导入更新时间是否大于数据库更新时间，如果大于则更新，小于则不更新
					List<TrainExamInfo> dbTrainExamInfoList = trainExamInfoDao.getExamInfoUpdate(trainExamInfoList);
					if (dbTrainExamInfoList != null && dbTrainExamInfoList.size() > 0) {
						// 待删除不能覆盖外网列表
						List<TrainExamInfo> removeTrainExamInfoList = new ArrayList<TrainExamInfo>();
						for (TrainExamInfo dbTrainExamInfo : dbTrainExamInfoList) {
							for (TrainExamInfo trainExamInfo : trainExamInfoList) {
								// 数据库更新时间大于内网导出外网时间，则不更新数据库
								if (trainExamInfo.getId().equals(dbTrainExamInfo.getId())) {
									// 数据库考试状态与导入考试状态不一致，并且导入状态是取消状态，则需要发送考试取消通知
									if (!trainExamInfo.getExamState().equals(dbTrainExamInfo.getExamState())
											&& trainExamInfo.getExamState().equals(Constants.EXAMSTATE_CANCEL)) {
										cancelTrainExamInfoList.add(trainExamInfo);
									}
									if (dbTrainExamInfo.getUpdateTime().getTime() >= trainExamInfo.getUpdateTime()
											.getTime()) {
										removeTrainExamInfoList.add(trainExamInfo);
										break;
									}
								}
							}
						}
						// 删除不能覆盖外网数据
						if (removeTrainExamInfoList != null && removeTrainExamInfoList.size() > 0) {
							trainExamInfoList.removeAll(removeTrainExamInfoList);
						}
					}
					if (trainExamInfoList != null && trainExamInfoList.size() > 0) {
						// 内网取消考试导出到外网后发送取消通知给考试人员
						if (cancelTrainExamInfoList != null && cancelTrainExamInfoList.size() > 0) {
							for (TrainExamInfo trainExamInfo : cancelTrainExamInfoList) {
								TrainExamPersonSearchDto trainExamPersonSearchDto = new TrainExamPersonSearchDto();
								trainExamPersonSearchDto.setExamID(trainExamInfo.getId());
								// 已发送考试安排人员列表
								trainExamPersonSearchDto.setNoticeState(Constants.NOTICESTATECODE_YES);
								List<TrainExamPerson> list = trainExamPersonDao.list(trainExamPersonSearchDto);
								if (list != null && list.size() > 0) {
									// 取消考试信息通知
									for (TrainExamPerson item : list) {
										try {
											Personcertificate personcertificate = personcertificateDao
													.findById(item.getBbdPersonID());
											if (personcertificate != null) {
												// 考试安排短信通知
												String title = "";// 标题
												String content = "";
												String newstitle = "";
												String name = item.getFullname();
												SimpleDateFormat dateFormat = new SimpleDateFormat(
														"yyyy-MM-dd HH:mm:ss");
												title = Constants.EXAM_CANCEL_NOTE_TITLE;
												content = Constants.APPROVAL_PERSONCERTIFICATE_EXAM_CANCEL_CONTENT
														.replace("{cancelReason}", trainExamInfo.getCancelReason());
												newstitle = Constants.APPROVAL_PERSONCERTIFICATE_EXAM_CANCEL_MSG
														.replace("{cancelReason}", trainExamInfo.getCancelReason());
												content = content.replace("{name}", name)
														.replace("{examStart}",
																dateFormat.format(trainExamInfo.getComputerStartDate()))
														.replace("{examEnd}",
																dateFormat.format(trainExamInfo.getComputerEndDate()))
														.replace("{examAddress}",
																trainExamInfo.getTheoreticalAddress());
												newstitle = newstitle.replace("{name}", name)
														.replace("{examStart}",
																dateFormat.format(trainExamInfo.getComputerStartDate()))
														.replace("{examEnd}",
																dateFormat.format(trainExamInfo.getComputerEndDate()))
														.replace("{examAddress}",
																trainExamInfo.getTheoreticalAddress());
												this.sendMsg(personcertificate, newstitle, title, content);
											}
										} catch (Exception e) {
											// 消息发送失败不处理，因为使考试取消后考试人员状态要跟资格证人员考试安排状态一致
											logger.error("TrainExamInfoServiceImpl-importExamData内网考试安排导出外网后发送考试取消通知失败:"
													+ e.getMessage());
											continue;
										}
									}
								}
							}
						}
						// 批量新增、修改考试信息
						trainExamInfoDao.batchSaveAndUpdate(trainExamInfoList);
					}
				}
			}
			// 考试人员
			if (examData.get("TrainExamPerson") != null) {
				trainExamPersonJson = examData.get("TrainExamPerson").toString();
				trainExamPersonList = JSONObject.parseArray(trainExamPersonJson, TrainExamPerson.class);
				if (trainExamPersonList != null && trainExamPersonList.size() > 0) {
					List<TrainExamPerson> dbTrainExamPersonList = trainExamPersonDao
							.getExamPersonUpdate(trainExamPersonList);
					if (dbTrainExamPersonList != null && dbTrainExamPersonList.size() > 0) {
						// 待删除不能覆盖外网列表
						List<TrainExamPerson> removeTrainExamPersonList = new ArrayList<TrainExamPerson>();
						for (TrainExamPerson dbTrainExamPerson : dbTrainExamPersonList) {
							for (TrainExamPerson trainExamPerson : trainExamPersonList) {
								// 数据库更新时间大于内网导出外网时间，则不更新数据库
								if (trainExamPerson.getId().equals(dbTrainExamPerson.getId())) {
									if (dbTrainExamPerson.getUpdateTime().getTime() >= trainExamPerson.getUpdateTime()
											.getTime()) {
										removeTrainExamPersonList.add(trainExamPerson);
										break;
									}
								}
							}
						}
						// 删除不能覆盖外网数据
						if (removeTrainExamPersonList != null && removeTrainExamPersonList.size() > 0) {
							trainExamPersonList.removeAll(removeTrainExamPersonList);
						}
					}
					// 批量保存考试人员信息
					if (trainExamPersonList != null && trainExamPersonList.size() > 0) {
						trainExamPersonDao.batchSaveAndUpdate(trainExamPersonList);
					}
				}
			}
			// 批量推送给百课堂考试信息
			String resultMsg = "";
			String bktExamInfoBatchSave = trainUrl + Constants.TRAIN_INFO_BATCH_SAVE;
			Map<String, Object> paramMap = new HashMap<String, Object>();
			if (trainExamInfoList != null && trainExamInfoList.size() > 0) {
				// 考试信息列表 替换id成examID、createTime成creationdate
				trainExamInfoJson = JSONObject.toJSONString(trainExamInfoList).replaceAll("\"id\"", "\"examID\"")
						.replaceAll("\"createTime\"", "\"creationdate\"");
				paramMap.put("examInfos", trainExamInfoJson);
			}
			if (trainExamPersonList != null && trainExamPersonList.size() > 0) {
				// 考试人员列表 替换id成personID、createTime成creationdate
				trainExamPersonJson = JSONObject.toJSONString(trainExamPersonList).replaceAll("\"id\"", "\"personID\"")
						.replaceAll("\"createTime\"", "\"creationdate\"");
				paramMap.put("examPersons", trainExamPersonJson);
			}
			resultMsg = HttpUtil.post(bktExamInfoBatchSave, paramMap);
			logger.info(resultMsg);
		}
	}

	/**
	 * 导入考试信息数据
	 *
	 * @param searchDto
	 * @return
	 */
	@Override
	public List<TrainExamInfo> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return trainExamInfoDao.searchForDataSynchronization(searchDto);
	}

	/**
	 * 数据导入
	 *
	 * @param trainExamInfo
	 */
	@Override
	public void saveOrUpdateForDS(TrainExamInfo trainExamInfo) {

		if (trainExamInfo.getActive() == null) {
			trainExamInfo.setActive(true);
		}
		TrainExamInfo dbTrainExamInfo = trainExamInfoDao.selectByPrimaryKey(trainExamInfo.getId());
		if (dbTrainExamInfo != null) {
			if (trainExamInfo.getUpdateTime().getTime() > dbTrainExamInfo.getUpdateTime().getTime()) {
				trainExamInfoDao.updateForDS(trainExamInfo);

			}
		} else {
			trainExamInfoDao.saveForDS(trainExamInfo);
		}
	}

	/**
	 * 
	 * @param personcertificate
	 * @param title
	 *            标题
	 * @param msgContent
	 *            短信通知内容
	 * @param appContent
	 *            APP通知内容
	 */
	private void sendMsg(Personcertificate personcertificate, String title, String msgContent, String appContent) {
		if (StringUtils.isEmpty(title) || StringUtils.isEmpty(msgContent) || StringUtils.isEmpty(appContent)) {
			logger.error("TrainExamPersonServiceImpl类sendMsg方法：发送消息通知传递参数title或者msgContent或者appContent为空");
			return;
		}
		new Thread(() -> {
			try {
				if (personcertificate.getPersonid() == null) {
					// 自然人考试报名,手机号码不为空则发送短信
					if (StringUtils.isNotEmpty(personcertificate.getPhone())) {
						MessageUtil.sendMessage(personcertificate.getPhone(), msgContent, messageLogDao);
					}
				} else {
					// 判断是否有app
					boolean hasApp = false;
					// 推送ID
					String registrationID = "";
					SecurityPerson person = securityPersonDao.findById(personcertificate.getPersonid());
					// 判断考试人员是否在职
					if (personcertificate.getCompanyid() != null) {
						// 有APP登陆信息，则发送APP推送通知、APP站内消息
						if (hasApp) {
							AppNotice appNotice = new AppNotice();
							appNotice.setNoticeTitle(title);
							appNotice.setCreateTime(new Date());
							appNotice.setActive(true);
							appNotice.setNoticeContent("【考试通知】" + appContent.replaceAll("，", "\\\\n"));
							appNotice.setNoticeTypeID(2L);
							appNotice.setPersonId(person.getId());
							appNotice.setReadStatus("0");
							appNotice.setUpdateTime(new Date());
							appNoticeDao.save(appNotice);
							JPushUtil.sendMessage(title, "【考试通知】" + appContent, registrationID);
						} else {
							// 发送短信通知
							if (StringUtils.isNotEmpty(personcertificate.getPhone())) {
								MessageUtil.sendMessage(personcertificate.getPhone(), msgContent, messageLogDao);
							}
						}
					}
				}
			} catch (Exception e) {
				logger.error(e.getMessage(),e);
			}
		}).start();
	}

	@Override
	public void saveExamInfoFromTrain(String areaCode) {
		Config configURL = configDao.findByKey(Constants.TRAIN);
		try {
			if (configURL != null && configURL.getValue() != null) {
				String url = configURL.getValue() + Constants.TRAIN_EXAM_INFO;
				Map<String, String> data = new HashMap<String, String>();
				data.put("areaCode", areaCode);
				// 地址访问
				String btkResultJson = HttpClientUtils.doPost(url, data, "utf-8");
				Map resultMap = JSONObject.parseObject(btkResultJson, Map.class);
				if (resultMap != null && resultMap.size() > 0) {
					if (resultMap.get("data") != null) {
						Map examMap = JSONObject.parseObject(resultMap.get("data").toString(), Map.class);
						if (examMap.get("examInfo") != null) {
							List<TrainExamInfo> trainExamInfoList = JSONObject
									.parseArray(examMap.get("examInfo").toString(), TrainExamInfo.class);
							if (trainExamInfoList != null && trainExamInfoList.size() > 0) {
								// 判断导入更新时间是否大于数据库更新时间，如果大于则更新，小于则不更新
								List<TrainExamInfo> dbTrainExamInfoList = trainExamInfoDao
										.getExamInfoUpdate(trainExamInfoList);
								if (dbTrainExamInfoList != null && dbTrainExamInfoList.size() > 0) {
									// 待删除不能覆盖外网列表
									List<TrainExamInfo> removeTrainExamInfoList = new ArrayList<TrainExamInfo>();
									for (TrainExamInfo dbTrainExamInfo : dbTrainExamInfoList) {
										for (TrainExamInfo trainExamInfo : trainExamInfoList) {
											// 数据库更新时间大于内网导出外网时间，则不更新数据库
											if (trainExamInfo.getId().equals(dbTrainExamInfo.getId())) {
												// 数据库考试状态与导入考试状态不一致，并且导入状态是取消状态，则需要发送考试取消通知
												if (dbTrainExamInfo.getUpdateTime().getTime() >= trainExamInfo
														.getUpdateTime().getTime()) {
													removeTrainExamInfoList.add(trainExamInfo);
													break;
												}
											}
										}
									}
									// 删除不能覆盖外网数据
									if (removeTrainExamInfoList != null && removeTrainExamInfoList.size() > 0) {
										trainExamInfoList.removeAll(removeTrainExamInfoList);
									}
								}
								if (trainExamInfoList != null && trainExamInfoList.size() > 0) {
									trainExamInfoDao.batchSaveAndUpdate(trainExamInfoList);
								}
							}
						}
						if (examMap.get("examPerson") != null) {
							List<TrainExamPerson> trainExamPersonList = JSONObject
									.parseArray(examMap.get("examPerson").toString(), TrainExamPerson.class);
							if (trainExamPersonList != null && trainExamPersonList.size() > 0) {

								List<TrainExamPerson> dbTrainExamPersonList = trainExamPersonDao
										.getExamPersonUpdate(trainExamPersonList);
								if (dbTrainExamPersonList != null && dbTrainExamPersonList.size() > 0) {
									// 待删除不能覆盖外网列表
									List<TrainExamPerson> removeTrainExamPersonList = new ArrayList<TrainExamPerson>();
									for (TrainExamPerson dbTrainExamPerson : dbTrainExamPersonList) {
										for (TrainExamPerson trainExamPerson : trainExamPersonList) {
											// 数据库更新时间大于内网导出外网时间，则不更新数据库
											if (trainExamPerson.getId().equals(dbTrainExamPerson.getId())) {
												if (dbTrainExamPerson.getUpdateTime().getTime() >= trainExamPerson
														.getUpdateTime().getTime()) {
													removeTrainExamPersonList.add(trainExamPerson);
													break;
												}
											}
										}
									}
									// 删除不能覆盖外网数据
									if (removeTrainExamPersonList != null && removeTrainExamPersonList.size() > 0) {
										trainExamPersonList.removeAll(removeTrainExamPersonList);
									}
								}
								if (trainExamPersonList != null && trainExamPersonList.size() > 0) {
									// 批量保存考试人员信息
									trainExamPersonDao.batchSaveAndUpdate(trainExamPersonList);
								}
							}
						}
					}
				}
			}
		} catch (Exception e) {
			logger.error(e.getMessage(),e);
			e.printStackTrace();
		}
	}
}