package com.bcxin.ars.service.enums.impl;

import com.bcxin.ars.model.sys.ExportColumn;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import org.springframework.util.StringUtils;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;

/**
 * 获取字段值
 */
public class FileNameExportRoster implements ExportFormula {
    /**
     * 获取某个字段的值
     * @param exportRosterDtoList 数据Map集
     * @param exportColumn  字段来源，日期格式，码表类型
     * @param cellValue
     * @return
     */
    @Override
    public String getFormulaValue(List<Map<String,String>> exportRosterDtoList, ExportColumn exportColumn,String cellValue) {

        if(StringUtils.isEmpty(exportRosterDtoList.get(0).get(exportColumn.getColumnValueSource()))){
            return "";
        }
        //时间格式转换
        if(StringUtil.isNotEmpty(exportColumn.getFormatDate())){
            Object time = exportRosterDtoList.get(0).get(exportColumn.getColumnValueSource());
            SimpleDateFormat sdf = new SimpleDateFormat(exportColumn.getFormatDate());
            return sdf.format(DateUtil.convertStringToDate(time.toString()));
        }
        return exportRosterDtoList.get(0).get(exportColumn.getColumnValueSource());
    }
}
