package com.bcxin.ars.service.bean.factory;

import com.bcxin.ars.service.subsidy.ImportBusiness;
import com.bcxin.ars.service.util.SpringContextUtil;
import org.springframework.context.annotation.Configuration;
import java.util.HashMap;
import java.util.Map;

@Configuration
public class ImportBusinessBeanFactory {
    /***
     * 实现类
     */
    public  static Map<String,String> classNameMap = new HashMap<>();
    static {
        classNameMap.put("01","com.bcxin.ars.service.subsidy.impl.SignComparedImport");
        classNameMap.put("02","com.bcxin.ars.service.subsidy.impl.SubsibyComparedImport");
        classNameMap.put("03","com.bcxin.ars.service.subsidy.impl.SubsibyComparedImport");
    }
    /**
     * 根据比对类型获取实现类
     * @param businessType
     * @return
     */
    public static ImportBusiness getImportBusinessBean(String businessType){
        ImportBusiness result = null;
        //获背景筛查spring容器的ImportBusiness接口实现类列表
        Map<String, ImportBusiness> map =  SpringContextUtil.getBeansOfType(ImportBusiness.class);
        //循环判断是否和当前环境实现类
        for(Map.Entry<String, ImportBusiness> entry : map.entrySet()){
            result = entry.getValue();
            //匹配，找到各个环境的实在
            if(result.getClass().getName().equals(classNameMap.get(businessType))){
                break;
            }
        }
        return result;

    }
}
