package com.bcxin.ars.service.util;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.sys.SyscodeDAO;
import com.bcxin.ars.model.sys.Syscode;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.redis.RedisUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

import static com.bcxin.ars.service.util.SysAreaUtil.REDIS_PREFIX_KEY;


/**
 * 字典工具类
 *
 * @author zjh
 * @version 2018-06-4
 */
@Service(value="sysCodeUtil")
public class SysCodeUtils {
    private Logger log = LoggerFactory.getLogger(SysCodeUtils.class);

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private SyscodeDAO syscodeDAO;

    //	private static SyscodeDAO dictDao = SpringContextHolder.getBean(SyscodeDAO.class);


    /**
     *
     * @Decription:初始化全部字典到缓存
     * @author：zhongjianhui
     * @method  getDictList
     * @date：2018/6/5 16:29
     * @params： * @param type
     * @return java.util.List<com.bcxin.ars.model.sys.Syscode>
     */

    //初始化全部字典到缓存
    public void initDictList(){
        List<Syscode> codeList = new ArrayList<>();
        //找到数据库表中所有的值
        List<Syscode> rList = syscodeDAO.findAll();
        List<Syscode> list;
        //遍历list
        for (Syscode syscode : rList) {
            list = new ArrayList<>();
            //获取出类型
            String codeType = syscode.getCodetype();
            for (Syscode syscode2 : rList) {
                //将相同类型放入list
                if (codeType.equals(syscode2.getCodetype())) {
                    list.add(syscode2);
                }
            }
            //根据类型来进行缓存
            redisUtil.set(REDIS_PREFIX_KEY + "systemCode_" + codeType, JSON.toJSONString(list));
            log.debug("设置进入redis缓存[{}]", "systemCode_" + codeType);
        }
    }

    public String getSysCode(String type) {
        String value = "";
        List<Syscode> codeList = new ArrayList<>();
        value = getSysCodeValue(type, value);

        if (StringUtil.isEmpty(value)) {
            this.initDictList();
            value = getSysCodeValue(type, value);
        }
        if (StringUtil.isEmpty(value)) {
           return "找不到该类型的字典数据";
        }
        return value;
        }

    private String getSysCodeValue(String type, String value) {
        try {
            //从缓存中获取相应类型的值
            value = redisUtil.get(REDIS_PREFIX_KEY + "systemCode_" + StringUtil.upperCase(type));
        } catch (RuntimeException ex) {
            log.error("redis缓存获取异常[{}]", "systemCode");
        }
        return value;
    }


}
