package com.bcxin.ars.service.util;

import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.ImgUtils;
import com.bcxin.ars.util.StringUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.File;
import java.util.Date;
import java.util.Random;

/**
 * @author linqinglin
 * @date 2020/12/09 0009 15:06
 */
@Component
public class PhotoUtil {

    @Value("${base-folder}")
    private String baseFolder;

    @Value("${personImg-folder}")
    private String personImgPath = "";

    public void savePhoto(PersonBaseInfo personBaseInfo){
        personBaseInfo.setState(Constants.PHOTO_NO);
        if(StringUtil.isNotEmpty(personBaseInfo.getPhoto())){
            Date now = new Date();
            Random random = new Random();
            int rannum = (int) (random.nextDouble() * (99 - 10 + 1)) + 100;// 获取5位随机数
            String fileName = now.getTime()+rannum +".jpg";
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(baseFolder + personImgPath + dirDate);
            if(!dir.exists()) {
                dir.mkdirs();
            }
            String key = personImgPath + dirDate + "/" + fileName;
            String url = "getResource.do?path=" + key;
            String targetPath = baseFolder + key;

            if(ImgUtils.generateImage(personBaseInfo.getPhoto(),targetPath)) {
                personBaseInfo.setImgPath(url);
                personBaseInfo.setState(Constants.PHOTO_YES);
            }
            personBaseInfo.setPhoto(null);
        }
    }

    public void saveRandomPhoto(PersonBaseInfo personBaseInfo){
        personBaseInfo.setState(Constants.PHOTO_NO);
        if(StringUtil.isNotEmpty(personBaseInfo.getPhoto())){
            Date now = new Date();
            Random random = new Random();
            int rannum = (int) (random.nextDouble() * (99 - 10 + 1)) + 100;// 获取5位随机数
            String fileName = now.getTime()+rannum +".jpg";
            String dirDate = DateUtil.systemDate.format(DateUtil.randomDate("2020-07-01",DateUtil.getCurrentDate()));
            File dir = new File(baseFolder + personImgPath + dirDate);
            if(!dir.exists()) {
                dir.mkdirs();
            }
            String key = personImgPath + dirDate + "/" + fileName;
            String url = "getResource.do?path=" + key;
            String targetPath = baseFolder + key;

            if(ImgUtils.generateImage(personBaseInfo.getPhoto(),targetPath)) {
                personBaseInfo.setImgPath(url);
                personBaseInfo.setState(Constants.PHOTO_YES);
            }
            personBaseInfo.setPhoto(null);
        }
    }
}
