package com.bcxin.ars.service.util;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sys.InterfaceLogDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SAASResultDto;
import com.bcxin.ars.dto.datasync.DataSyncDto;
import com.bcxin.ars.model.datasync.DataSyncLog;
import com.bcxin.ars.model.sys.InterfaceLog;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.xiaoleilu.hutool.http.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.Map;

/**
 * 调saas接口工具类
 * @author linqinglin
 * @date 2019/04/23 0023 15:14
 */
@Component
public class DataSyncInterfaceUtil {

    private static Logger logger = LoggerFactory.getLogger(DataSyncInterfaceUtil.class);

    @Autowired
    private InterfaceLogDao interfaceLogDao;

    @Autowired
    private DataSyncContantsUtil dataSyncContantsUtil;

    @Autowired
    private ConfigUtils configUtils;



    /**
     * 调saas接口
     * @param url 接口地址
     * @param dataSyncLog 传参
     */
    public AjaxResult callInterface(String url , DataSyncLog dataSyncLog){

        DataSyncDto dataSyncDto = new DataSyncDto();
        dataSyncDto.setRegionId(configUtils.getCurrentProvince());
        dataSyncDto.setBusinessId(dataSyncLog.getId()+"");
        dataSyncDto.setData(JSON.toJSONString(dataSyncLog));
        dataSyncDto.setTargetServiceUrl(Constants.DATASYNC_RECEIVE_URL);
        dataSyncDto.setCallbackUrl(dataSyncContantsUtil.getTimeUrl()+Constants.DATASYNC_CALLBACK_URL);
        dataSyncDto.setSrcApp(dataSyncContantsUtil.getTimeUrl());
        dataSyncDto.setTargetApp(dataSyncContantsUtil.getTargetTimeUrl());
        dataSyncDto.setFileUrls(dataSyncContantsUtil.getTimeUrl()+dataSyncLog.getUrl());


        Map<String,Object> paramMap = BeanUtil.beanToMap(dataSyncDto);

        String msg = StringUtil.EMPTY;
        Boolean result = true;
        Object data = null;
        //获取SaaS对接地址

        url = dataSyncContantsUtil.getDataSyncFtpUrl() + url;

        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));

        try {
            //获取结果
            String resultStr = HttpUtil.post(url, paramMap,30000);
            interfaceLog.setResult(resultStr);

            SAASResultDto resultDto = JSONObject.parseObject(resultStr, SAASResultDto.class);
            if(resultDto != null && StringUtil.isNotEmpty(resultDto.getRetType())) {
                String retType = resultDto.getRetType();
                if (Constants.BTK_IS_SUCCESS.equals(retType)) {
                    data = resultDto.getData();
                    logger.info("百保盾调用FTP同步服务成功");
                } else {
                    result = false;
                    //错误信息
                    msg =  resultDto.getMsg();
                    logger.error(resultStr);
                    logger.info("百保盾调用FTP同步服务失败");
                }
            }else{
                result = false;
                msg =  "没有返回结果";
                logger.info("百保盾调用FTP同步服务失败,没有返回结果");
            }
        }catch (Exception e){
            result = false;
            logger.error(e.getMessage(),e);
            msg = e.getMessage();
            interfaceLog.setResult(e.getMessage());
        }
        interfaceLog.setUpdateTime(new Date());
        interfaceLog.setSuccessful(result);
        /**
         * 异步保存
         */
        new Thread(()->{
            interfaceLogDao.insert(interfaceLog);
        }).start();

        if(StringUtil.isNotEmpty(msg)){
            msg = "百保盾调用FTP同步服务失败:" + msg;
        }
        return new AjaxResult(result,msg,data);
    }


    public static void main(String[] args) {

    }
}
