package com.bcxin.ars.service.task.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.task.ComShiftRuleDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.task.ComShiftRulePageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.ComShiftRule;
import com.bcxin.ars.service.task.ComShiftRuleService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.Date;
import java.util.List;
/**
 * 企业班次规则Service实现类
 *
 * @author linqinglin
 * @Date 2020-03-26 09:39:07
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = ComShiftRule.class,getMethodName = "importBatch",getImportType = ImportType.BATCH)
public class ComShiftRuleServiceImpl implements ComShiftRuleService {

    Logger logger = LoggerFactory.getLogger(ComShiftRuleServiceImpl.class);

    @Autowired
    private ComShiftRuleDao comShiftRuleDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;
   
    @Override
    public int delete(ComShiftRule comShiftRule) {
        User currentUser = arsUtil.getCurrentUser();
        comShiftRule.setUpdateTime(new Date());
        comShiftRule.setUpdateBy(currentUser.getUsername());
        return comShiftRuleDao.delete(comShiftRule);
    }

    @Override
    public int save(ComShiftRule comShiftRule) {
        ComShiftRule dbComShiftRule = comShiftRuleDao.findById(comShiftRule.getShiftRuleId());
        User currentUser = arsUtil.getCurrentUser();
        if(dbComShiftRule == null){
            comShiftRule.setCreateTime(new Date());
        }else{
            BeanUtils.copyPropertiesIgnore(comShiftRule,dbComShiftRule,true);
            BeanUtils.copyPropertiesIgnore(dbComShiftRule,comShiftRule,false);
        }

        comShiftRule.setUpdateBy(currentUser.getUsername());
        comShiftRule.setUpdateTime(new Date());
        return comShiftRuleDao.save(comShiftRule);
    }

    @Override
    public ComShiftRule findById(Long id) {
        return comShiftRuleDao.findById(id);
    }

    @Override
    public void searchForPage(ComShiftRulePageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
       comShiftRuleDao.searchForPage(dto,page);
    }

    /**
     * 外网同步到内网
     * @param list
     */
    @Override
    public void importBatch(List<ComShiftRule> list) {
        List<ComShiftRule> dbList = comShiftRuleDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (ComShiftRule comShiftRule : list) {
                try {
                    if(!configUtils.isIntranet()){
                       comShiftRule.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, comShiftRule.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            comShiftRuleDao.saveBatch(list);
        }
    }

    /**
     * 外网同步到内网查询
     * @param dto
     * @return
     */
    @Override
    public List<ComShiftRule> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return comShiftRuleDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<ComShiftRule> findDSOutList(String startDate) {
        return comShiftRuleDao.findDSOutList(startDate);
    }

    @Override
    public List<ComShiftRule> findByBatchId(List<ComShiftRule> list) {
        return comShiftRuleDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(ComShiftRule comShiftRule) {
        User currentUser = arsUtil.getCurrentUser();
        comShiftRule.setUpdateTime(new Date());
        comShiftRule.setUpdateBy(currentUser.getUsername());
        comShiftRuleDao.updateSelective(comShiftRule);
    }
}
