/*
 * Copyright (c) 2015 xuerdongcom@126.com All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 */
package com.bcxin.ars.service.sys.impl;

import com.bcxin.ars.dao.sys.FileTempDao;
import com.bcxin.ars.model.sys.FileTemp;
import com.bcxin.ars.service.sys.FileTempService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * excel、word文件模板管理service
 * by llc 2018-09-10
 */
@Service
@Transactional
public class FileTempServiceImpl implements FileTempService {

	@Autowired
	private FileTempDao fileTempDao;

	/**
	 * 查询文件模板
	 * by llc 2018-08-09
	 */

	@Override
	public FileTemp getFileTempByName(String fileTempName){
		FileTemp fileTemp = fileTempDao.getFileTempByName(fileTempName) ;
		return fileTemp;
	}

}