package com.bcxin.ars.service.subsidy.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.subsidy.GradeSubsidyRosterDao;
import com.bcxin.ars.dao.subsidy.GradeSubsidyRosterDaoAop;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.subsidy.GradeSubsidyRosterDto;
import com.bcxin.ars.dto.subsidy.GradeSubsidyRosterSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.subsidy.GradeSubsidyRoster;
import com.bcxin.ars.service.subsidy.GradeSubsidyRosterService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.BKTInterfaceUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.JwtUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author  yyx
 * @date 2020-05-14
 * @desc 花名册
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = GradeSubsidyRoster.class,getImportType = ImportType.BATCH,getMethodName = "importBatch")
@DataSyncOutAnnotation(getClazz = GradeSubsidyRoster.class,getImportType = ImportType.BATCH)
public class GradeSubsidyRosterServiceImpl implements GradeSubsidyRosterService {

    Logger logger = LoggerFactory.getLogger(GradeSubsidyRosterServiceImpl.class);

    @Autowired
    private GradeSubsidyRosterDao gradeSubsidyRosterDao;

    @Autowired
    private GradeSubsidyRosterDaoAop gradeSubsidyRosterDaoAop;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private BKTInterfaceUtil bktInterfaceUtil;

    @Override
    public GradeSubsidyRoster findById(Long id) {
        return gradeSubsidyRosterDao.findById(id);
    }

    @Override
    public void search(GradeSubsidyRosterSearchDto searchDto, AjaxPageResponse<GradeSubsidyRoster> page) {
        gradeSubsidyRosterDao.search(searchDto,page);
    }

    @Override
    public void searchForApply(GradeSubsidyRosterSearchDto searchDto, AjaxPageResponse<GradeSubsidyRosterDto> page) {
        gradeSubsidyRosterDao.searchForApply(searchDto,page);
    }

    @Override
    public void save(GradeSubsidyRoster gradeSubsidyRoster) {
        User currentUser = arsUtil.getCurrentUser();
        if(gradeSubsidyRoster.getId() == null){
            gradeSubsidyRoster.setCreateTime(new Date());
        }
        gradeSubsidyRoster.setActive(true);
        gradeSubsidyRoster.setUpdateBy(currentUser.getUsername());
        gradeSubsidyRoster.setUpdateTime(new Date());
        gradeSubsidyRosterDaoAop.save(gradeSubsidyRoster);
    }


    @Override
    public void importBatch(List<GradeSubsidyRoster> list) {
        List<GradeSubsidyRoster> dbList = gradeSubsidyRosterDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (GradeSubsidyRoster gradeSubsidyRoster : list) {
                gradeSubsidyRoster.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        gradeSubsidyRoster.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, gradeSubsidyRoster.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            //if(!configUtils.isIntranet()){
            //    this.compareStatusToBKT(list);
            //}
            gradeSubsidyRosterDaoAop.saveBatch(list);
        }
    }

    @Override
    public List<GradeSubsidyRoster> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return gradeSubsidyRosterDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<GradeSubsidyRoster> findDSOutList(String startDate) {
        return gradeSubsidyRosterDao.findDSOutList(startDate);
    }

    @Override
    public List<GradeSubsidyRoster> findByBatchId(List<GradeSubsidyRoster> list) {
        return gradeSubsidyRosterDao.findByBatchId(list);
    }

    @Override
    public void compareStatusToBKT(List<GradeSubsidyRoster> rosterList) {
        //train/bbd/grade/person/first/compareStatus
        //参数：personList:[{"gradeApplyId":"123123",{"compareStatus":"01"},{"compareFailReason":"错误原因"},{"compareType":"1"}]
        //备注：compareType：1. 第一次比对，报名比对，2. 第二次比对，补贴比对
        JSONArray personList = new JSONArray();
        JSONObject perObj = null;
        for (GradeSubsidyRoster roster : rosterList) {
            if(Constants.SUBSIDYCERTYPE_DJZ.equals(roster.getSubsidyCerType())) {
                perObj = new JSONObject();
                perObj.put("gradeApplyId", roster.getGradeId() + "");
                perObj.put("compareStatus", roster.getSubsidyStatus());
                perObj.put("compareFailReason", roster.getReason());
                perObj.put("compareType", "2");
                personList.add(perObj);
            }
        }
        if(personList.size() >0) {
            Map<String, Object> paramMap = new HashMap();
            paramMap.put("personList", JSONArray.toJSONString(personList));

            AjaxResult result = bktInterfaceUtil.callInterface(Constants.BKT_GRADEPERSON_COMPARESTATUS, paramMap);

            if (!result.isSuccessful()) {
                //throw new ArsException("【等级证报名补贴比对结果】"+result.getMsg());
                logger.error("【等级证报名补贴比对结果】" + result.getMsg());
            }
        }
    }

    @Override
    public Map statistics(GradeSubsidyRosterSearchDto searchDto) {
        return gradeSubsidyRosterDao.statistics(searchDto);
    }


    @Override
    public AjaxResult listPersonnelSubsidyApplicationStatus(String gradeSubsidyRoster) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT(gradeSubsidyRoster).getSubject();
        List<GradeSubsidyRoster> gradeSubsidyRosters = JSON.parseArray(subject, GradeSubsidyRoster.class);
        if (CollectionUtil.isEmpty(gradeSubsidyRosters)) {
            ajaxResult.setMsg("失败, 查询信息不能为空");
            ajaxResult.setSuccessful(false);
            return ajaxResult;
        }
        List<GradeSubsidyRoster> returnList = Lists.newArrayList();
        // 直接根据上传的参数查询, subsidyCerType 01等级证补贴/02资格证补贴
        for (GradeSubsidyRoster subsidyRoster : gradeSubsidyRosters) {
            GradeSubsidyRoster rosterData = gradeSubsidyRosterDao.findSubsidyStatusAndSubsidyMoney(subsidyRoster);
            GradeSubsidyRoster returnData = new GradeSubsidyRoster();
            if (rosterData != null) {
                returnData.setSubsidyStatus(StringUtil.isEmpty(rosterData.getSubsidyStatus()) ? StringUtil.EMPTY : rosterData.getSubsidyStatus());
                returnData.setSubsidyMoney(StringUtil.isEmpty(rosterData.getSubsidyMoney()) ? StringUtil.EMPTY : rosterData.getSubsidyMoney());
            }
            returnData.setCensorStatusError(null);
            returnData.setIdNum(subsidyRoster.getIdNum());
            returnList.add(returnData);
        }

        ajaxResult.setData(JwtUtil.createJWT(JSON.toJSONString(returnList)));
        ajaxResult.setMsg("成功");
        ajaxResult.setSuccessful(true);
        return ajaxResult;
    }
}
