package com.bcxin.ars.service.sb.impl;

import com.bcxin.ars.dao.sb.OrderDetailDao;
import com.bcxin.ars.dto.OrderDetailDTO;
import com.bcxin.ars.model.sb.OrderDetail;
import com.bcxin.ars.service.sb.OrderDetailService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by 苏 on 2017/5/19.
 */
@Service
@Transactional
public class OrderDetailServiceImpl implements OrderDetailService {



    private static Logger logger = LoggerFactory.getLogger(ManagementInfoServiceImpl.class);


    @Autowired
    private OrderDetailDao orderDetailDao;





    @Override
    public OrderDetail fingById(Long id) {
       return orderDetailDao.findById(id);
    }

    @Override
    public void insert(OrderDetail orderDetail) {
        orderDetailDao.insert(orderDetail);
    }

    @Override
    public void update(OrderDetail orderDetail) {
        orderDetailDao.update(orderDetail);
    }

    @Override
    public List<OrderDetail> selectOrderDetailByInfoId(Long orderInfoId) {
        return orderDetailDao.selectOrderDetailByInfoId(orderInfoId);
    }

    @Override
    public void insertBatchCetificate(List<OrderDetailDTO> orderDetailList) {
        orderDetailDao.bktUpdatefeeStateByBatchID(orderDetailList);
    }

}
