package com.bcxin.ars.service.sb.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.jiguang.common.utils.StringUtils;
import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.ars.dao.ExportDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.sys.ExportConfigColumnDao;
import com.bcxin.ars.dao.sys.ExportConfigDao;
import com.bcxin.ars.dto.ExportModelDTO;
import com.bcxin.ars.dto.ExportTableListDTO;
import com.bcxin.ars.dto.ModelNameDTO;
import com.bcxin.ars.dto.PropertiesDTO;
import com.bcxin.ars.dto.sys.ExportRosterDto;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.ExportColumn;
import com.bcxin.ars.model.sys.ExportConfig;
import com.bcxin.ars.service.bean.factory.ExportBusinessBeanFactory;
import com.bcxin.ars.service.enums.ExportExcelType;
import com.bcxin.ars.service.sb.ExportService;
import com.bcxin.ars.service.subsidy.ExportBusiness;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.FileUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.ftp.FtpUtils;
import com.bcxin.ars.util.poi.ExcelUtil;
import com.beust.jcommander.internal.Lists;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.*;

@Service
@Transactional
public class ExportServiceImpl implements ExportService {
    /***
     * 日志
     */
    private static final Logger logger = LoggerFactory.getLogger(ConfesscompanyundoServiceImpl.class);
    @Value("${company-download-folder}")
    private String downloadFolder;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ExportConfigDao exportConfigDao;
    @Autowired
    private ExportDao exportDao;
    @Autowired
    private ExportConfigColumnDao exportConfigColumnDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;

    @Override
    public String exportForExcel(PropertiesDTO propertiesDTO, String josnStr, Map<Object, Object> searchParams, User user, String tableExcelName) {
        Object object;
        String tableAnotherName;
        String tableName;
        String excelName;
        List<ExportTableListDTO> tableList;
        String tableListName = "";
        String tableListColumn = "";
        //是否有district字段
        boolean districtFlag = false;
        String search = "";
        StringBuffer where = new StringBuffer("");
        List<Map> mapList = new ArrayList<>();
        try {
            tableName = propertiesDTO.getTableName();
            excelName = propertiesDTO.getExcelName();
            tableList = propertiesDTO.getTableList();
            /**
             * 主表查询的别名
             * */
            tableAnotherName = "t1";
            Class aClass = Class.forName(propertiesDTO.getModelPath());
            ExportModelDTO exportModelDTO = this.getColumn(aClass.newInstance(), josnStr, tableAnotherName);
            //获取是否要进行区域过滤
            Object o = aClass.getAnnotation(ModelTableAnnotation.class);
            //过滤字段
            String areaCodeFilterColumn = "areacode";
            String areaCodeFilter = "1";
            boolean extra = true;
            if (o instanceof ModelTableAnnotation) {
                ModelTableAnnotation tableAnnotation = (ModelTableAnnotation) o;
                areaCodeFilterColumn = tableAnnotation.areaCodeFilterColumn();
                areaCodeFilter = tableAnnotation.areaCodeFilter();
                extra = tableAnnotation.extra();
            }

            searchParams.put("extra", extra);
            if (exportModelDTO != null) {
                String column = exportModelDTO.getColumns();
                String table = tableName + " AS " + tableAnotherName;
                /**
                 * 加入配置的其他表
                 * */
                if (tableList != null && tableList.size() > 0) {
                    for (ExportTableListDTO exportTableListDTO : tableList) {
                        /**
                         * 判断加入表的方式LEFT 2或者INNER 3
                         * */
                        if (exportTableListDTO.getJoinType() != null && Constants.JOIN_TYPE_LEFT.equals(exportTableListDTO.getJoinType())) {
                            tableListName += " LEFT JOIN " + exportTableListDTO.getTableName() + " AS " + exportTableListDTO.getAnotherName() + " ON " + exportTableListDTO.getSearch();
                        } else if (exportTableListDTO.getJoinType() != null && Constants.JOIN_TYPE_INNER.equals(exportTableListDTO.getJoinType())) {
                            tableListName += " INNER JOIN " + exportTableListDTO.getTableName() + " AS " + exportTableListDTO.getAnotherName() + " ON " + exportTableListDTO.getSearch();
                        } else {

                            tableListName += "," + exportTableListDTO.getTableName() + " AS " + exportTableListDTO.getAnotherName();

                            search += exportTableListDTO.getSearch();
                        }
                        tableListColumn += "," + exportTableListDTO.getTableColumn();
                    }
                }
                if (tableListColumn != "") {
                    column += tableListColumn;
                    table += tableListName;
                }
                //这张表背景筛查不用转换
                if ("Grade_Certificate".equals(tableName) || "grade_person".equals(tableName) || "CertificatePrintLog".equals(tableName) || "sb_grade_practice".equals(tableName)) {
                    searchParams.put("needcensorStatus", "1");
                }

                try {
                    Field field = aClass.getDeclaredField("district");
                    if (field != null) {
                        districtFlag = true;
                    }
                } catch (NoSuchFieldException e) {
                    //logger.error(e.getMessage(),e);
                }

                if (Constants.AREACODEFILTER_YES.equals(areaCodeFilter)) {
                    String areaCode = StringUtil.EMPTY;
                    if (searchParams.get(areaCodeFilterColumn) != null) {
                        areaCode = searchParams.get(areaCodeFilterColumn).toString();
                    }
                    Police police = user.getPolice();
                    if (police != null) {
                        if (StringUtil.isEmpty(areaCode)) {
                            if (searchParams.get("rankAuth") != null && "1".equals(searchParams.get("rankAuth").toString())) {
                                areaCode = configUtils.getCurrentNative();
                                if (Constants.POLICE_ORGTYPE_PCS.equals(police.getOrgtype())) {
                                    searchParams.put("orgID", police.getId());
                                }
                            } else {
                                areaCode = police.getAreacode();
                            }
                            //北京地区不进行区域过滤
//                            if(Constants.BEIJING.equals(configUtils.getCurrentNative())){
//                                areaCode = configUtils.getCurrentNative();
//                            }else{
//                                areaCode = police.getAreacode();
//                            }
                        }
                    } else {
                        boolean hasTrainOrgId = false;
                        //培训机构
                        if (user.getPlatform() == Constants.PLATFORM_COMPANY && !"CertificatePrintLog".equals(tableName)) {
                            try {
                                Field field = aClass.getDeclaredField("trainOrgID");
                                if (field != null) {
                                    hasTrainOrgId = true;
                                    //根据用户ID获取公司信息
                                    SecurityCompany company = securityCompanyDao.findByUserid(user.getId());
                                    //设置培训机构ID，查询
                                    where.append(" and ")
                                            .append(" trainOrgID = ")
                                            .append(company.getComId())
                                            .append(" ");
                                }
                            } catch (NoSuchFieldException e) {
                                //logger.error(e.getMessage(),e);
                            }
                        }
                        if (!hasTrainOrgId && !"Grade_Certificate".equals(tableName) && !"grade_person".equals(tableName) && !"CertificatePrintLog".equals(tableName) && !"sb_grade_practice".equals(tableName)) {
                            searchParams.put("user_id", user.getId());
                        } else {
                            searchParams.put("needcensorStatus", "1");
                        }
                    }
                    if (StringUtil.isNotEmpty(areaCode)) {
                        if (areaCode.endsWith("0000")) {//省
                            if (districtFlag) {
                                searchParams.put("district", areaCode.substring(0, 2) + "____");
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode.substring(0, 2) + "____");
                        } else if (areaCode.endsWith("00")) {//市
                            if (districtFlag) {
                                searchParams.put("district", areaCode.substring(0, 4) + "__");
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode.substring(0, 4) + "__");
                        } else {//区
                            if (districtFlag) {
                                searchParams.put("district", areaCode);
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode);
                        }
                    }
                }

                //获取实体字段与表字段的关联关系
                Map<String, String> columnMap = this.getColumn(aClass.newInstance());
                //拼接查询条件
                for (Object key : searchParams.keySet()) {
                    //值不为空
                    if (searchParams.get(key) != null && StringUtil.isNotEmpty(searchParams.get(key).toString())) {
                        if (columnMap.get(key) != null) {
                            Field field = null;
                            try {
                                //判断字段是否存在
                                field = aClass.getDeclaredField(key.toString());
                            } catch (NoSuchFieldException e) {
                                logger.error(e.getMessage(), e);
                            }

                            if (field != null) {
                                if(field.getName().equals("testState")){
                                    continue;
                                }
                                ModelAnnotation resource = field.getAnnotation(ModelAnnotation.class);
                                if (resource != null) {
                                    SignType signType = resource.sign();
                                    switch (signType) {
                                        case EQUAL_NULL_EMPTY:
                                        case EQUAL_NULL_ZERO:
                                            where.append(" and ifnull(")
                                                    .append(columnMap.get(key))
                                                    .append(",'")
                                                    .append(signType.getDefaultValue())
                                                    .append("') ")
                                                    .append(signType.getOperator())
                                                    .append(" '")
                                                    .append(searchParams.get(key))
                                                    .append("' ");
                                            break;
                                        case NOTEMPTY://不为空
                                            where.append(" and ifnull(")
                                                    .append(columnMap.get(key))
                                                    .append(",'")
                                                    .append(signType.getDefaultValue())
                                                    .append("') ")
                                                    .append(signType.getOperator())
                                                    .append(" ''");
                                            break;
                                        case IN://包含
                                            if (Constants.BKT_ORGTYPE_GS.equals(searchParams.get(key))) {
                                                where.append(" and ")
                                                        .append(columnMap.get(key))
                                                        .append(" in ('0102','0105')");

                                            } else {
                                                where.append(" and ")
                                                        .append(columnMap.get(key))
                                                        .append(signType.getOperator())
                                                        .append("('")
                                                        .append(searchParams.get(key))
                                                        .append("') ");
                                            }
                                            break;
                                        case NOTEQUAL://不等于
                                            where.append(" and ifnull(")
                                                    .append(columnMap.get(key))
                                                    .append(",'")
                                                    .append(signType.getDefaultValue())
                                                    .append("') ")
                                                    .append(signType.getOperator())
                                                    .append(" '")
                                                    .append(searchParams.get(key))
                                                    .append("' ");
                                            break;
                                        case LIKE:
                                            where.append(" and ")
                                                    .append(columnMap.get(key))
                                                    .append(" ")
                                                    .append(signType.getOperator())
                                                    .append(" '%")
                                                    .append(searchParams.get(key))
                                                    .append("%'");
                                            break;
                                        case OUTDAY:
                                            where.append(" and  datediff(now(),")
                                                    .append(columnMap.get(key))
                                                    .append(") ")
                                                    .append(signType.getOperator())
                                                    .append(" '")
                                                    .append(searchParams.get(key))
                                                    .append("'");
                                            break;
                                        case IDCARDSEX:
                                            where.append(" and  IF(mod(SUBSTR(")
                                                    .append(columnMap.get(key))
                                                    .append(",17,1),2),'1','2') ")
                                                    .append(signType.getOperator())
                                                    .append(" '")
                                                    .append(searchParams.get(key))
                                                    .append("'");
                                            break;
                                        case IDCARDNATIVE:
                                            String nativePlace = (String) searchParams.get(key);
                                            if (nativePlace.endsWith("0000")) {
                                                nativePlace = nativePlace.substring(0, 2) + "________________";
                                            } else if (nativePlace.endsWith("00")) {
                                                //市、设置机构类型 市级2
                                                nativePlace = nativePlace.substring(0, 4) + "______________";
                                            }
                                            where.append(" and  ")
                                                    .append(columnMap.get(key))
                                                    .append(signType.getOperator())
                                                    .append(" '")
                                                    .append(nativePlace)
                                                    .append("'");
                                            break;
                                        case FEE_STATE:
                                            where.append(" and if(ifnull(fee_state,'0')='','0',ifnull(fee_state,'0'))=")
                                                    .append(searchParams.get(key));

                                            break;
                                        case DATE_EQUAL:
                                        case DATE_GREATER_EQUAL:
                                        case DATE_LESS_EQUAL:
                                            //日期需要格式化处理
                                            where.append(" and  date_format(")
                                                    .append(columnMap.get(key))
                                                    .append(",'%Y-%m-%d') ")
                                                    .append(signType.getOperator())
                                                    .append(" '")
                                                    .append(searchParams.get(key))
                                                    .append("'");
                                            break;
                                        case OTHERIF:
                                            if (searchParams.get(key).equals(1)) {
                                                where.append(" and ")
                                                        .append(columnMap.get(key))
                                                        .append(" ")
                                                        .append(signType.getOperator())
                                                        .append(" true");
                                            } else if (searchParams.get(key).equals(0)) {
                                                where.append(" and ")
                                                        .append(columnMap.get(key))
                                                        .append(" ")
                                                        .append(signType.getOperator())
                                                        .append(" false");
                                            } else {
                                                where.append(" and ")
                                                        .append(columnMap.get(key))
                                                        .append(" ")
                                                        .append(signType.getOperator())
                                                        .append(" '")
                                                        .append(searchParams.get(key))
                                                        .append("'");
                                            }
                                            break;
                                        case EQUAL:
                                        case GREATER_EQUAL:
                                        case LESS_EQUAL:
                                        default:
                                            where.append(" and ")
                                                    .append(columnMap.get(key))
                                                    .append(signType.getOperator())
                                                    .append("'")
                                                    .append(searchParams.get(key))
                                                    .append("' ");
                                            break;
                                    }
                                }
                            }
                        }
                    }
                }

//                //加个创建时间
//                column +=",create_time";
                searchParams.put("tableColumn", column);
                searchParams.put("tableName", table);
                searchParams.put("search", search);

                searchParams.put("where", where.toString());

                if (searchParams.get("local") != null) {
                    String local = searchParams.get("local").toString();
                    if (Constants.LOCAL_NO.equals(local)) {
                        searchParams.remove("areacode");
                    }

                }
                mapList = exportDao.findExportMessager(searchParams);
            }
            //导出
//            if (mapList.size() > 65535) {
//                throw new ArsException("导出记录量" + mapList.size() + "，超过excel最大行数，请过滤查询条件再导出！！");
//            }
            /**
             * 获取到导出数据之后导出到excel
             * */
            if (mapList != null && mapList.size() > 0) {
                Date now = new Date();
                String dirDate = DateUtil.systemDate.format(now);
                File dir = new File(downloadFolder + dirDate);
                if (!dir.exists()) {
                    dir.mkdirs();
                }

                String templateName = downloadFolder + dirDate + "/" + (now.getTime() + "_" + tableExcelName + ".xlsx");
                File file = new File(templateName);
                this.exportCompanys(mapList, file, excelName, exportModelDTO);
                return templateName;
            }
        } catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), e);
        } catch (IllegalAccessException e) {
            logger.error(e.getMessage(), e);
        } catch (InstantiationException e) {
            logger.error(e.getMessage(), e);
        }
        return null;
    }


    @Override
    public String commonExportExcel(PropertiesDTO propertiesDTO, String josnStr, Map<Object, Object> searchParams, User user, String tableExcelName) {
        String tableAnotherName;
        String tableName;
        String excelName;
        List<ExportTableListDTO> tableList;
        String tableListName = "";
        String tableListColumn = "";
        String search = "";
        StringBuffer where = new StringBuffer("");
        List<Map> mapList = new ArrayList<>();

        //是否有district字段
        boolean districtFlag = false;
        try {
            //表名
            tableName = propertiesDTO.getTableName();
            //excel表格名称
            excelName = propertiesDTO.getExcelName();
            /**
             * 其他关联表
             */
            tableList = propertiesDTO.getTableList();
            /**
             * 主表查询的别名
             * */
            tableAnotherName = "t1";
            Class aClass = Class.forName(propertiesDTO.getModelPath());

            //获取是否要进行区域过滤
            Object o = aClass.getAnnotation(ModelTableAnnotation.class);
            //过滤字段
            String areaCodeFilterColumn = "areacode";
            String areaCodeFilter = "1";
            boolean extra = true;
            if (o instanceof ModelTableAnnotation) {
                ModelTableAnnotation tableAnnotation = (ModelTableAnnotation) o;
                areaCodeFilterColumn = tableAnnotation.areaCodeFilterColumn();
                areaCodeFilter = tableAnnotation.areaCodeFilter();
                extra = tableAnnotation.extra();
            }

            searchParams.put("extra", extra);

            ExportModelDTO exportModelDTO = this.getColumn(aClass.newInstance(), josnStr, tableAnotherName);
            if (exportModelDTO != null) {

                try {
                    Field field = aClass.getDeclaredField("district");
                    if (field != null) {
                        districtFlag = true;
                    }
                } catch (NoSuchFieldException e) {
                    //logger.error(e.getMessage(),e);
                }

                if (Constants.AREACODEFILTER_YES.equals(areaCodeFilter)) {
                    String areaCode = StringUtil.EMPTY;
                    if (searchParams.get(areaCodeFilterColumn) != null) {
                        areaCode = searchParams.get(areaCodeFilterColumn).toString();
                    }
                    Police police = user.getPolice();
                    if (police != null) {
                        if (StringUtil.isEmpty(areaCode)) {
                            //北京地区不进行区域过滤
//                            if(Constants.BEIJING.equals(configUtils.getCurrentNative())){
//                                areaCode = configUtils.getCurrentNative();
//                            }else{
                            areaCode = police.getAreacode();
//                            }
                        }
                    } else {
                        boolean hasTrainOrgId = false;
                        //培训机构
                        if (user.getPlatform() == Constants.PLATFORM_COMPANY && !"CertificatePrintLog".equals(tableName)) {
                            try {
                                Field field = aClass.getDeclaredField("trainOrgID");
                                if (field != null) {
                                    hasTrainOrgId = true;
                                    //根据用户ID获取公司信息
                                    SecurityCompany company = securityCompanyDao.findByUserid(user.getId());
                                    //设置培训机构ID，查询
                                    where.append(" and ")
                                            .append(" trainOrgID = ")
                                            .append(company.getComId())
                                            .append(" ");
                                }
                            } catch (NoSuchFieldException e) {
                                //logger.error(e.getMessage(),e);
                            }
                        }
                        if (!hasTrainOrgId && !"Grade_Certificate".equals(tableName) && !"grade_person".equals(tableName) && !"CertificatePrintLog".equals(tableName) && !"sb_grade_practice".equals(tableName)) {
                            searchParams.put("user_id", user.getId());
                        } else {
                            searchParams.put("needcensorStatus", "1");
                        }
                    }
                    if (StringUtil.isNotEmpty(areaCode)) {
                        if (areaCode.endsWith("0000")) {//省
                            if (districtFlag) {
                                searchParams.put("district", areaCode.substring(0, 2) + "____");
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode.substring(0, 2) + "____");
                        } else if (areaCode.endsWith("00")) {//市
                            if (districtFlag) {
                                searchParams.put("district", areaCode.substring(0, 4) + "__");
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode.substring(0, 4) + "__");
                        } else {//区
                            if (districtFlag) {
                                searchParams.put("district", areaCode);
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode);
                        }
                    }
                }

                String column = exportModelDTO.getColumns();
                String table = tableName + " AS " + tableAnotherName;

                //获取实体字段与表字段的关联关系
                Map<String, String> columnMap = this.getColumn(aClass.newInstance());
                //拼接查询条件
                for (Object key : searchParams.keySet()) {
                    //值不为空
                    if (searchParams.get(key) != null && StringUtil.isNotEmpty(searchParams.get(key).toString())) {
                        if (columnMap.get(key) != null) {
                            Field field = null;
                            try {
                                //判断字段是否存在
                                field = aClass.getDeclaredField(key.toString());
                            } catch (NoSuchFieldException e) {
                                logger.error(e.getMessage(), e);
                            }
                            if (field != null) {
                                ModelAnnotation resource = field.getAnnotation(ModelAnnotation.class);
                                if (resource != null) {
                                    SignType signType = resource.sign();
                                    switch (signType) {
                                        case EQUAL_NULL_EMPTY:
                                        case EQUAL_NULL_ZERO:
                                            where.append(" and ifnull(")
                                                    .append(columnMap.get(key))
                                                    .append(",'")
                                                    .append(signType.getDefaultValue())
                                                    .append("') ")
                                                    .append(signType.getOperator())
                                                    .append(" '")
                                                    .append(searchParams.get(key))
                                                    .append("' ");
                                            break;
                                        case OR:
                                            String[] columns = columnMap.get(key).split(",");
                                            StringBuilder columnStr = new StringBuilder();
                                            for (int i = 0; i < columns.length; i++) {
                                                if (i > 0) {
                                                    columnStr.append(" or ");
                                                }
                                                columnStr.append(columns[i])
                                                        .append(" = '")
                                                        .append(searchParams.get(key))
                                                        .append("'");
                                            }
                                            where.append(" and (" + columnStr + ")");
                                            break;
                                        case OR_LIKE:
                                            String[] likeColumns = columnMap.get(key).split(",");
                                            StringBuilder likeColumnStr = new StringBuilder();
                                            for (int i = 0; i < likeColumns.length; i++) {
                                                if (i > 0) {
                                                    likeColumnStr.append(" or ");
                                                }
                                                likeColumnStr.append(likeColumns[i])
                                                        .append(" like '%")
                                                        .append(searchParams.get(key))
                                                        .append("%'");
                                            }
                                            where.append(" and (" + likeColumnStr + ")");
                                            break;
                                        case CASE://不为空
                                            where.append("  and (case contractStatus " +
                                                    "        when effectStartDate>date_format( now(), '%Y-%m-%d' ) then '8' " +
                                                    "        when '1' then '1' " +
                                                    "        when '2' then '2' " +
                                                    "        when '3' then '1' " +
                                                    "        else '2' " +
                                                    "      end ) = '")
                                                    .append(searchParams.get(key))
                                                    .append("' ");
                                            break;
                                        case NOTEMPTY://
                                            where.append(" and ifnull(")
                                                    .append(columnMap.get(key))
                                                    .append(",'")
                                                    .append(signType.getDefaultValue())
                                                    .append("') ")
                                                    .append(signType.getOperator())
                                                    .append(" ''");
                                            break;
                                        case IN://包含
                                            if (Constants.BKT_ORGTYPE_GS.equals(searchParams.get(key))) {
                                                where.append(" and ")
                                                        .append(columnMap.get(key))
                                                        .append(" in ('0102','0105')");

                                            } else {
                                                where.append(" and ")
                                                        .append(columnMap.get(key))
                                                        .append(signType.getOperator())
                                                        .append("('")
                                                        .append(searchParams.get(key))
                                                        .append("') ");
                                            }
                                            break;
                                        case NOTEQUAL://不等于
                                            where.append(" and ifnull(")
                                                    .append(columnMap.get(key))
                                                    .append(",'")
                                                    .append(signType.getDefaultValue())
                                                    .append("') ")
                                                    .append(signType.getOperator())
                                                    .append(" '")
                                                    .append(searchParams.get(key))
                                                    .append("' ");
                                            break;
                                        case LIKE:
                                            where.append(" and ")
                                                    .append(columnMap.get(key))
                                                    .append(" ")
                                                    .append(signType.getOperator())
                                                    .append(" '%")
                                                    .append(searchParams.get(key))
                                                    .append("%'");
                                            break;
                                        case OTHERIF:
                                            if (searchParams.get(key).equals(1)) {
                                                where.append(" and ")
                                                        .append(columnMap.get(key))
                                                        .append(" ")
                                                        .append(signType.getOperator())
                                                        .append(" true");
                                            } else if (searchParams.get(key).equals(0)) {
                                                where.append(" and ")
                                                        .append(columnMap.get(key))
                                                        .append(" ")
                                                        .append(signType.getOperator())
                                                        .append(" false");
                                            } else {
                                                where.append(" and ")
                                                        .append(columnMap.get(key))
                                                        .append(" ")
                                                        .append(signType.getOperator())
                                                        .append(" '")
                                                        .append(searchParams.get(key))
                                                        .append("'");
                                            }
                                            break;
                                        case OUTDAY:
                                            where.append(" and  datediff(now(),")
                                                    .append(columnMap.get(key))
                                                    .append(") ")
                                                    .append(signType.getOperator())
                                                    .append(" '")
                                                    .append(searchParams.get(key))
                                                    .append("'");
                                            break;
                                        case DATE_EQUAL:
                                        case DATE_GREATER_EQUAL:
                                        case DATE_LESS_EQUAL:
                                            //日期需要格式化处理
                                            where.append(" and  date_format(")
                                                    .append(columnMap.get(key))
                                                    .append(",'%Y-%m-%d') ")
                                                    .append(signType.getOperator())
                                                    .append(" '")
                                                    .append(searchParams.get(key))
                                                    .append("'");
                                            break;
                                        case IDCARDNATIVE:
                                            String nativePlace = (String) searchParams.get(key);
                                            if (nativePlace.endsWith("0000")) {
                                                nativePlace = nativePlace.substring(0, 2) + "________________";
                                            } else if (nativePlace.endsWith("00")) {
                                                //市、设置机构类型 市级2
                                                nativePlace = nativePlace.substring(0, 4) + "______________";
                                            }
                                            where.append(" and  ")
                                                    .append(columnMap.get(key))
                                                    .append(signType.getOperator())
                                                    .append(" '")
                                                    .append(nativePlace)
                                                    .append("'");
                                            break;
                                        case EQUAL:
                                        case GREATER_EQUAL:
                                        case LESS_EQUAL:
                                        default:
                                            where.append(" and ")
                                                    .append(columnMap.get(key))
                                                    .append(signType.getOperator())
                                                    .append("'")
                                                    .append(searchParams.get(key))
                                                    .append("' ");
                                            break;
                                    }
                                }
                            }
                        }
                    }
                }
                searchParams.put("tableColumn", column);
                searchParams.put("tableName", table);
                searchParams.put("search", search);
                searchParams.put("where", where.toString());
                mapList = exportDao.commonExportExcel(searchParams);
            }
            //导出
//            if (mapList.size() > 65535) {
//                throw new ArsException("导出记录数" + mapList.size() + "，超过excel最大行数，请过滤查询条件再导出！！");
//            }
            /**
             * 获取到导出数据之后导出到excel
             * */
            if (mapList != null && mapList.size() > 0) {
                Date now = new Date();
                String dirDate = DateUtil.systemDate.format(now);
                File dir = new File(downloadFolder + dirDate);
                if (!dir.exists()) {
                    dir.mkdirs();
                }

                String templateName = downloadFolder + dirDate + "/" + (now.getTime() + "_" + tableExcelName + ".xlsx");
                File file = new File(templateName);
                this.exportCompanys(mapList, file, excelName, exportModelDTO);
                return templateName;
            }
        } catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), e);
        } catch (IllegalAccessException e) {
            logger.error(e.getMessage(), e);
        } catch (InstantiationException e) {
            logger.error(e.getMessage(), e);
        }
        return null;
    }

    /**
     * 生成excel花名册并返回下载地址
     *
     * @param exportRosterDto 查询条件和exportType导出类型
     * @return
     */
    @Override
    public String exportRoster(ExportRosterDto exportRosterDto) {
        /**
         * 步骤
         * 1、根据导出类型获取导出配置（包括表名、标题等配置）
         * 2、通过导出的表配置获取字段配置，即需要导出的字段以及标题和底部内容
         * 3、根据导出字段和查询条件查询出需导出的数据
         * 4、将这些数据写入excel表格中（只有一个单位的话，输出Excle表格形式、多个单位则输出压缩包）
         */
        //1、根据导出类型获取配置，为空则抛出异常
        ExportConfig exportConfig = exportConfigDao.selectByExportType(exportRosterDto.getExportType());
        if (exportConfig == null) {
            throw new ArsException("未获取到对应的导出配置");
        }
        //2、根据configId获取字段配置，为空则抛出异常
        List<ExportColumn> columnList = exportConfigColumnDao.selectByConfigId(exportConfig.getId());
        if (columnList == null || columnList.size() == 0) {
            throw new ArsException("获取导出字段配置出错");
        }
        //字段配置，分出顶部中间底部
        Map<String, List<ExportColumn>> columnMap = new HashMap<String, List<ExportColumn>>();
        List<ExportColumn> select = new ArrayList<ExportColumn>();
        columnList.forEach(column -> {
            if ((Constants.YES).equals(column.getIsNeedSelect())) {
                select.add(column);
            }
            if (columnMap.get(column.getPosition()) == null) {
                List<ExportColumn> list = new ArrayList<ExportColumn>();
                list.add(column);
                columnMap.put(column.getPosition(), list);
            } else {
                columnMap.get(column.getPosition()).add(column);
            }
        });
        //3、如果字段列不为空则查询需导出的数据
        if (columnMap.get(Constants.CENTER) != null && columnMap.get(Constants.CENTER).size() > 0) {
            //通过字段名和表名以及查询条件获取需要导出的数据
            arsUtil.setPoliceSearch(exportRosterDto);
            String where = "";
            try {
                where = toStringWhere(exportRosterDto);
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
            //查询可导出的数据
            List<Map<String, String>> exportRosterDtoList = exportDao.selectDataV1(select, exportConfig.getTableName(), where);
            if (exportRosterDtoList == null || exportRosterDtoList.size() == 0) {
                throw new ArsException("数据为空");
            }
            //资格证处理
            if (exportRosterDto.getExportType().equals(Constants.CER_COMPARED)) {
                return exportCertificate(exportConfig, columnMap, exportRosterDtoList);
            }

            Date now = new Date();
            //获取日期
            String dirDate = DateUtil.systemDate.format(now);
            //创建文件夹
            File dir = new File(downloadFolder + dirDate);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if ((Constants.YES).equals(exportConfig.getIsJar())) {
                //4、对数据进行以培训单位分开，一个培训单位一个excle
                Map<String, List<Map<String, String>>> tables = splitTableByCompany(exportRosterDtoList, exportConfig.getTrainNameKey());
                //有多个单位的时候，将各个excel打成1个jar包并返回压缩包的下载地址
                if (tables.size() > 1) {
                    //单位名称为Excle名，获取每个对应excel的地址名
                    List<String> tableNameList = new ArrayList<String>();
                    for (String key : tables.keySet()) {
                        String templateName = downloadFolder + dirDate + "/" + FileUtil.generatingFileNameByDate(key) + ".xlsx";
                        File file = new File(templateName);
                        //将数据写入excel中
                        exportRosterExcel(columnMap, tables.get(key), file, key, exportConfig);
                        tableNameList.add(templateName);
                    }
                    return FileUtil.zipFiles(tableNameList, downloadFolder + dirDate + "/" + FileUtil.generatingFileNameByDate("export") + ".zip");
                }
                //只有一个单位的时候，直接返回excel形式，并返回下载地址
                if (tables.size() == 1) {
                    return getDownPath(columnMap, exportRosterDtoList, exportRosterDtoList.get(0).get(exportConfig.getTrainNameKey()), exportConfig);
                }
            }
            return getDownPath(columnMap, exportRosterDtoList, exportConfig.getTitle(), exportConfig);
        }
        return null;
    }

    @Override
    public String autoExportPersonInfo(PropertiesDTO propertiesDTO, String josnStr, Map<Object, Object> searchParams, String tableExcelName) {
        String tableAnotherName;
        String tableName;
        String excelName;
        List<ExportTableListDTO> tableList;
        String search = "";
        StringBuffer where = new StringBuffer("");
        List<Map> mapList = new ArrayList<>();

        //是否有district字段
        boolean districtFlag = false;
        try {
            //表名
            tableName = propertiesDTO.getTableName();
            //excel表格名称
            excelName = propertiesDTO.getExcelName();
            /**
             * 其他关联表
             */
            tableList = propertiesDTO.getTableList();
            /**
             * 主表查询的别名
             * */
            tableAnotherName = "t1";
            Class aClass = Class.forName(propertiesDTO.getModelPath());

            //获取是否要进行区域过滤
            Object o = aClass.getAnnotation(ModelTableAnnotation.class);
            //过滤字段
            String areaCodeFilterColumn = "areacode";
            String areaCodeFilter = "1";
            boolean extra = true;
            if (o instanceof ModelTableAnnotation) {
                ModelTableAnnotation tableAnnotation = (ModelTableAnnotation) o;
                areaCodeFilterColumn = tableAnnotation.areaCodeFilterColumn();
                areaCodeFilter = tableAnnotation.areaCodeFilter();
                extra = tableAnnotation.extra();
            }

            searchParams.put("extra", extra);

            ExportModelDTO exportModelDTO = this.getColumns(aClass.newInstance(), josnStr, tableAnotherName);
            if (exportModelDTO != null) {

                try {
                    Field field = aClass.getDeclaredField("district");
                    if (field != null) {
                        districtFlag = true;
                    }
                } catch (NoSuchFieldException e) {
                    //logger.error(e.getMessage(),e);
                }

                if (Constants.AREACODEFILTER_YES.equals(areaCodeFilter)) {
                    String areaCode = StringUtil.EMPTY;
                    if (searchParams.get(areaCodeFilterColumn) != null) {
                        areaCode = searchParams.get(areaCodeFilterColumn).toString();
                    }
                    if (StringUtil.isNotEmpty(areaCode)) {
                        if (areaCode.endsWith("0000")) {//省
                            if (districtFlag) {
                                searchParams.put("district", areaCode.substring(0, 2) + "____");
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode.substring(0, 2) + "____");
                        } else if (areaCode.endsWith("00")) {//市
                            if (districtFlag) {
                                searchParams.put("district", areaCode.substring(0, 4) + "__");
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode.substring(0, 4) + "__");
                        } else {//区
                            if (districtFlag) {
                                searchParams.put("district", areaCode);
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode);
                        }
                    }
                }

                String column = exportModelDTO.getColumns();
                String table = tableName + " AS " + tableAnotherName;

                //获取实体字段与表字段的关联关系
                Map<String, String> columnMap = this.getColumn(aClass.newInstance());
                //拼接查询条件
                for (Object key : searchParams.keySet()) {
                    //值不为空
                    if (searchParams.get(key) != null && StringUtil.isNotEmpty(searchParams.get(key).toString())) {
                        if (columnMap.get(key) != null) {
                            Field field = null;
                            try {
                                //判断字段是否存在
                                field = aClass.getDeclaredField(key.toString());
                            } catch (NoSuchFieldException e) {
                                logger.error(e.getMessage(), e);
                            }
                            if (field != null) {
                                ModelAnnotation resource = field.getAnnotation(ModelAnnotation.class);
                                if (resource != null) {
                                    SignType signType = resource.sign();
                                    where.append(signType.getExportWhereStrategy().spliceWhereStr(signType, columnMap, searchParams, key));
                                }
                            }
                        }
                    }
                }
                searchParams.put("tableColumn", column);
                searchParams.put("tableName", table);
                searchParams.put("search", search);
                searchParams.put("where", where.toString());
                System.out.println(searchParams.toString());
                mapList = exportDao.commonExportExcel(searchParams);
            }
            /**
             * 获取到导出数据之后导出到excel
             * */
            if (mapList != null && mapList.size() > 0) {
                Date now = new Date();
                String dirDate = DateUtil.systemDate.format(now);
                String dirDate1 = DateUtil.timestamp.format(now);
                File dir = new File(downloadFolder + dirDate);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                String fileName=now.getTime() + "_" + tableExcelName + ".xlsx";
                String templateName = downloadFolder + dirDate + "/" + fileName;
                File file = new File(templateName);
                this.exportCompanys(mapList, file, excelName, exportModelDTO);
                InputStream inputStream=new FileInputStream(file);
                logger.error("开始上传文件到ftp，ip:"+Constants.GX_FTP_HOST+",端口:"+Constants.GX_FTP_PORT+",用户名："+Constants.GX_FTP_USER_NAME+",密码："+Constants.GX_FTP_PASSWORD
                +"，ftp地址："+Constants.GX_FTP_PATH);
                FtpUtils.bcxUploadFile(Constants.GX_FTP_HOST,Constants.GX_FTP_USER_NAME,Constants.GX_FTP_PASSWORD,
                        Constants.GX_FTP_PORT,Constants.GX_FTP_PATH,"zhabxt_"+dirDate1+".xlsx",inputStream);
                // FtpUtils.bcxUploadFile("220.243.148.23","wstein-ftp","Bcx#20221209",
                        //6211,"/data/wstein-ftp/snupload/", "zhabxt_"+dirDate1+".xlsx",inputStream);
                return templateName;
            }
        } catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), e);
        } catch (IllegalAccessException e) {
            logger.error(e.getMessage(), e);
        } catch (InstantiationException e) {
            logger.error(e.getMessage(), e);
        } catch (FileNotFoundException e) {
            logger.error(e.getMessage(), e);
        }
        return null;
    }

    public String toStringWhere(ExportRosterDto exportRosterDto) throws Exception {

        Class aClass = Class.forName("com.bcxin.ars.dto.sys.ExportRosterDto");
        StringBuffer where = new StringBuffer("");
        ExportBusiness exportBusiness = ExportBusinessBeanFactory.getExportBusinessBean(exportRosterDto.getExportType());
        if (exportBusiness == null) {
            throw new ArsException("未找到对应业务类型");
        }
        exportBusiness.getWhereByBusiness(exportRosterDto);
        Map<Object, Object> parameters = getFiledInfo(exportRosterDto);
        //获取实体字段与表字段的关联关系
        Map<String, String> columnMap1 = this.getRosterExportColumn(aClass.newInstance());
        //拼接查询条件
        for (Object key : parameters.keySet()) {
            //值不为空
            if (parameters.get(key) != null && StringUtil.isNotEmpty(parameters.get(key).toString())) {
                if (columnMap1.get(key) != null) {
                    Field field = null;
                    try {
                        //判断字段是否存在
                        field = aClass.getDeclaredField(key.toString());
                    } catch (NoSuchFieldException e) {
                        logger.error(e.getMessage(), e);
                    }
                    if (field != null) {
                        ModelAnnotation resource = field.getAnnotation(ModelAnnotation.class);
                        if (resource != null) {
                            SignType signType = resource.sign();
                            where.append(signType.getExportWhereStrategy().spliceWhereStr(signType, columnMap1, parameters, key));
                        }
                    }
                }
            }
        }
        return where.toString();
    }

    /**
     * 实体类转换为Map集合
     *
     * @param exportRosterDto
     * @return
     */
    public static Map<Object, Object> getFiledInfo(ExportRosterDto exportRosterDto) {
        Map<Object, Object> parameters = new HashMap<>();
        Field[] fields = exportRosterDto.getClass().getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            parameters.put(field.getName(), ReflectionUtils.getField(field, exportRosterDto));
        }
        parameters.remove("exportType");
        return parameters;
    }

    public static Object getFieldValueByName(String fieldName, ExportRosterDto exportRosterDto) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = exportRosterDto.getClass().getMethod(getter, new Class[]{});
            Object value = method.invoke(exportRosterDto, new Object[]{});
            return value;
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("实体类转换为Map出错");
            return null;
        }
    }

    /**
     * 调用单个Excel的函数
     *
     * @param columnMap
     * @param exportRosterDtoList
     * @param tableExcelName
     * @param exportConfig
     * @return
     */
    public String getDownPath(Map<String, List<ExportColumn>> columnMap, List<Map<String, String>> exportRosterDtoList,
                              String tableExcelName, ExportConfig exportConfig) {
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder
                .getRequestAttributes()).getRequest();
        Date now = new Date();
        //获取日期
        String dirDate = DateUtil.systemDate.format(now);
        String downPath = "";
        try {
            /**
             *  //获取浏览器
             *  不同的浏览器的编码不一样
             *  */
            String userAgent = request.getHeader("user-agent");
            if (userAgent != null && userAgent.indexOf("Firefox") >= 0 || userAgent.indexOf("Chrome") >= 0
                    || userAgent.indexOf("Safari") >= 0) {
                downPath = new String(tableExcelName.getBytes(), "ISO8859-1");
            } else {
                downPath = URLEncoder.encode(tableExcelName, "UTF8"); //其他浏览器
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new ArsException("设置表名出错");
        }
        downPath = downloadFolder + dirDate + "/" + FileUtil.generatingFileNameByDate(downPath) + ".xlsx";
        File file = new File(downPath);
        //将数据写入excel中
        exportRosterExcel(columnMap, exportRosterDtoList, file, tableExcelName, exportConfig);
        return downPath;
    }

    //分不同个excel表格
    public Map<String, List<Map<String, String>>> splitTableByCompany(List<Map<String, String>> exportRosterDtoList, String key) {
        Map<String, List<Map<String, String>>> map = new HashMap<String, List<Map<String, String>>>();
        //对列表进行循环，存在该单位名称则放入list中，不存在则新增以trainName为key，list为value的键值对中
        exportRosterDtoList.forEach(column -> {
            String trainName = column.get(key);
            if (StringUtil.isNotEmpty(trainName)) {
                if (map.get(trainName) == null) {
                    List<Map<String, String>> list = new ArrayList<Map<String, String>>();
                    list.add(column);
                    map.put(trainName, list);
                } else {
                    map.get(trainName).add(column);
                }
            }
        });
        return map;
    }

    /**
     * 将数据写入ecel表格中
     *
     * @param columnMap           需要写入的字段，标题，底部的集合
     * @param exportRosterDtoList 需要写入的数据
     * @param file                文件
     * @param tableExcelName      文件名
     * @param exportConfig        表配置
     */
    public void exportRosterExcel(Map<String, List<ExportColumn>> columnMap, List<Map<String, String>> exportRosterDtoList,
                                  File file, String tableExcelName, ExportConfig exportConfig) {
        Map<String, ExportExcelType> mapType = new HashMap<String, ExportExcelType>();
        mapType.put("001", ExportExcelType.FILED_NAME);
        mapType.put("002", ExportExcelType.SYS_CODE);
        mapType.put("003", ExportExcelType.DATE_FOMAT);
        mapType.put("004", ExportExcelType.SAVE_ONEPOINT);
        try {
            //创建excel对象
            Workbook wb = new XSSFWorkbook();
            Sheet sheet1 = wb.createSheet(tableExcelName);
            //标题样式,无边框、设置字体、是否加粗、是否水平居中
            CellStyle style = ExcelUtil.getExportStyle(wb, (short) 11);
            CellStyle styleColumn = ExcelUtil.getExportStyle(wb, (short) 9);
            CellStyle styleTitle = ExcelUtil.getExportHeadStyle(wb, (short) 16, Constants.YES, Constants.YES);
            CellStyle styleHead = ExcelUtil.getExportHeadStyle(wb, (short) 12, Constants.YES, Constants.NO);
            CellStyle styleBottom = ExcelUtil.getExportHeadStyle(wb, (short) 11, Constants.NO, Constants.NO);
            //index表示行数，生成一行后+1
            int index = 0;
            Row rowTitle = sheet1.createRow(index++);//第一个sheet的第一行为标题
            rowTitle.setHeightInPoints(35);//行高
            ExcelUtil.setStyleCell(rowTitle, 0, exportConfig.getTitle(), styleTitle);
            ExcelUtil.region(0, 0, 0, 0, exportConfig.getColumns() - 1, wb);//合并单元格
            //获取头部字段，并且对每个字段循环
            List<ExportColumn> top = columnMap.get(Constants.TOP);
            if (top != null && top.size() > 0) {
                int beginCol = 0, lastCol = 0;
                Row rowTop = sheet1.createRow(index++);//创建行
                rowTop.setHeightInPoints(30);//行高
                for (int i = 0; i < top.size(); i++) {
                    ExportColumn topI = top.get(i);
                    beginCol = topI.getBeginCol().intValue();//起始行
                    lastCol = topI.getOccupy().intValue();//占用列数
                    //根据公式类型获取对应枚举类然后进行计算
                    String columnValue = topI.getColumnName();
                    if (StringUtils.isNotEmpty(topI.getFormula())) {
                        ExportExcelType exportExcelType = mapType.get(topI.getFormula());
                        columnValue = columnValue + exportExcelType.getFormula().getFormulaValue(exportRosterDtoList, topI, "");
                    }
                    ExcelUtil.setStyleCell(rowTop, beginCol, columnValue, styleHead);
                    //只有大于两个单元格合并才不报错从
                    if (lastCol > 1) {
                        ExcelUtil.region(0, 1, 1, beginCol, beginCol + lastCol - 1, wb);
                    }
                }
            }
            List<ExportColumn> files = columnMap.get(Constants.CENTER);
            //写标题，begin表示字段起始起始列列数
            int begin = 0;
            Row fileRow = sheet1.createRow(index++);
            //表配置需要序号列的时候添加序号列
            if ((Constants.YES).equals(exportConfig.getColumnNo())) {
                begin = 1;
                ExcelUtil.setStyleCell(fileRow, 0, "序号", style);
                sheet1.setColumnWidth(0, 1500);
            }
            //对字段做循环并创建每个单元格
            for (int i = begin, j = 0; j < files.size(); i++, j++) {
                ExportColumn exportColumn = files.get(j);
                String date = exportColumn.getColumnName();
                fileRow.setHeightInPoints(30);//行高
                sheet1.setColumnWidth(i, exportColumn.getColumnWith()); //设置每列的列宽
                //必填项需要加*号
                if ((Constants.YES).equals(exportColumn.getRequired())){
                    date = date + "*";}
                ExcelUtil.setStyleCell(fileRow, i, date, styleColumn);

            }
            Row row = null;
            //写数据，number表示序号
            int number = 1;
            for (Map map : exportRosterDtoList) {
                row = sheet1.createRow(index++);//创建行后index+1
                row.setHeightInPoints(30);//行高
                //有序号列的话，取每一行的第一个单元格设置
                if (begin == 1) {
                    ExcelUtil.setStyleCell(row, 0, String.valueOf(number), style);
                    number++;
                }
                for (int i = begin, j = 0; j < files.size(); i++, j++) {
                    /* HSSFCell nameCell = row.createCell(i);*/
                    //files为字段列是有序的，获取key然后到map里面取数据
                    String key = files.get(j).getColumnValueSource();
                    String cellValue = "";
                    //往单元格里写数据
                    if (map.get(key) != null && map.get(key).toString() != "") {
                        cellValue = map.get(key).toString();
                    }
                    //根据公式类型获取对应枚举类然后进行计算
                    String formula = files.get(j).getFormula();
                    if (StringUtils.isNotEmpty(formula)) {
                        ExportExcelType exportExcelType = mapType.get(files.get(j).getFormula());
                        cellValue = exportExcelType.getFormula().getFormulaValue(exportRosterDtoList, files.get(j), cellValue);
                    }
                    ExcelUtil.setStyleCell(row, i, cellValue, style);
                }
            }
            //写底部，list的位置表示底部的序号
            List<ExportColumn> bottom = columnMap.get(Constants.BOTTOM);
            if (bottom != null && bottom.size() > 0) {
                Row rowBottom = sheet1.createRow(index++);
                int beginCol = 0, lastCol = 0;
                String value = "";
                for (int i = 0; i < bottom.size(); i++) {
                    Cell bottomCell = null;
                    beginCol = bottom.get(i).getBeginCol().intValue();//起始行
                    lastCol = bottom.get(i).getOccupy().intValue();//占用列数
                    if (StringUtil.isNotEmpty(bottom.get(i).getContext())) {
                        Row contentRow = sheet1.createRow(index++);//创建行
                        bottomCell = contentRow.createCell(1);
                        value = bottom.get(i).getContext();//获取固定内容
                        contentRow.setHeight((short) 3000);
                    } else {
                        bottomCell = rowBottom.createCell(beginCol);
                        rowBottom.setHeight((short) 800);
                        value = bottom.get(i).getColumnName();//todo 未知对应字段
                    }
                    bottomCell.setCellValue(value);//赋值
                    bottomCell.setCellStyle(styleBottom);//设置样式
                    //只有大于两个单元格合并才不报错
                    if (lastCol > 1) {
                        ExcelUtil.region(0, bottomCell.getRowIndex(), bottomCell.getRowIndex(), beginCol, beginCol + lastCol - 1, wb);
                    }
                }
            }
            //输出模板
            FileOutputStream fileOut;
            fileOut = new FileOutputStream(file);
            wb.write(fileOut);
            fileOut.close();
            wb.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String commonExport(PropertiesDTO propertiesDTO, String josnStr, Map<Object, Object> searchParams, User user, String tableExcelName) {
        String tableAnotherName;
        String tableName;
        String excelName;
        List<ExportTableListDTO> tableList;
        String tableListName = "";
        String tableListColumn = "";
        String search = "";
        StringBuffer where = new StringBuffer("");
        List<Map> mapList = new ArrayList<>();

        //是否有district字段
        boolean districtFlag = false;
        try {
            //表名
            tableName = propertiesDTO.getTableName();
            //excel表格名称
            excelName = propertiesDTO.getExcelName();
            /**
             * 其他关联表
             */
            tableList = propertiesDTO.getTableList();
            /**
             * 主表查询的别名
             * */
            tableAnotherName = "t1";
            Class aClass = Class.forName(propertiesDTO.getModelPath());

            //获取是否要进行区域过滤
            Object o = aClass.getAnnotation(ModelTableAnnotation.class);
            //过滤字段
            String areaCodeFilterColumn = "areacode";
            String areaCodeFilter = "1";
            boolean extra = true;
            if (o instanceof ModelTableAnnotation) {
                ModelTableAnnotation tableAnnotation = (ModelTableAnnotation) o;
                areaCodeFilterColumn = tableAnnotation.areaCodeFilterColumn();
                areaCodeFilter = tableAnnotation.areaCodeFilter();
                extra = tableAnnotation.extra();
            }

            searchParams.put("extra", extra);

            ExportModelDTO exportModelDTO = this.getColumns(aClass.newInstance(), josnStr, tableAnotherName);
            if (exportModelDTO != null) {

                try {
                    Field field = aClass.getDeclaredField("district");
                    if (field != null) {
                        districtFlag = true;
                    }
                } catch (NoSuchFieldException e) {
                    //logger.error(e.getMessage(),e);
                }

                if (Constants.AREACODEFILTER_YES.equals(areaCodeFilter)) {
                    String areaCode = StringUtil.EMPTY;
                    if (searchParams.get(areaCodeFilterColumn) != null) {
                        areaCode = searchParams.get(areaCodeFilterColumn).toString();
                    }
                    Police police = user.getPolice();
                    if (police != null) {
                        if (StringUtil.isEmpty(areaCode)) {
                            //北京地区不进行区域过滤
//                            if(Constants.BEIJING.equals(configUtils.getCurrentNative())){
//                                areaCode = configUtils.getCurrentNative();
//                            }else{
                            areaCode = police.getAreacode();
//                            }
                        }
                    } else {
                        boolean hasTrainOrgId = false;
                        //培训机构
                        if (user.getPlatform() == Constants.PLATFORM_COMPANY && !"CertificatePrintLog".equals(tableName)) {
                            try {
                                Field field = aClass.getDeclaredField("trainOrgID");
                                if (field != null) {
                                    hasTrainOrgId = true;
                                    //根据用户ID获取公司信息
                                    SecurityCompany company = securityCompanyDao.findByUserid(user.getId());
                                    //设置培训机构ID，查询
                                    where.append(" and ")
                                            .append(" trainOrgID = ")
                                            .append(company.getComId())
                                            .append(" ");
                                }
                            } catch (NoSuchFieldException e) {
                                //logger.error(e.getMessage(),e);
                            }
                        }
                        if (!hasTrainOrgId && !"Grade_Certificate".equals(tableName) && !"grade_person".equals(tableName) && !"CertificatePrintLog".equals(tableName) && !"sb_grade_practice".equals(tableName)) {
                            searchParams.put("user_id", user.getId());
                        } else {
                            searchParams.put("needcensorStatus", "1");
                        }
                    }
                    if (StringUtil.isNotEmpty(areaCode)) {
                        if (areaCode.endsWith("0000")) {//省
                            if (districtFlag) {
                                searchParams.put("district", areaCode.substring(0, 2) + "____");
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode.substring(0, 2) + "____");
                        } else if (areaCode.endsWith("00")) {//市
                            if (districtFlag) {
                                searchParams.put("district", areaCode.substring(0, 4) + "__");
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode.substring(0, 4) + "__");
                        } else {//区
                            if (districtFlag) {
                                searchParams.put("district", areaCode);
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode);
                        }
                    }
                }

                String column = exportModelDTO.getColumns();
                String table = tableName + " AS " + tableAnotherName;

                //获取实体字段与表字段的关联关系
                Map<String, String> columnMap = this.getColumn(aClass.newInstance());
                //拼接查询条件
                for (Object key : searchParams.keySet()) {
                    //值不为空
                    if (searchParams.get(key) != null && StringUtil.isNotEmpty(searchParams.get(key).toString())) {
                        if (columnMap.get(key) != null) {
                            Field field = null;
                            try {
                                //判断字段是否存在
                                field = aClass.getDeclaredField(key.toString());
                            } catch (NoSuchFieldException e) {
                                logger.error(e.getMessage(), e);
                            }
                            if (field != null) {
                                ModelAnnotation resource = field.getAnnotation(ModelAnnotation.class);
                                if (resource != null) {
                                    SignType signType = resource.sign();
                                    where.append(signType.getExportWhereStrategy().spliceWhereStr(signType, columnMap, searchParams, key));
                                }
                            }
                        }
                    }
                }
                searchParams.put("tableColumn", column);
                searchParams.put("tableName", table);
                searchParams.put("search", search);
                searchParams.put("where", where.toString());
                mapList = exportDao.commonExportExcel(searchParams);
            }
            //导出
//            if (mapList.size() > 65535) {
//                throw new ArsException("导出记录数" + mapList.size() + "，超过excel最大行数，请过滤查询条件再导出！！");
//            }
            /**
             * 获取到导出数据之后导出到excel
             * */
            if (mapList != null && mapList.size() > 0) {
                Date now = new Date();
                String dirDate = DateUtil.systemDate.format(now);
                File dir = new File(downloadFolder + dirDate);
                if (!dir.exists()) {
                    dir.mkdirs();
                }

                String templateName = downloadFolder + dirDate + "/" + (now.getTime() + "_" + tableExcelName + ".xlsx");
                File file = new File(templateName);
                this.exportCompanys(mapList, file, excelName, exportModelDTO);
                return templateName;
            }
        } catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), e);
        } catch (IllegalAccessException e) {
            logger.error(e.getMessage(), e);
        } catch (InstantiationException e) {
            logger.error(e.getMessage(), e);
        }
        return null;
    }

    /**
     * 获取实体字段与表字段关联关系
     *
     * @param object
     * @return
     */
    private Map getColumn(Object object) {


        Map<String, String> columnMap = new HashMap<>();
        Field[] fields = object.getClass().getDeclaredFields();
        for (Field field : fields) {
            if (field.isAnnotationPresent(ModelAnnotation.class)) {
                ModelAnnotation resource = field.getAnnotation(ModelAnnotation.class);
                if (StringUtil.isNotEmpty(resource.column())) {
                    columnMap.put(field.getName(), new StringBuffer().append(resource.tableName()).append(".").append(resource.column()).toString());
                }
            }
        }
        return columnMap;
    }

    /**
     * 获取实体字段与表字段关联关系
     *
     * @param object
     * @return
     */
    private Map getRosterExportColumn(Object object) {
        Map<String, String> columnMap = new HashMap<>();
        Field[] fields = object.getClass().getDeclaredFields();
        for (Field field : fields) {
            if (field.isAnnotationPresent(ModelAnnotation.class)) {
                ModelAnnotation resource = field.getAnnotation(ModelAnnotation.class);
                if (StringUtil.isNotEmpty(resource.column())) {
                    columnMap.put(field.getName(), new StringBuffer().append(resource.column()).toString());
                }
            }
        }
        return columnMap;
    }

    /**
     * 获取数据库字段
     */
    private ExportModelDTO getColumns(Object object, String josnStr, String tableName) {
        List<ModelNameDTO> modelNameDTOList = JSONArray.parseArray(josnStr, ModelNameDTO.class);
        Field[] fields = object.getClass().getDeclaredFields();
        ExportModelDTO exportModelDTO = new ExportModelDTO();
        String columnStr = "";
        String modeNames = "";
        String modekeys = "";
        String exportColumns = "";
        for (Field field : fields) {
            if (field.isAnnotationPresent(ModelAnnotation.class)) {
                ModelAnnotation resource = field.getAnnotation(ModelAnnotation.class);
                //是否是导出字段
                if (resource.isExport()) {
                    for (ModelNameDTO modelNameDTO1 : modelNameDTOList) {
                        if (modelNameDTO1.getModekey().equals(field.getName())) {
                            //特殊翻译（查询其他表的翻译）
                            if (StringUtil.isEmpty(resource.specialTranslateType())) {
                                //是否需要翻译
                                if (resource.multipleCode()) {
                                    //由于多码表查询，需要获取该字段的表名，tableName应该赋值
                                    columnStr += multipleCode(resource.dictName(), resource.column(), resource.multipleCodeTableName()) + ",";
                                } else if (resource.needTranslate()) {
                                    String defaultValue = resource.sign().getDefaultValue();
                                    columnStr += needTranslate(resource.dictName(), resource.oneToMore(), resource.column(), tableName, defaultValue) + ",";
                                } else if (StringUtil.isNotEmpty(resource.DATE_FORMAT())) {
                                    columnStr += "DATE_FORMAT(" + tableName + "." + resource.column() + ",'" + resource.DATE_FORMAT() + "') as " + resource.column() + ",";
                                } else if (resource.mySqlDataFormat() != null) {
                                    switch (resource.mySqlDataFormat()) {
                                        case MINUTE2HOUR_FLOAT_2:
                                            columnStr += "convert(" + tableName + "." + resource.column() + "/60.0,decimal(10,2))" + " as " + resource.column() + ",";
                                            break;
                                        default:
                                            columnStr += tableName + "." + resource.column() + ",";
                                    }
                                } else {
                                    columnStr += tableName + "." + resource.column() + ",";
                                }
                            } else {
                                columnStr += specialTranslate(resource.specialTranslateType(), tableName + "." + resource.column(), resource.dictName()) + ",";
                            }
                            exportColumns += resource.column() + ",";
                            modekeys += modelNameDTO1.getModekey() + ",";
                            modeNames += resource.getName() + ",";

                        }
                    }
                }
            }
        }
        if (columnStr != "") {
            exportModelDTO.setColumns(columnStr.substring(0, columnStr.length() - 1));
            exportModelDTO.setModekeys(modekeys.substring(0, modekeys.length() - 1));
            exportModelDTO.setModeNames(modeNames.substring(0, modeNames.length() - 1));
            exportModelDTO.setExportColumns(exportColumns.substring(0, exportColumns.length() - 1));
            return exportModelDTO;
        }
        return null;
    }

    /**
     * 获取数据库字段
     */
    private ExportModelDTO getColumn(Object object, String josnStr, String tableName) {
        List<ModelNameDTO> modelNameDTOList = JSONArray.parseArray(josnStr, ModelNameDTO.class);
        Field[] fields = object.getClass().getDeclaredFields();
        ExportModelDTO exportModelDTO = new ExportModelDTO();
        String columnStr = "";
        String modeNames = "";
        String modekeys = "";
        String exportColumns = "";
        for (Field field : fields) {
            if (field.isAnnotationPresent(ModelAnnotation.class)) {
                ModelAnnotation resource = field.getAnnotation(ModelAnnotation.class);
                //是否是导出字段
                if (resource.isExport()) {
                    for (ModelNameDTO modelNameDTO1 : modelNameDTOList) {
                        if (modelNameDTO1.getModekey().equals(field.getName())) {
                            //如果是其他表就不需加入到字段中
                            if (!resource.anotherTable()) {
                                //特殊翻译（查询其他表的翻译）
                                if (StringUtil.isEmpty(resource.specialTranslateType())) {
                                    //是否需要翻译
                                    if (resource.multipleCode()) {
                                        //由于多码表查询，需要获取该字段的表名，tableName应该赋值
                                        columnStr += multipleCode(resource.dictName(), resource.column(), resource.multipleCodeTableName()) + ",";
                                    } else if (resource.needTranslate()) {
                                        String defaultValue = resource.sign().getDefaultValue();
                                        columnStr += needTranslate(resource.dictName(), resource.oneToMore(), resource.column(), tableName, defaultValue) + ",";
                                    } else if (StringUtil.isNotEmpty(resource.DATE_FORMAT())) {
                                        columnStr += "DATE_FORMAT(" + tableName + "." + resource.column() + ",'" + resource.DATE_FORMAT() + "') as " + resource.column() + ",";
                                    } else if (resource.mySqlDataFormat() != null) {
                                        switch (resource.mySqlDataFormat()) {
                                            case MINUTE2HOUR_FLOAT_2:
                                                columnStr += "convert(" + tableName + "." + resource.column() + "/60.0,decimal(10,2))" + " as " + resource.column() + ",";
                                                break;
                                            default:
                                                columnStr += tableName + "." + resource.column() + ",";
                                        }
                                    } else {
                                        columnStr += tableName + "." + resource.column() + ",";
                                    }
                                } else {
                                    columnStr += specialTranslate(resource.specialTranslateType(), tableName + "." + resource.column(), resource.dictName()) + ",";
                                }
                            }

                            exportColumns += resource.column() + ",";

                            modekeys += modelNameDTO1.getModekey() + ",";
                            modeNames += resource.getName() + ",";

                        }
                    }
                }

            }
        }

        if (columnStr != "") {
            exportModelDTO.setColumns(columnStr.substring(0, columnStr.length() - 1));
            exportModelDTO.setModekeys(modekeys.substring(0, modekeys.length() - 1));
            exportModelDTO.setModeNames(modeNames.substring(0, modeNames.length() - 1));
            exportModelDTO.setExportColumns(exportColumns.substring(0, exportColumns.length() - 1));
            return exportModelDTO;
        }

        return null;
    }

    private String specialTranslate(String specialTranslateType, String columName, String dictName) {
        {
            String columnStr = "";
            if (Constants.SPECIAL_TRANSLATE_TYPE_NATION.equals(specialTranslateType)) {
                columnStr = "(SELECT `name` FROM nation WHERE code=" + columName + "  ) AS " + dictName;
            } else if (Constants.SPECIAL_TRANSLATE_TYPE_AREANAME.equals(specialTranslateType)) {
                columnStr = "(SELECT GROUP_CONCAT(`name` separator  '') FROM sysarea \n" +
                        "WHERE `code` in (RPAD(left(" + dictName + ",2), 6, 0),RPAD(left(" + dictName + ",4), 6, 0)," + dictName + ") order by id) AS areaName ";
            } else if (Constants.SPECIAL_TRANSLATE_CHANGE_PROJECT.equals(specialTranslateType)) {
                columnStr = "  CONCAT(IF(ISNULL(t1.securityScopes),'','服务范围变更,'),IF(ISNULL(t1.companyname),'','公司名称变更,'),IF(ISNULL(t1.address),'','地址变更,'),IF(ISNULL(t1.legalname),'','法人变更,'),IF(ISNULL(t1.bgregisteredMoney),'','注册资金变更,'))\n" +
                        "        as changeProject";
            } else if (Constants.SPECIAL_TRANSLATE_MAKE_UP_COUNT.equals(specialTranslateType)) {
                columnStr = "  (select\n" +
                        "        case\n" +
                        "        when count(0) > 0\n" +
                        "        then count(0) -1\n" +
                        "        else count(0)\n" +
                        "        end\n" +
                        "        from\n" +
                        "        train_exam_person p,train_exam_info q\n" +
                        "        where  p.identitynumber = t1.Cardnumber and p.examid = q.id and q.examState != '1'\n" +
                        "        ) makeUpCount";
            } else if (Constants.SPECIAL_TRANSLATE_COMPANY_NAME.equals(specialTranslateType)) {
                columnStr = "  IFNULL(t1.companyName,(SELECT `name` from security_company WHERE id=t1.companyid )) as companyName";
            }
            return columnStr;
        }
    }

    /***
     * 一个字段多个码表值转换
     * @param dictName
     * @param columName
     * @param multipleCodeTableName
     * @return
     */
    private String multipleCode(String dictName, String columName, String multipleCodeTableName) {

        String columnStr = "";
        columnStr = "( select GROUP_CONCAT(label) from sys_dict where codeType ='" + dictName + "' and codeValue in(\n" +
                "SELECT\n" +
                "\tsubstring_index(\n" +
                "\t\tsubstring_index(\n" +
                "\t\t\t" + multipleCodeTableName + "." + columName + ",\n" +
                "\t\t\t',',\n" +
                "\t\t\tb.help_topic_id + 1\n" +
                "\t\t),\n" +
                "\t\t',' ,- 1\n" +
                "\t) shopid\n" +
                "FROM\n" +
                "\t" + multipleCodeTableName + "\n" +
                "JOIN help_topic b ON b.help_topic_id < (\n" +
                "\tlength(" + multipleCodeTableName + "." + columName + ") - length(\n" +
                "\t\tREPLACE (" + multipleCodeTableName + "." + columName + ", ',', '')\n" +
                "\t) + 1\n" +
                ")\n" +
                "WHERE\n" +
                "\tid = t1.id \n" +
                ")) AS " + columName;
        return columnStr;
    }

    private String needTranslate(String dictName, boolean oneToMore, String columName, String tableName, String defaultValue) {
        String columnStr = "";
        String tableColum = tableName + "." + columName;
        if (StringUtil.isNotEmpty(defaultValue)) {
            tableColum = "ifnull(" + tableName + "." + columName + "," + defaultValue + ")";
        }
        if (!oneToMore) {
            columnStr = "(SELECT label FROM sys_dict WHERE codeType='" + dictName + "' AND codeValue=" + tableColum + " ) AS " + columName;
        } else {
            columnStr = "(SELECT GROUP_CONCAT(label SEPARATOR  ',')  \n" +
                    "        FROM sys_dict\n" +
                    "       WHERE codeType = '" + dictName + "'\n" +
                    "         AND FIND_IN_SET(codeValue," + tableColum + ") >= 1)  AS  " + columName;
        }
        return columnStr;
    }

    @Override
    public List<ModelNameDTO> chooseExportColumn(PropertiesDTO propertiesDTO, List<ModelNameDTO> modelNameDTOList) {
        try {
            //反射出类的class
            Class aClass = Class.forName(propertiesDTO.getModelPath());

            //获取默认字段
            List<ModelNameDTO> columnList = this.getModelName(aClass.newInstance(), modelNameDTOList);
            return columnList;
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }

        return null;
    }


    private List<ModelNameDTO> getModelName(Object object, List<ModelNameDTO> modelNameDTOList) {
        /**
         * 获取文件
         * */
        Field[] fields = object.getClass().getDeclaredFields();
        ModelNameDTO modelNameDTO;
        List<ModelNameDTO> listModelName = new ArrayList<>();
        for (Field field : fields) {
            /**
             * 判断文件是否有自定义注解：ModelAnnotation
             * */
            if (field.isAnnotationPresent(ModelAnnotation.class)) {
                modelNameDTO = new ModelNameDTO();
                /**
                 * 获取自定义注解资源
                 * */
                ModelAnnotation resource = field.getAnnotation(ModelAnnotation.class);
                //是否是导出字段
                if (resource.isExport()) {
                    /**
                     * 是需要导出字段，
                     * */
                    modelNameDTO.setModekey(field.getName());
                    modelNameDTO.setModeName(resource.getName());
                    /**
                     * 用户是否使用过导出，如果没有就获取默认，如果有就获取用户已经选取过的
                     * */
                    if (modelNameDTOList.size() > 0) {
                        /**
                         * 获取用户选取过的字段
                         * */
                        for (ModelNameDTO modelNameDTO1 : modelNameDTOList) {
                            if (modelNameDTO1.getModekey().equals(field.getName())) {
                                /**
                                 * 前端字段蓝色显示
                                 * */
                                modelNameDTO.setModelSelect("class=\"light-blue\"");
                                break;
                            }
                        }
                    } else {
                        //获取默认
                        if (resource.defaultColumn()) {
                            modelNameDTO.setModelSelect("class=\"light-blue\"");
                        }
                    }
                    listModelName.add(modelNameDTO);
                }
            }
        }
        return listModelName;
    }

    /**
     * @param file
     * @return void
     * @Decription:生成excel的方法
     * @author：zhongjianhui
     * @method exportCompanys
     * @date：2018/9/13 16:01
     * @params： * @param companys
     */
    private void exportCompanys(List<Map> list, File file, String excelName, ExportModelDTO exportModelDTO) {
        try {
            SXSSFWorkbook wb = new SXSSFWorkbook();
            SXSSFSheet sheet1 = wb.createSheet(excelName);
            //标题
            String[] handers = exportModelDTO.getModeNames().split(",");
            //生成sheet1内容
            SXSSFRow rowFirst = sheet1.createRow(0);//第一个sheet的第一行为标题
            //样式
            CellStyle style = ExcelUtil.getExportStyle(wb, (short) 12);
            //写标题

            for (int i = 0; i < handers.length; i++) {
                SXSSFCell cell = rowFirst.createCell(i); //获取第一行的每个单元格
                sheet1.setColumnWidth(i, 5000); //设置每列的列宽
                cell.setCellStyle(style);
                cell.setCellValue(handers[i]); //往单元格里写数据
            }
            int index = 1;
            SXSSFRow row = null;
            for (Map map : list) {
                List<String> stringList = Arrays.asList(exportModelDTO.getExportColumns().split(","));
                row = sheet1.createRow(index++);
                for (int i = 0; i < stringList.size(); i++) {
                    SXSSFCell nameCell = row.createCell(i);
                    nameCell.setCellStyle(style);
                    String key = stringList.get(i);
                    String cellValue = "";
                    //往单元格里写数据
                    if (map.get(key) != null && map.get(key).toString() != "") {
                        cellValue = map.get(key).toString();
                    }
                    nameCell.setCellValue(cellValue);
                }
            }
            //输出模板
            FileOutputStream fileOut;
            fileOut = new FileOutputStream(file);
            wb.write(fileOut);
            fileOut.close();
            wb.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 导出资格证部分
     *
     * @param exportConfig        配置
     * @param columnMap           字段
     * @param exportRosterDtoList 数据
     * @return 文件所在位置
     */
    private String exportCertificate(ExportConfig exportConfig,
                                     Map<String, List<ExportColumn>> columnMap,
                                     List<Map<String, String>> exportRosterDtoList) {
        //日期处理,对资格证补贴审批管理导出的名字进行拼接
        List<Date> applyTimeList = Lists.newArrayList();
        exportRosterDtoList.forEach(stringStringMap -> {
            Object applyTime = stringStringMap.get("applyTime");
            if (ObjectUtil.isNotNull(applyTime)) {
                Date date = (Date) applyTime;
                applyTimeList.add(date);
            }
        });
        //根据申请日期排序以拿到最早和最晚日期
        applyTimeList.sort(Date::compareTo);
        Date start = null;
        Date end = null;
        if (applyTimeList.size() > 0) {
            start = applyTimeList.get(0);
            end = applyTimeList.get(applyTimeList.size() - 1);
        }
        Date now = new Date();
        //获取日期
        String dirDate = DateUtil.systemDate.format(now);
        //创建文件夹
        File dir = new File(downloadFolder + dirDate);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((Constants.YES).equals(exportConfig.getIsJar())) {
            //4、对数据进行以培训单位分开，一个培训单位一个excel
            Map<String, List<Map<String, String>>> tables =
                    splitTableByCompany(exportRosterDtoList, exportConfig.getTrainNameKey());
            //有多个单位的时候，将各个excel打成1个jar包并返回压缩包的下载地址
            if (tables.size() > 1) {
                //单位名称为excel名，获取每个对应excel的地址名
                List<String> tableNameList = new ArrayList<String>();
                for (String key : tables.keySet()) {
                    String templateName = downloadFolder + dirDate + "/" + key + FileUtil.getFileNameByDateInterregional(start, end) + ".xlsx";
                    File file = new File(templateName);
                    //将数据写入excel中
                    exportRosterExcel(columnMap, tables.get(key), file, key, exportConfig);
                    tableNameList.add(templateName);
                }
                return FileUtil.zipFiles(tableNameList, downloadFolder + dirDate + "/" + FileUtil.generatingFileNameByDate("export") + ".zip");
            }
            //只有一个单位的时候，直接返回excel形式，并返回下载地址
            if (tables.size() == 1) {
                return getDownloadPath(columnMap, exportRosterDtoList, FileUtil.getFileNameByDateInterregional(start, end), exportConfig);
            }
        }
        return getDownloadPath(columnMap, exportRosterDtoList, FileUtil.getFileNameByDateInterregional(start, end), exportConfig);

    }


    /**
     * 保存excel 获取保存地址
     *
     * @param columnMap           字段
     * @param exportRosterDtoList 数据
     * @param tableExcelName      表名
     * @param exportConfig        配置
     * @return 保存地址
     */
    public String getDownloadPath(Map<String, List<ExportColumn>> columnMap,
                                  List<Map<String, String>> exportRosterDtoList,
                                  String tableExcelName,
                                  ExportConfig exportConfig) {
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder
                .getRequestAttributes()).getRequest();
        Date now = new Date();
        //获取日期
        String dirDate = DateUtil.systemDate.format(now);
        String downPath = downloadFolder + dirDate + "/" + tableExcelName + ".xlsx";
        try {
            //编码配置
            String userAgent = request.getHeader("user-agent");
            if (userAgent != null
                    && (userAgent.contains("Firefox")
                    || userAgent.contains("Chrome")
                    || userAgent.contains("Safari"))) {
                downPath = new String(downPath.getBytes(), "ISO8859-1");
            } else {
                downPath = URLEncoder.encode(downPath, "UTF8"); //其他浏览器
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new ArsException("设置表名出错");
        }
        File file = new File(downPath);
        //将数据写入excel中
        exportRosterExcel(columnMap, exportRosterDtoList, file, tableExcelName, exportConfig);
        return downPath;
    }
}
