package com.bcxin.ars.service.sb.impl;

import com.bcxin.ars.dao.sb.*;
import com.bcxin.ars.model.BusinessCommon;
import com.bcxin.ars.model.sb.*;
import com.bcxin.ars.service.sb.BusinessService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.BusinessType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 审批业务公共方法
 * @author linqinglin
 * @date 2019/03/11 0011 10:27
 */
@Service
public class BusinessServiceImpl implements BusinessService {

    @Autowired
    private SponsorlicenseDao sponsorlicenseDao;

    /***
     * 保安服务子公司
     */
    @Autowired
    private SubsidiaryDao subsidiaryDao;
    /***
     * 保安员证
     */
    @Autowired
    private PersoncertificateDao personcertificateDao;
    /***
     *跨区域经营保安公司
     */
    @Autowired
    private CrosscompanyDao crosscompanyDao;
    /**
     * 培训服务
     */
    @Autowired
    private TraincompanyapplyDao traincompanyapplyDao;
    /***
     * 自行招用保安员单位
     */
    @Autowired
    private ConfesscompanyDao confesscompanyDao;
    /***
     * 自招备案撤销
     */
    @Autowired
    private ConfesscompanyundoDao confesscompanyundoDao;

    @Autowired
    private LegalchangeDao legalchangeDao;

    @Autowired
    private YearreportdataDAO yearreportdataDao;

    @Autowired
    private GradeSubsidyBatchDao gradeSubsidyBatchDao;

    @Autowired
    private TrainChangeDao trainChangeDao;

    @Autowired
    private TrainrecordDao trainrecordDao;

    @Autowired
    private PerCerGrantDao perCerGrantDao;

    /**
     * 枪支机构
     */
    @Autowired
    private ArmtrainorgDao armtrainorgDao;
    @Autowired
    private ConfigUtils configUtils;

    @Override
    public BusinessCommon findByBusinessTypeAndId(String businessType, Long businessId) {
        BusinessCommon businessCommon = null;
        if(StringUtil.isNotEmpty(businessType)){
            switch (businessType){
                case BusinessType.BAFWGS:
                    businessCommon = sponsorlicenseDao.findById(businessId);
                    businessCommon.setApprovalContent("【" + businessCommon.getCompanyname() + "】保安服务公司申报审批");
                    break;
                case BusinessType.PXDW:
                    businessCommon = traincompanyapplyDao.findById(businessId);
                    businessCommon.setApprovalContent("【" + businessCommon.getCompanyname() + "】培训单位申报审批");
                    break;
                case BusinessType.BAGSZGS:
                    businessCommon = subsidiaryDao.findById(businessId);
                    businessCommon.setApprovalContent("【" + businessCommon.getCompanyname() + "】保安服务公司子公司申报审批");
                    break;
                case BusinessType.BAYZ:
                    businessCommon = personcertificateDao.findById(businessId);
                    Personcertificate personcertificate = (Personcertificate)businessCommon;
                    businessCommon.setApprovalContent("【" + personcertificate.getName() + "】保安员证报名审批");
                    break;
                case BusinessType.KQYBAGS:
                    businessCommon = crosscompanyDao.findById(businessId);
                    businessCommon.setApprovalContent("【" + businessCommon.getCompanyname() + "】跨区域经营保安公司申报审批");
                    break;
                case BusinessType.ZXZY:
                    businessCommon = confesscompanyDao.findById(businessId);
                    businessCommon.setApprovalContent("【" + businessCommon.getCompanyname() + "】自行招用保安员单位申报审批");
                    break;
                case BusinessType.FRBG:
                    businessCommon = legalchangeDao.findById(businessId);
                    String title = "】保安服务（培训）许可证项目变更审批";
                    if(Constants.GUANGXI.equals(configUtils.getCurrentNative())){
                        title = "】保安服务许可证项目变更审批";
                    }
                    //如果公司名称没有变更，使用原公司名称
                    if(StringUtil.isEmpty(businessCommon.getCompanyname())){
                        Legalchange legalchange = (Legalchange)businessCommon;
                        businessCommon.setApprovalContent("【" + legalchange.getOldcompanyname() + title);
                    }else {
                        businessCommon.setApprovalContent("【" + businessCommon.getCompanyname() + title);
                    }
                    break;
                case BusinessType.NDBG:
                    businessCommon = yearreportdataDao.findById(businessId);
                    businessCommon.setApprovalContent("【" + businessCommon.getCompanyname() + "】年度报告审批");
                    break;
                case BusinessType.QZPX:
                    businessCommon = armtrainorgDao.findById(businessId);
                    Armtrainorg armtrainorg = (Armtrainorg)businessCommon;
                    businessCommon.setApprovalContent("【" + armtrainorg.getOrgname() + "】武装守护押运服务的保安员的枪支培训机构审批");
                    break;
                case BusinessType.ZZBACX:
                    businessCommon = confesscompanyundoDao.findById(businessId);
                    businessCommon.setApprovalContent("【" + businessCommon.getCompanyname() + "】自行招用保安员单位撤销备案审批");
                    break;
                case BusinessType.DJZBT:
                    businessCommon = gradeSubsidyBatchDao.findById(businessId);
                    GradeSubsidyBatch gradeSubsidyBatch = (GradeSubsidyBatch)businessCommon;
                    businessCommon.setApprovalContent("【" + gradeSubsidyBatch.getBatchName() + "】等级证补贴审批");
                    break;
                case BusinessType.ZGZBT:
                    businessCommon = gradeSubsidyBatchDao.findById(businessId);
                    GradeSubsidyBatch qualificationSubsidyBatch = (GradeSubsidyBatch)businessCommon;
                    businessCommon.setApprovalContent("【" + qualificationSubsidyBatch.getBatchName() + "】资格证补贴审批");
                    break;
                case BusinessType.PXDWXMBG:
                    businessCommon = trainChangeDao.findById(businessId);
                    TrainChange trainChange = (TrainChange)businessCommon;

                    //如果公司名称没有变更，使用原公司名称
                    if(StringUtil.isEmpty(businessCommon.getCompanyname())){
                        businessCommon.setApprovalContent("【" + trainChange.getOldcompanyname() + "】保安培训备案项目变更审批");
                    }else {
                        businessCommon.setApprovalContent("【" + businessCommon.getCompanyname() + "】保安培训备案项目变更审批");
                    }
                    break;
                case BusinessType.BAPXDWBA:
                    businessCommon = trainrecordDao.findById(businessId);
                    businessCommon.setApprovalContent("【" + businessCommon.getCompanyname() + "】保安培训单位备案审批");
                    break;
                case BusinessType.BAYZHF:
                    PerCerGrant perCerGrant = perCerGrantDao.findById(businessId);
                    businessCommon = perCerGrant;
                    businessCommon.setApprovalContent("【" + perCerGrant.getName() + "】保安员证核发审批");
                    break;
                default:
                    break;
            }
        }
        return businessCommon;
    }
}
