package com.bcxin.ars.service.pdf;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.message.HttpClientUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zjh
 * @date 2019年1月7日 16:12:00
 */
@Service
public class StampServiceImpl implements StampService {

    private Logger logger = LoggerFactory.getLogger(StampServiceImpl.class);
    @Autowired
    private ConfigUtils configUtils;

    @Override
    public String addStamp(String fileUrl, String type) throws ArsException {
        Map<String, Object> parm = new HashMap<String, Object>();
        String top = "";
        String left = "";

        String pfxPath = "D:\\stamp.pfx";
        String xmlPath = "D:\\stamp.xml";
       logger.debug("签章开始：文件地址" + fileUrl);
        Config pfxPathconfig = configUtils.getConfigByKey(Constants.STAMP_KEY_URL);
        if (pfxPathconfig != null && pfxPathconfig.getValue() != null) {
            pfxPath = pfxPathconfig.getValue();
        } else {
            throw new ArsException("没有配置签章pfx地址");
        }
        Config xmlPathconfig = configUtils.getConfigByKey(Constants.STAMP_XML_URL);
        if (xmlPathconfig != null && xmlPathconfig.getValue() != null) {
            xmlPath = xmlPathconfig.getValue();
        } else {
            throw new ArsException("没有配置签章xml地址");
        }

        String pdfPath = fileUrl;
        if ("1".equals(type)) {
            left = "700";
            top = "420";//420
        } else if ("2".equals(type)) {
            left = "160";
            top = "235";
        }
        String xml = Constants.STAMP_XML.replace("{pfxPath}", pfxPath)
                .replace("{xmlPath}", xmlPath)
                .replace("{pdfPath}", pdfPath)
                .replace("{left}", left)
                .replace("{top}", top);

        // 获取签章地址stampURL
        String url;

        Config config = configUtils.getConfigByKey(Constants.STAMP_URL);
        if (config != null && config.getValue() != null) {
            url = config.getValue();
        } else {
            throw new ArsException("没有配置签章地址");
        }
       logger.debug("签章内容：" + xml);
       logger.debug("签章地址：" + url);
        JSONObject returnMessage = HttpClientUtil.post(url, xml);
       logger.debug("签章访问结束，返回数据：" + returnMessage);
        if (returnMessage.get("signResult") != null) {
            if ("1".equals(returnMessage.get("signResult").toString())) {
                return "签章成功";
            } else {
                return "签章失败";
            }
        }else {
            return "返回失败";
        }


    }


}
