package com.bcxin.ars.service.msg.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.msg.NewsnoticeCompanyDao;
import com.bcxin.ars.dao.msg.NewsnoticePoliceDao;
import com.bcxin.ars.dao.msg.SysAttachmentDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.msg.NewsnoticeCompanySearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.msg.NewsnoticeCompany;
import com.bcxin.ars.model.msg.NewsnoticePolice;
import com.bcxin.ars.model.msg.SysAttachment;
import com.bcxin.ars.service.msg.NewsnoticeCompanyService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
@Transactional
@DataSyncAnnotation(getClazz = NewsnoticeCompany.class)
@DataSyncOutAnnotation(getClazz = NewsnoticeCompany.class,getMethodName="saveOrUpdateForImport",getImportType = ImportType.FOREACH)
public class NewsnoticeCompanyServiceImpl implements NewsnoticeCompanyService {

	/**
	 * 日志
	 */
	public static final Logger logger = LoggerFactory.getLogger(NewsnoticeCompanyServiceImpl.class);

    @Autowired
    private NewsnoticePoliceDao newsnoticePoliceDao;
    @Autowired
    private SysAttachmentDao sysAttachmentDao;
	@Autowired
	private NewsnoticeCompanyDao newsnoticeCompanyDao;
	@Autowired
	private ArsUtil arsUtil;
	@Autowired
	private SecurityCompanyDao securityCompanyDao;
	/**
	 * 查询
	 * @param dto
	 * @return
	 */
	@Override
	public NewsnoticeCompanySearchDto search(NewsnoticeCompanySearchDto dto) {
		NewsnoticeCompanySearchDto resultDto = new NewsnoticeCompanySearchDto();
		List<NewsnoticeCompany> list =  newsnoticeCompanyDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(newsnoticeCompanyDao.searchCount(dto));
		return resultDto;
	}

	@Override
	public PageResult searchNewsnoticeCompanyList_table(Map<Object, Object> p) {
		return new PageResult(newsnoticeCompanyDao.countNewsnoticeCompanyList(p), newsnoticeCompanyDao.searchNewsnoticeCompanyList(p));
	}

    @Override
    public PageResult searchNewsnoticeCompanyReplyListForPolice(Map<Object, Object> p) {
        return new PageResult(newsnoticeCompanyDao.countNewsnoticeCompanyReplyList(p), newsnoticeCompanyDao.searchNewsnoticeCompanyReplyList(p));
    }
    @Override
    public PageResult searchNewsnoticeCompanyReplyListForCompany(Map<Object, Object> p) {
        return new PageResult(newsnoticeCompanyDao.countNewsnoticeCompanyReplyCompanyList(p), newsnoticeCompanyDao.searchNewsnoticeCompanyReplyCompanyList(p));
    }
    @Override
	public void updateReadstateByidArr(Long[] idArray) {
		User user = arsUtil.getCurrentUser();
		if(user == null){
			throw  new ArsException("用户信息不存在");
		}
		//获取公司信息
		SecurityCompany company  = securityCompanyDao.findByUserid(user.getId());
		//获取消息列表
		List<NewsnoticePolice> listIds = newsnoticePoliceDao.findBatchForMessageIdSaaS(idArray);
		//判断数据是否为空 TODO
		if(listIds==null || listIds.size()==0){
			return;
		}
		Long[] newIds = new Long[listIds.size()];
		int i=0;
		for (NewsnoticePolice np: listIds) {
			newIds[i++]=np.getId();
		}
		//更新
		newsnoticeCompanyDao.updateReadstateByidArr(newIds,company.getId());
		//阅读数量的数量+1 未阅读数-1
		newsnoticePoliceDao.batchUpdateByCompanyId(newIds,company.getId());
	}

    @Override
    public void updateReadstateByIdForPolice(Long[] idArray) {
        User user = arsUtil.getCurrentUser();
        if(user == null){
            throw  new ArsException("用户信息不存在");
        }
		if(Constants.PLATFORM_POLICE == user.getPlatform()){
			//更新
			newsnoticeCompanyDao.updateReadstateByidArr(idArray,user.getId());
			//阅读数量的数量+1 未阅读数-1
			newsnoticePoliceDao.batchUpdateByCompanyId(idArray,user.getId());
		}else{
			//获取公司信息
			SecurityCompany company  = securityCompanyDao.findByUserid(user.getId());
			//更新
			newsnoticeCompanyDao.updateReadstateByidArr(idArray,company.getId());
			//阅读数量的数量+1 未阅读数-1
			newsnoticePoliceDao.batchUpdateByCompanyId(idArray,company.getId());
		}
    }
	@Override
	public List<NewsnoticeCompany> findUnread() {
		return newsnoticeCompanyDao.findUnread();
	}

	@Override
	public int countUnread() {
        User user = arsUtil.getCurrentUser();
        if(user == null){
            throw  new ArsException("用户信息不存在");
        }
		return newsnoticeCompanyDao.countUnread(user.getId());
	}

	@Override
	public void updateReaded(NewsnoticeCompanySearchDto newsnoticeCompany) {
		User user = arsUtil.getCurrentUser();
		//如果为未读想未读状态修改为已读
		User currentUser = arsUtil.getCurrentUser();
		newsnoticeCompany.setUpdateTime(new Date());
		newsnoticeCompany.setUpdateBy(currentUser.getUsername());
		newsnoticeCompany.setUpdateflag(true);
		newsnoticeCompanyDao.updateReaded(newsnoticeCompany);
		//阅读数量的数量+1 未阅读数-1
		newsnoticePoliceDao.batchUpdate(newsnoticeCompany);

	}

	@Override
	public NewsnoticeCompany findById(Long id) {
        User user = arsUtil.getCurrentUser();

	    NewsnoticeCompany newsnoticeCompany = newsnoticeCompanyDao.findById(id);
	    //如果为未读想未读状态修改为已读
        if (newsnoticeCompany!=null && StringUtil.equals(newsnoticeCompany.getReadstate(), Constants.READSTATUS_UNREAD)){
            newsnoticeCompany.setUpdateBy(user.getUsername());
            newsnoticeCompany.setUpdateTime(new Date());
            newsnoticeCompany.setReadstate(Constants.READSTATUS_READ);
			newsnoticeCompany.setUpdateflag(true);
            newsnoticeCompanyDao.update(newsnoticeCompany);
            if(newsnoticeCompany.getNewsnoticeid() != null){
                //将改通知的阅读数量的数量+1 未阅读数-1
                NewsnoticePolice newsnoticePolice = newsnoticePoliceDao.findById(Long.valueOf(newsnoticeCompany.getNewsnoticeid()));
                newsnoticePolice.setReadnum(newsnoticePolice.getReadnum()+1);
                newsnoticePolice.setUpdateTime(new Date());
                newsnoticePolice.setUpdateflag(true);
                newsnoticePolice.setUnreadnum(newsnoticePolice.getUnreadnum()-1);
                newsnoticePoliceDao.update(newsnoticePolice);
            }
        }
		return newsnoticeCompany;
	}

	@Override
	public List<NewsnoticeCompany> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return newsnoticeCompanyDao.searchForDataSynchronization(searchDto);
	}

	/**
	 * @Author: wangcy
	 * @Description:内网同步数据
	 * @Date: 2018/03/08 0008 15:00
	 */
	@Override
	public void saveOrUpdateForDS(NewsnoticeCompany newsnoticeCompany) {
		newsnoticeCompany.setUpdateflag(false);
		if(newsnoticeCompany.getActive() == null){
			newsnoticeCompany.setActive(true);
		}
		//和数据进行比较有就更新无就创建
		NewsnoticeCompany dbnewsnoticeCompany = newsnoticeCompanyDao.findById(newsnoticeCompany.getId());
		if (dbnewsnoticeCompany != null) {
			if(dbnewsnoticeCompany.getActive() != newsnoticeCompany.getActive()){
				newsnoticeCompany.setActive(dbnewsnoticeCompany.getActive());
				if(dbnewsnoticeCompany.getUpdateflag()){
					newsnoticeCompany.setUpdateflag(true);
				}
				newsnoticeCompanyDao.updateForDS(newsnoticeCompany);
			}else if(newsnoticeCompany.getUpdateTime().getTime() > dbnewsnoticeCompany.getUpdateTime().getTime()){
				newsnoticeCompanyDao.updateForDS(newsnoticeCompany);
			}
		} else {
			newsnoticeCompanyDao.saveForDS(newsnoticeCompany);
		}
	}

	@Override
	public List<NewsnoticeCompany> findDSOutList(String startDate) {
		return newsnoticeCompanyDao.searchFromInToOutForExport(startDate);
	}

	@Override
	public void saveOrUpdateForImport(NewsnoticeCompany newsnoticeCompany) {
		try {
			newsnoticeCompany.setUpdateflag(false);
			NewsnoticeCompany dbNewsnoticeCompany = newsnoticeCompanyDao.findById(newsnoticeCompany.getId());
			//外网没有消息
			if(dbNewsnoticeCompany == null){
				newsnoticeCompany.setUpdateTime(DateUtil.dateAdd2(DateUtil.DATATYPE_SECOND, newsnoticeCompany.getUpdateTime(), 1));
				newsnoticeCompanyDao.saveForDS(newsnoticeCompany);
			}else{
				//删除
				if(!dbNewsnoticeCompany.getActive().equals(newsnoticeCompany.getActive())){
					//时间上加1秒
					dbNewsnoticeCompany.setUpdateTime(new Date());
					dbNewsnoticeCompany.setActive(newsnoticeCompany.getActive());
					//有删除或撤消设置为最新
					dbNewsnoticeCompany.setUpdateTime(new Date());
					newsnoticeCompanyDao.updateForDS(dbNewsnoticeCompany);
				}else if(newsnoticeCompany.getUpdateTime().getTime() > dbNewsnoticeCompany.getUpdateTime().getTime() || (StringUtil.isNotEmpty(dbNewsnoticeCompany.getUndoState()) && !dbNewsnoticeCompany.getUndoState().equals(newsnoticeCompany.getUndoState()))){
					newsnoticeCompany.setUpdateTime(DateUtil.dateAdd2(DateUtil.DATATYPE_SECOND, newsnoticeCompany.getUpdateTime(), 1));
                    //已读状态以外网为主 edit subh
                    newsnoticeCompany.setReadstate(dbNewsnoticeCompany.getReadstate());
					newsnoticeCompanyDao.updateForDS(newsnoticeCompany);
				}
			}
		} catch (Exception e) {
			logger.error(e.getMessage(),e);
		}
	}

    @Override
    public void saveOrUpdate(NewsnoticeCompany newsnoticeCompany) {
        User currentUser = arsUtil.getCurrentUser();
        //获取数据库
        NewsnoticeCompany dbNewsnoticeCompany =newsnoticeCompanyDao.findById(newsnoticeCompany.getId());
        //复制值
        BeanUtils.copyPropertiesIgnore(newsnoticeCompany,dbNewsnoticeCompany,true);
        newsnoticeCompanyDao.update(dbNewsnoticeCompany);
        /****
         * 保存附件
         */
        if (newsnoticeCompany.getSysAttachmentIds() != null && newsnoticeCompany.getSysAttachmentIds().length > 0) {
            SysAttachment dbSysAttachment = null;
            for (Long sysAttachmentId : newsnoticeCompany.getSysAttachmentIds()) {
                dbSysAttachment = sysAttachmentDao.findById(sysAttachmentId);
                dbSysAttachment.setBusinessid(newsnoticeCompany.getId());
                dbSysAttachment.setBusinesstype(Constants.FILE_BUSINESSTYPE_REPLY);
                dbSysAttachment.setUpdateBy(currentUser.getUsername());
                dbSysAttachment.setUpdateTime(new Date());
                dbSysAttachment.setUpdateflag(true);
                sysAttachmentDao.update(dbSysAttachment);
            }
        }
    }

	@Override
	public void searchForPage(NewsnoticeCompanySearchDto dto, AjaxPageResponse<NewsnoticeCompany> page) {


		arsUtil.setPoliceSearch(dto);
		newsnoticeCompanyDao.searchForPage(dto,page);
	}

}


