package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dto.page.ConfigPageSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.*;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Service
@Transactional
public class ConfigServiceImpl implements ConfigService{

	@Autowired
	private ConfigDao configDao;

	@Autowired
	private ConfigUtils configUtils;

	@Autowired
	private ArsUtil arsUtil;

	@Override
	public List<Config> findAll() {
		return configDao.findAll();
	}

	@Override
	public Config findByKey(String key) {
		return configDao.findByKey(key);
	}

	@Override
	public Config getConfigByKey(String key) {
		return configUtils.getConfigByKey(key);
	}

	@Override
	public String getValueByKey(String key) {
		Config config = configUtils.getConfigByKey(key);
		if(config != null){
			return config.getValue();
		}
		return StringUtil.EMPTY;
	}

	@Override
	public Config findByKeyAndName(String key,String name) {
		return configDao.findByKeyAndName(key,name);
	}

	@Override
	public void update(Config config) {
		configDao.update(config);
	}

	@Override
	public List<Config> findByLikeKey(String key) {
		return configDao.findByLikeKey(key);
	}

	/**
	 * 获取内网最后同步时间导到外网
	 * @param startDate 开始日期
	 * @return
	 */
	@Override
	public List<Config> findDSOutList(String startDate){
		List<Config> list = new ArrayList<>();
		Config config = configDao.findByKey(Constants.LASTDATE);
		config.setUpdateTime(new Date());
		list.add(config);
		return list;
	}

	/**
	 * 获取内网最后同步时间,与当前时间比对，判断同步是否异常
	 * @param list
	 */
	@Override
	public void importBatch(List<Config> list){
		Config receiveUserConfig = configUtils.getConfigByKey(Constants.DATASYNC_RECEIVEUSER);
		Config currentNativeName = configUtils.getConfigByKey(Constants.CURRENT_NATIVE_NAME);
		if(receiveUserConfig != null && currentNativeName != null) {
			list.forEach(config -> {
				if (Constants.LASTDATE.equals(config.getKey())) {
					String lastDate = config.getValue();
					Calendar calendar = Calendar.getInstance();
					calendar.setTime(config.getUpdateTime());

					if (!DateUtil.getCurrentDate().equals(lastDate) && calendar.get(Calendar.HOUR_OF_DAY) >3) {
						new Thread(()->{
							String sendHtml = Constants.DATASYNC_SENDHTML_LASTDATE.replace("{lastDate}", lastDate)
									.replace("{updateTime}", DateUtil.convertDateToString(config.getUpdateTime(), DateUtil.FORMAT1))
									.replace("{currentNativeName}", currentNativeName.getValue())
									.replace("url",configUtils.getWebHost());

							String receiveUser = receiveUserConfig.getValue();
							EmailUtils emailUtil = new EmailUtils();
							emailUtil.sendEmail(Constants.DATASYNC_SUBJECT, sendHtml, receiveUser);
						}).start();
					}
				}
			});
		}
	}


	@Override
	public void delete(Config config) {
		User currentUser = arsUtil.getCurrentUser();
		config.setUpdateTime(new Date());
		config.setUpdateBy(currentUser.getUsername());
		configDao.delete(config);
	}

	@Override
	public void save(Config config) {
		User currentUser = arsUtil.getCurrentUser();
		Config checkConfig = configUtils.getConfigByKey(config.getKey());
		if(checkConfig != null && !checkConfig.getId().equals(config.getId())){
			throw new ArsException("该配置已存在！");
		}
		if(config.getId() == null){
			config.setCreateTime(new Date());
		}else{
			Config dbConfig = configDao.findById(config.getId());
			BeanUtils.copyPropertiesIgnore(config,dbConfig,true);
			BeanUtils.copyPropertiesIgnore(dbConfig,config,false);
		}

		config.setActive(true);
		config.setUpdateBy(currentUser.getUsername());
		config.setUpdateTime(new Date());
		config.setUpdateflag(true);
		config.setAreaCode(currentUser.getPolice().getAreacode());
		configDao.save(config);
	}

	@Override
	public Config findById(Long id) {
		return configDao.findById(id);
	}

	@Override
	public void use(Config config) {
		User currentUser = arsUtil.getCurrentUser();
		config.setUpdateTime(new Date());
		config.setUpdateBy(currentUser.getUsername());
		configDao.use(config);
	}

	@Override
	public void searchForPage(ConfigPageSearchDto dto, AjaxPageResponse page) {
		configDao.searchForPage(dto,page);
	}
}
