package com.bcxin.ars.service.enums.impl;

import com.bcxin.ars.model.sys.ExportColumn;
import org.springframework.util.StringUtils;
import java.util.List;
import java.util.Map;

/**
 * 对指定字段求和
 */

public class SumFileNameExportRoster implements ExportFormula {
    /**
     * 对某列求和
     * @param exportRosterDtoList 数据Map集
     * @param exportColumn  字段来源，日期格式，码表类型
     * @param cellValue
     * @return
     */
    @Override
    public String getFormulaValue(List<Map<String,String>> exportRosterDtoList, ExportColumn exportColumn, String cellValue) {
        int sum = 0;
        for (Map<String, String> map : exportRosterDtoList) {
            if(StringUtils.isEmpty(Integer.parseInt(map.get(exportColumn.getColumnValueSource())))){
                continue;
            }else {
                sum = sum +Integer.parseInt(map.get(exportColumn.getColumnValueSource()));
            }
        }
        return sum+"";
    }
}
