package com.bcxin.ars.service.certificate.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.ProjectChangeDao;
import com.bcxin.ars.dao.certificate.TrainCertificateDao;
import com.bcxin.ars.dao.certificate.TrainCertificateSnapshotDao;
import com.bcxin.ars.dao.sb.LegalchangeDao;
import com.bcxin.ars.dao.sb.LegalchangeDaoAop;
import com.bcxin.ars.dao.sb.TraincompanyapplyDao;
import com.bcxin.ars.dao.sb.TraincompanyapplyDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dao.sys.SyscodeDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.certificate.TrainCertificateSearchDto;
import com.bcxin.ars.dto.sys.PdfFormDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.certificate.TrainCertificate;
import com.bcxin.ars.model.certificate.TrainCertificateSnapshot;
import com.bcxin.ars.model.sb.Legalchange;
import com.bcxin.ars.model.sb.Traincompanyapply;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.Syscode;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.certificate.TrainCertificateService;
import com.bcxin.ars.service.sb.CreatePDFService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.approval.BusinessType;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = TrainCertificate.class,getImportType = ImportType.BATCH,getMethodName = "importBatch")
@DataSyncOutAnnotation(getClazz = TrainCertificate.class,getImportType = ImportType.BATCH)
public class TrainCertificateServiceImpl implements TrainCertificateService {
	/***
	 * 日志
	 */
	private Logger logger = LoggerFactory.getLogger(TrainCertificateServiceImpl.class);
	@Autowired
	private TrainCertificateDao trainCertificateDao;

	@Autowired
	private TraincompanyapplyDao traincompanyapplyDao;

	@Autowired
	private TraincompanyapplyDaoAop traincompanyapplyDaoAop;
	/***
	 * 审批
	 */
	@Autowired
	private ApprovalDAO approvalDAO;

	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private ConfigDao configDao;
	@Autowired
	private ConfigUtils configUtils;

	@Autowired
	private PoliceDao policeDao;

	@Autowired
	private SyscodeDAO syscodeDAO;
	@Value("${temp-folder}")
	private String tempFolder;
	@Autowired
	private ProjectChangeDao projectChangeDao;

	@Autowired
	private CreatePDFService createPDFService;
	@Autowired
	private LegalchangeDao legalchangeDao;
	@Autowired
	private LegalchangeDaoAop legalchangeDaoAop;

	@Autowired
	private SecurityCompanyService securityCompanyService;
	@Autowired
	private IdWorker idWorker;
	@Autowired
	private TrainCertificateSnapshotDao trainCertificateSnapshotDao;
	/**
	 * 查询
	 * @param dto
	 * @return
	 */
	@Override
	public TrainCertificateSearchDto search(TrainCertificateSearchDto dto) {
		//只查询申请
		dto.setApplytype(Constants.TYPE_APPLY);

		TrainCertificateSearchDto resultDto = new TrainCertificateSearchDto();
		List<TrainCertificate> list =  trainCertificateDao.searchV1(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(trainCertificateDao.count(dto));
		return resultDto;
	}

	/**
	 * 保存或更新
	 * @param trainCertificate
	 */
	@Override
	public void saveOrUpdate(TrainCertificate trainCertificate) {
        User user = arsUtil.getCurrentUser();

		Traincompanyapply traincompanyapply = null;
		if(trainCertificate.getTraincompanyapplyid() != null) {
			traincompanyapply = traincompanyapplyDao.findById(trainCertificate.getTraincompanyapplyid());
			trainCertificate.setOrgId(traincompanyapply.getOrgid());
			trainCertificate.setAreaCode(traincompanyapply.getDistrict());
		}

		Syscode syscode = null;
		//判断是否存在，如果存在则为更新否则为保存
		TrainCertificate dbTrainCertificate = trainCertificateDao.findById(trainCertificate.getId());
		if(dbTrainCertificate != null) {//复制值
			BeanUtils.copyPropertiesIgnore(trainCertificate,dbTrainCertificate,true);

			//设置修改时间
			dbTrainCertificate.setUpdateTime(new Date());
			//设置修改者
			dbTrainCertificate.setUpdateBy(user.getRealname());

			//线上打印数据标识
			dbTrainCertificate.setPrinttype(Constants.PRINT_TYPE_ONLINE_YES);

			//类型为申请
			dbTrainCertificate.setApplytype(Constants.TYPE_APPLY);
			//更新标识
			dbTrainCertificate.setUpdateflag(true);

			if(StringUtil.isEmpty(dbTrainCertificate.getAreaCode())){
				dbTrainCertificate.setOrgId(user.getOrgid());
				dbTrainCertificate.setAreaCode(user.getPolice().getAreaCode());
			}

			trainCertificateDao.update(dbTrainCertificate);
		}else{

			//修改时间，创建时间在保存的时候一样
			trainCertificate.setCreateTime(new Date());
			trainCertificate.setUpdateTime(trainCertificate.getCreateTime());
			//默认可用
			trainCertificate.setActive(true);
			trainCertificate.setUpdateBy(user.getUsername());
			//受理人为当前用户，2018年5月28日 13:46:53 ，修改bug 【保安培训机构许可证】内网公安，受理人和受理人手机号显示为空
			trainCertificate.setSlr(user.getRealname());
			trainCertificate.setSlrsj(user.getPhone());
			//受理人为当前用户，2018年5月28日 13:46:53 ，修改bug 【保安培训机构许可证】内网公安，受理人和受理人手机号显示为空,开始时间 2018年5月28日 13:52:29
			trainCertificate.setSlr(user.getRealname());
			trainCertificate.setSlrsj(user.getPhone());
			//TODO
			//许可证编号规则：第一个字为省、自治区、直辖市简称，后面八位数字中，前四位是发证年份，后四位是发证顺序号，从0001开始。
			SimpleDateFormat simpleDateFormat;
			simpleDateFormat = new SimpleDateFormat("yyyy");
			Date date = new Date();
			//2018年10月12日13:38:07 wjb 从配置表中读取XXX公保培
			syscode = syscodeDAO.selectByPrimaryKey("PXXKZH",user.getCityAreaCode());
			String year="";
			/*
			Config config =configDao.findByKeyAndName("current_native_short","当前系统省份简称");
			if(config!=null&& config.getValue() != null){
				 year = config.getValue() + simpleDateFormat.format(date);
			}*/
			if(syscode!=null&& syscode.getCodename() != null){
				year = syscode.getCodename() + simpleDateFormat.format(date);
			}

			TrainCertificateSearchDto searchdto = new TrainCertificateSearchDto();
			searchdto.setXkzh(year);
			String maxXkzh_year = trainCertificateDao.searchMaxXkzhCount(searchdto);
			if (StringUtils.isEmpty(maxXkzh_year)) {
				maxXkzh_year = year + "0001";
			} else {
				maxXkzh_year = maxXkzh_year.substring(0, maxXkzh_year.length()-8)
						+ String.valueOf((Long.valueOf(maxXkzh_year.substring(maxXkzh_year.length()-8)) + 1));
			}
			trainCertificate.setXkzh(maxXkzh_year);

			//线上打印数据标识
			trainCertificate.setPrinttype(Constants.PRINT_TYPE_ONLINE_YES);
			trainCertificate.setHasOld(Constants.PRINT_TYPE_OLD_NO);
			//更新标识
			trainCertificate.setUpdateflag(true);
			//类型为申请
			trainCertificate.setApplytype(Constants.TYPE_APPLY);


			if(StringUtil.isEmpty(trainCertificate.getAreaCode())){
				trainCertificate.setOrgId(user.getOrgid());
				trainCertificate.setAreaCode(user.getPolice().getAreaCode());
			}

			trainCertificateDao.save(trainCertificate);

			//生成pdf文档
			PdfFormDto pdfFormDto = new PdfFormDto();
			pdfFormDto.setBusinesstype(BusinessType.PXDW);
			pdfFormDto.setBusinessid(trainCertificate.getId());
			try {
				createPDFService.createPDF(pdfFormDto);
			} catch (Exception e) {
				new ArsException("生成证书pdf失败");
			}
		}


		/***
		 * 如果录入证书，状态改成已制证
		 */
		if(traincompanyapply!=null) {
			traincompanyapply.setCardState(Constants.CARD_STATE_YZZ);
			traincompanyapply.setUpdateTime(new Date());
			traincompanyapply.setUpdateBy(user.getUsername());
			traincompanyapplyDaoAop.update(traincompanyapply);


			Config configVersion = configDao.findByKey(Constants.APPROVAL_VERSION_SWITCH);
			//2018年6月13日15:30:56 如果是新审批生成账号
			if (configVersion != null && Constants.APPROVAL_VERSION_NEW.equals(configVersion.getValue())) {
				User newUser = new User();
				newUser.setInit(false);
				newUser.setRealname(traincompanyapply.getTraincompanyname());
				newUser.setPhone(traincompanyapply.getTrainphone());
				//保安公司或培训单位
				newUser.setPlatform(Constants.PLATFORM_COMPANY);

				SecurityCompany newCompany = new SecurityCompany();

				newCompany.setName(traincompanyapply.getTraincompanyname());
				newCompany.setLegalPerson(traincompanyapply.getTrainlegalname());
				newCompany.setLegalPersonNo(traincompanyapply.getTraincreditcode());
				newCompany.setLocation(traincompanyapply.getTrainaddress());
				newCompany.setPublicSecurityLicenseNumber(trainCertificate.getXkzh().replace(syscode.getCodename(), ""));

				Approval approval = approvalDAO.findBybusinessidAndType(traincompanyapply.getId(), BusinessType.PXDW);
				if (null != approval) {
					newCompany.setAreaCode(approval.getAreaCode());
				}

				newCompany.setUser(newUser);
				newCompany.setInstitutionType(Constants.BKT_ORGTYPE_JG);
				newCompany.setUpdateflag(true);

				newCompany.setOrgId(traincompanyapply.getOrgid().toString());
				Police police = policeDao.findById(traincompanyapply.getOrgid());
				newCompany.setOrgName(policeDao.findOrgNameByOrgIds(police.getPath().split("/")));
					//发证日期
				newCompany.setGiveLicenseDate(trainCertificate.getFzrq());
				//发证机构名称
				newCompany.setGiveLicenseName(trainCertificate.getFzjgmc());
				securityCompanyService.updateCompany(newCompany);
			}
		}
	}

	/**
	 * 保存或更新
	 * @param trainCertificate
	 */
	@Override
	public void saveOrUpdateForLegalchange(TrainCertificate trainCertificate) {

		//项目变更信息
		Legalchange legalchange = legalchangeDao.findById(trainCertificate.getLegalchangeId());
		//公司信息
		SecurityCompany securityCompany = securityCompanyService.findById(legalchange.getCompanyid());
		User user = arsUtil.getCurrentUser();
		//修改时间，创建时间在保存的时候一样
		trainCertificate.setCreateTime(new Date());
		trainCertificate.setUpdateTime(trainCertificate.getCreateTime());
		//默认可用
		trainCertificate.setActive(true);
		trainCertificate.setUpdateBy(user.getUsername());
		//受理人为当前用户，2018年5月28日 13:46:53 ，修改bug 【保安培训机构许可证】内网公安，受理人和受理人手机号显示为空
		trainCertificate.setSlr(user.getRealname());
		trainCertificate.setSlrsj(user.getPhone());
		//受理人为当前用户，2018年5月28日 13:46:53 ，修改bug 【保安培训机构许可证】内网公安，受理人和受理人手机号显示为空,开始时间 2018年5月28日 13:52:29
		trainCertificate.setSlr(user.getRealname());
		//手机号码
		trainCertificate.setSlrsj(user.getPhone());
		//2018年10月12日13:38:07 wjb 从配置表中读取XXX公保培
		Syscode syscode = syscodeDAO.selectByPrimaryKey("PXXKZH",user.getCityAreaCode());
		//原许可证号
		if(syscode!=null&& syscode.getCodename() != null){
			trainCertificate.setXkzh(syscode.getCodename()+securityCompany.getPublicSecurityLicenseNumber());
		}
		/**
		 * 公司ID
		 */
		trainCertificate.setCompanyid(securityCompany.getId());
		//培训内容 TODO

		//线上打印数据标识
		trainCertificate.setPrinttype(Constants.PRINT_TYPE_ONLINE_YES);
		//类型为变更
		trainCertificate.setApplytype(Constants.TYPE_CHANGER);

		//更新标记
		trainCertificate.setUpdateflag(true);
		trainCertificate.setAreaCode(legalchange.getDistrict());
		trainCertificate.setOrgId(legalchange.getOrgid());
		trainCertificateDao.save(trainCertificate);

		//保存变更记载
		/*
		*
		* CONCAT(IF(ISNULL(securityScopes),'','服务范围变更,'),
		* IF(ISNULL(a.companyname),'','公司名称变更,'),
		* IF(ISNULL(address),'','地址变更,'),
		* IF(ISNULL(legalname),'','法人变更,'),
		* IF(ISNULL(bgregisteredMoney),'','注册资金变更,'))
		*
		* */
		//先删除原有的
		projectChangeDao.deleteByCidAndType(trainCertificate.getId().toString(),BusinessType.PXDW);
		//更新项目变更
		if(StringUtil.isNotEmpty(legalchange.getSecurityScopes())) {
			insertProject(Constants.CHANGE_FWFW,legalchange.getSecurityScopes(),trainCertificate.getId());
		}
		//公司名称变更
		if(StringUtil.isNotEmpty(legalchange.getCompanyname())) {
			insertProject(Constants.CHANGE_NAME,legalchange.getCompanyname(),trainCertificate.getId());
		}

		//地址变更
		if(StringUtil.isNotEmpty(legalchange.getAddress())) {
			insertProject(Constants.CHANGE_ADDRESS,legalchange.getAddress(),trainCertificate.getId());
		}

		//地址变更
		if(StringUtil.isNotEmpty(legalchange.getLegalname())) {
			insertProject(Constants.CHANGE_LEGALNAME,legalchange.getLegalname(),trainCertificate.getId());
		}
		//注册资金变更
		if(legalchange.getBgregisteredMoney()!=null) {
			insertProject(Constants.CHANGE_ZJ,legalchange.getBgregisteredMoney().toString(),trainCertificate.getId());
		}

		//生成pdf文档
		PdfFormDto pdfFormDto = new PdfFormDto();
		pdfFormDto.setBusinesstype(BusinessType.PXDW);
		pdfFormDto.setBusinessid(trainCertificate.getId());
		try {
			createPDFService.createPDF(pdfFormDto);
		} catch (Exception e) {
			new ArsException("生成证书pdf失败");
		}

		//项目变更信息，更新制证状态
		legalchange.setCardState(Constants.CARDSTATE_YES);
		legalchangeDaoAop.update(legalchange);

		//更新下一级审批人
		Approval approval = approvalDAO.findBybusinessidAndType(legalchange.getId(),BusinessType.FRBG);
		if(approval!=null){
			approval.setNextPerson(null);
			approvalDAO.update(approval);
		}
	}

	/***
	 * 插入变更项目
	 * @param projectname  项目名称
	 * @param projectcontent 项目内容
	 * @param trainCertificateId 证书ID
	 */
	public void insertProject(String projectname,String projectcontent,Long trainCertificateId){
		//当前用户信息
		User currentUser = arsUtil.getCurrentUser();
		ProjectChange projectChange = new ProjectChange();
		projectChange.setActive(true);
		projectChange.setCreateTime(new Date());
		projectChange.setUpdateTime(new Date());
		projectChange.setUpdateBy(currentUser.getUsername());
		projectChange.setCertificateId(trainCertificateId);
		projectChange.setType(BusinessType.PXDW);
		projectChange.setProjectname(projectname);
		projectChange.setProjectcontent(projectcontent);
		projectChange.setProjecttime(DateUtil.convertDateToString(new Date(),DateUtil.FORMAT2));
		projectChangeDao.save(projectChange);


	}
	/**
	 * 删除
	 * @param trainCertificate
	 */

	@Override
	public void delete(TrainCertificate trainCertificate) {
		trainCertificate.setUpdateTime(new Date());
		trainCertificateDao.delete(trainCertificate);
	}

	@Override
	public TrainCertificate findById(long id){
		return findById(id,Constants.CERPRINTTYPE_Z);
	}

	@Override
	public TrainCertificate findById(long id,String type){
		//培训信息
		TrainCertificate trainCertificate = trainCertificateDao.findById(id);
		//判断数据库是否有记录
		if(trainCertificate!=null) {
			//生成二维码
			try {
				String cerUrl = configUtils.getValueByKey("PERCERURL"+configUtils.getCurrentProvince());
				String pathName = QRCodeUtil.generateQRCode(cerUrl + Constants.CERTIFICATETRAIN_MOBILE + id + ".do?type="+type, 100, 100, "jpg", tempFolder + "qrcode.jpg");
				trainCertificate.setQrcode(Base64Img.GetImageStr(pathName, "jpg"));
			} catch (Exception e) {
				logger.error(e.getMessage(), e);
			}
		}
		return trainCertificate;
	}

	/**
	 * 培训公司快照保存
	 * @param id
	 * @param type
	 * @return
	 */
	@Override
	public TrainCertificate findByIdV2(long id,String type){
		User currentUser = arsUtil.getCurrentUser();
		Long qrCodeId = idWorker.nextId();
		//培训信息
		TrainCertificate trainCertificate = trainCertificateDao.findById(id);
		//判断数据库是否有记录
		if(trainCertificate!=null) {
			//生成二维码
			try {
				//将证书信息保存到数据库中
				TrainCertificateSnapshot trainCertificateSnapshot = new TrainCertificateSnapshot();
				trainCertificateSnapshot.setQrCodeId(qrCodeId);
				BeanUtils.copyPropertiesIgnore(trainCertificate,trainCertificateSnapshot,true);
				trainCertificateSnapshot.setCreateTime(new Date());
				trainCertificateSnapshot.setUpdateTime(new Date());
				trainCertificateSnapshot.setCreateBy(currentUser.getUsername());
				if(trainCertificateSnapshotDao.save(trainCertificateSnapshot)<=0) {
					logger.error("保安服务公司保存快照出错！");
				}
				String cerUrl = configUtils.getValueByKey("PERCERURL"+configUtils.getCurrentProvince());
				String pathName = QRCodeUtil.generateQRCode(cerUrl + Constants.MOBILE_TRAINCERTIFICATE + qrCodeId + ".do?type="+type, 100, 100, "jpg", tempFolder + "qrcode.jpg");
				trainCertificate.setQrcode(Base64Img.GetImageStr(pathName, "jpg"));
			} catch (Exception e) {
				logger.error(e.getMessage(), e);
			}
		}
		return trainCertificate;
	}


	/**
	 *根据ID查询
	 * @param companyId
	 */
	@Override
	public TrainCertificate findByCompanyId(long companyId){
		return trainCertificateDao.findByCompanyId(companyId);
	}


	/**
	 * 分页查询
	 * @param dto
	 * @param page
	 * @return
	 */
	@Override
	public void searchForPage(TrainCertificateSearchDto dto, AjaxPageResponse page) {
		arsUtil.setPoliceSearch(dto);
		//只查询申请
		dto.setApplytype(Constants.TYPE_APPLY);
		trainCertificateDao.searchForPage(dto,page);
	}

	/**
	 * 查询
	 * @param dto
	 * @return
	 */
	@Override
	public void search(TrainCertificateSearchDto dto, AjaxPageResponse page) {
		arsUtil.setPoliceSearch(dto);
		//只查询申请

		dto.setApplytype(Constants.TYPE_APPLY);
		trainCertificateDao.search(dto,page);
	}

	@Override
	public void updatePrintedByid(Long id) {
		TrainCertificate trainCertificate = trainCertificateDao.findById(id);
		if(trainCertificate.getPrintcount()==null||trainCertificate.getPrintcount().equals("")){
			trainCertificate.setPrintcount("1");
		}else{
			int printcount = Integer.parseInt(trainCertificate.getPrintcount())+1;
			trainCertificate.setPrintcount(printcount+"");
		}
		trainCertificate.setPrintTime(new Date());
		trainCertificate.setHasprint(true);
		trainCertificateDao.update(trainCertificate);
	}

	@Override
	public void createPdfBatch() {
		List<TrainCertificate> list = trainCertificateDao.searchUnPdf();
		if(null!=list && list.size()>0){
			//生成pdf文档
			PdfFormDto pdfFormDto = new PdfFormDto();
			pdfFormDto.setBusinesstype(BusinessType.PXDW);
			new Thread(() -> { // 异步处理
				try {
					for (TrainCertificate trainCertificate : list) {
						pdfFormDto.setBusinessid(trainCertificate.getId());
						try {
							createPDFService.createPDF(pdfFormDto);
						} catch (Exception e) {
							new ArsException("生成证书pdf失败");
						}
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}).start();
		}else{
			new ArsException("没有需要生成PDF的证书数据");
		}
	}
	@Override
	public int save(TrainCertificate trainCertificate) {
		User currentUser = arsUtil.getCurrentUser();
		if(trainCertificate.getId() == null){
			trainCertificate.setApplytype(Constants.TYPE_APPLY);
			trainCertificate.setPrinttype(Constants.TYPE_PRINT_HZ);
			trainCertificate.setCreateTime(new Date());
		}else{
			TrainCertificate dbRecord = trainCertificateDao.findById(trainCertificate.getId());
			BeanUtils.copyPropertiesIgnore(trainCertificate,dbRecord,true);
			BeanUtils.copyPropertiesIgnore(dbRecord,trainCertificate,false);
		}
		//保存未驻入系统的公司名称
		String isInSystem = trainCertificate.getIsInSystem();
		if(!StringUtils.isEmpty(isInSystem) && isInSystem.equals(Constants.NOT_IN_SYS)){
			String gsmcDefine = trainCertificate.getGsmcDefine();
			trainCertificate.setGsmc(gsmcDefine);
			trainCertificate.setCompanyid(null);
		}
		if(StringUtil.isEmpty(trainCertificate.getAreaCode())){
			SecurityCompany company = securityCompanyService.findById(trainCertificate.getCompanyid());
			if(company != null && company.getOrgId() != null) {
				trainCertificate.setOrgId(Long.parseLong(company.getOrgId()));
				trainCertificate.setAreaCode(company.getAreaCode());
			}else{
				trainCertificate.setOrgId(currentUser.getOrgid());
				trainCertificate.setAreaCode(currentUser.getPolice().getAreaCode());
			}
		}
		trainCertificate.setActive(true);
		trainCertificate.setUpdateBy(currentUser.getUsername());
		trainCertificate.setUpdateTime(new Date());
		trainCertificate.setUpdateflag(true);
		return trainCertificateDao.insertOrUpdate(trainCertificate);
	}

	@Override
	public List<String> selectCompanyName() {
		return trainCertificateDao.selectCompanyName();
	}

	@Override
	public void updateAndCreatePDF(TrainCertificate trainCertificate) {

		User currentUser = arsUtil.getCurrentUser();
		TrainCertificate dbTrainCertificate = trainCertificateDao.findById(trainCertificate.getId());


		//获得项目变更
		String[] projectname = new String[0];
		String[] projectcontent = new String[0];
		String[] projecttime = new String[0];


		if (null!=trainCertificate.getProjectChange()) {
			if (StringUtil.isNotEmpty(trainCertificate.getProjectChange().getProjectname())) {
				projectname = trainCertificate.getProjectChange().getProjectname().split(",");
			}
			if (StringUtil.isNotEmpty(trainCertificate.getProjectChange().getProjectcontent())) {
				projectcontent = trainCertificate.getProjectChange().getProjectcontent().split(",");
			}
			if (StringUtil.isNotEmpty(trainCertificate.getProjectChange().getProjecttime())) {
				projecttime = trainCertificate.getProjectChange().getProjecttime().split(",");
			}
		}
		int[] a = {projectname.length, projectcontent.length, projecttime.length};
		int counta = StringUtil.getMax(a);


		//先删除原有的
		projectChangeDao.deleteByCidAndType(trainCertificate.getId().toString(),BusinessType.PXDW);
		//更新项目变更
		for (int i = 0; i < counta; i++) {
			ProjectChange projectChange = new ProjectChange();
			projectChange.setActive(true);
			projectChange.setCreateTime(new Date());
			projectChange.setUpdateTime(new Date());
			projectChange.setUpdateBy(currentUser.getUsername());
			projectChange.setCertificateId(trainCertificate.getId());
			projectChange.setType(BusinessType.PXDW);
			//判断是否非空，非空则保存
			if (trainCertificate.getProjectChange() != null) {
				if (!StringUtil.isEmpty(trainCertificate.getProjectChange().getProjectname())) {
					if (projectname.length > i) {
						projectChange.setProjectname(projectname[i]);
					}

				}
				if (!StringUtil.isEmpty(trainCertificate.getProjectChange().getProjectcontent())) {
					if (projectcontent.length > i) {
						projectChange.setProjectcontent(projectcontent[i]);
					}

				}
				if (!StringUtil.isEmpty(trainCertificate.getProjectChange().getProjecttime())) {
					if (projecttime.length > i) {
						projectChange.setProjecttime(projecttime[i]);
					}

				}
			}
			projectChangeDao.save(projectChange);
		}

		if (dbTrainCertificate != null) {
			BeanUtils.copyPropertiesIgnore(trainCertificate, dbTrainCertificate, true);
			dbTrainCertificate.setUpdateTime(new Date());
			//线上打印数据标识
			if(StringUtil.isEmpty(dbTrainCertificate.getHasOld())){
				dbTrainCertificate.setHasOld(Constants.PRINT_TYPE_OLD_NO);
				dbTrainCertificate.setPrinttype(Constants.PRINT_TYPE_ONLINE_YES);
			}
			dbTrainCertificate.setUpdateBy(currentUser.getUsername());
			dbTrainCertificate.setPdfpath(null);
			dbTrainCertificate.setPdfpathRevese(null);
			trainCertificateDao.update(dbTrainCertificate);
		} else {
			new ArsException("查找不到保安服务公司证书信息");
		}
       //生成pdf文档
		PdfFormDto pdfFormDto = new PdfFormDto();
		pdfFormDto.setBusinesstype(BusinessType.PXDW);
		pdfFormDto.setBusinessid(trainCertificate.getId());
		try {
			createPDFService.createPDF(pdfFormDto);
		} catch (Exception e) {
			new ArsException("生成证书pdf失败");
		}
	}
	/**
	 * 外导内查询
	 * @param searchDto
	 * @return
	 */
	public List<TrainCertificate> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return trainCertificateDao.searchForDataSynchronization(searchDto);
	}

	/**
	 * 内导外查询
	 * @param startDate
	 * @return
	 */
	public List<TrainCertificate> findDSOutList(String startDate) {
		return trainCertificateDao.findDSOutList(startDate);
	}

	/**
	 * 内外网数据同步
	 * @param list
	 */
	public void importBatch(List<TrainCertificate> list) {
		List<TrainCertificate> dbList = trainCertificateDao.findByBatchId(list);
		//去掉重复的
		//通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
		list.removeAll(dbList);
		if (list.size()>0){
			for (TrainCertificate companyCertificate : list) {
				companyCertificate.setUpdateflag(false);
				try {
					if(!configUtils.isIntranet()){
						companyCertificate.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, companyCertificate.getUpdateTime(), 1));
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			trainCertificateDao.saveBatch(list);
		}
	}
}


