package com.bcxin.ars.service.certificate.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.*;
import com.bcxin.ars.dao.certificate.ComCertificateSnapshotDao;
import com.bcxin.ars.dao.certificate.CompanyCertificateDao;
import com.bcxin.ars.dao.sb.LegalchangeDao;
import com.bcxin.ars.dao.sb.LegalchangeDaoAop;
import com.bcxin.ars.dao.sb.SponsorlicenseDao;
import com.bcxin.ars.dao.sb.SponsorlicenseDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dao.sys.SyscodeDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.certificate.CompanyCertificateSearchDto;
import com.bcxin.ars.dto.sys.PdfFormDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.certificate.ComCertificateSnapshot;
import com.bcxin.ars.model.certificate.CompanyCertificate;
import com.bcxin.ars.model.sb.Legalchange;
import com.bcxin.ars.model.sb.Sponsorlicense;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.Syscode;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.certificate.CompanyCertificateService;
import com.bcxin.ars.service.sb.CreatePDFService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.approval.BusinessType;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
@Service
@Transactional
@DataSyncAnnotation(getClazz = CompanyCertificate.class,getImportType = ImportType.BATCH,getMethodName = "importBatch")
@DataSyncOutAnnotation(getClazz = CompanyCertificate.class,getImportType = ImportType.BATCH)
public class CompanyCertificateServiceImpl implements CompanyCertificateService {

	/***
	 * 日志
	 */
	private Logger logger = LoggerFactory.getLogger(CompanyCertificateServiceImpl.class);

	@Autowired
	private CompanyCertificateDao companyCertificateDao;

	@Autowired
	private SecurityCompanyDao securityCompanyDao;

	@Autowired
	private SecurityCompanyDaoAop securityCompanyDaoAop;

	@Autowired
	private ArsUtil arsUtil;
	@Autowired
	private SponsorlicenseDao sponsorlicenseDao;

	@Autowired
	private SponsorlicenseDaoAop sponsorlicenseDaoAop;
	/***
	 * 审批
	 */
	@Autowired
	private ApprovalDAO approvalDAO;

	@Autowired
	private LegalchangeDao legalchangeDao;

	@Autowired
	private LegalchangeDaoAop legalchangeDaoAop;
	@Autowired
	private ConfigUtils configUtils;

	@Autowired
	private UserDao userDao;

	@Autowired
	private PoliceDao policeDao;

	@Autowired
	private ConfigDao configDao;

	@Autowired
	private SyscodeDAO syscodeDAO;

	@Autowired
	private ProjectChangeDao projectChangeDao;

	@Autowired
	private CreatePDFService createPDFService;

	@Value("${temp-folder}")
	private String tempFolder;
	@Autowired
	private IdWorker idWorker;
	@Autowired
	private ComCertificateSnapshotDao comCertificateSnapshotDao;
	@Autowired
	private SecurityCompanyService securityCompanyService;
	@Override
	public CompanyCertificate findById(long id,String type) {
		//根据ID获取保安服务公司证书信息
		CompanyCertificate companyCertificate = companyCertificateDao.findById(id);
		//判断数据库是否有记录
		if(companyCertificate!=null) {
			//获取公司信息
			if (companyCertificate != null && companyCertificate.getCompanyid() != null) {
				companyCertificate.setCompany(securityCompanyDao.findById(companyCertificate.getCompanyid()));
			}
			//生成二维码
			try {
				/***
				 * 根据打印类型（正副本）生成二维码
				 */
				String cerUrl = configUtils.getValueByKey("PERCERURL"+configUtils.getCurrentProvince());
				String pathName = QRCodeUtil.generateQRCode(cerUrl + Constants.CERTIFICATECOMPANY_MOBILE + id + ".do?type="+type, 100, 100, "jpg", tempFolder + "qrcode.jpg");
				//二维码
				companyCertificate.setQrcode(Base64Img.GetImageStr(pathName, "jpg"));
			} catch (Exception e) {
				logger.error(e.getMessage(), e);
			}
		}
		return companyCertificate;
	}

	/**
	 * 生成二维码信息并保存
	 * @param id
	 * @param type
	 * @return
	 */
	@Override
	public CompanyCertificate findByIdV2(long id,String type) {
		User currentUser = arsUtil.getCurrentUser();
		//根据ID获取保安服务公司证书信息
		CompanyCertificate companyCertificate = companyCertificateDao.findById(id);
		Long qrCodeId = idWorker.nextId();
		//判断数据库是否有记录
		if(companyCertificate!=null) {
			//获取公司信息
			if (companyCertificate != null && companyCertificate.getCompanyid() != null) {
				companyCertificate.setCompany(securityCompanyDao.findById(companyCertificate.getCompanyid()));
			}
			//将证书信息保存到数据库中
			ComCertificateSnapshot comCertificateSnapshot = new ComCertificateSnapshot();
			comCertificateSnapshot.setQrCodeId(qrCodeId);
			BeanUtils.copyPropertiesIgnore(companyCertificate,comCertificateSnapshot,true);
			comCertificateSnapshot.setCreateTime(new Date());
			comCertificateSnapshot.setUpdateTime(new Date());
			comCertificateSnapshot.setCreateBy(currentUser.getUsername());
			if(comCertificateSnapshotDao.save(comCertificateSnapshot)<=0) {
				logger.error("保安服务公司保存快照出错！");
			}
			//生成二维码
			try {
				/***
				 * 根据打印类型（正副本）生成二维码根据qrCodeId查询
				 */
				String cerUrl = configUtils.getValueByKey("PERCERURL"+configUtils.getCurrentProvince());
				String pathName = QRCodeUtil.generateQRCode(cerUrl + Constants.MOBILE_COMPANYCERTIFICATE + qrCodeId + ".do?type="+type, 100, 100, "jpg", tempFolder + "qrcode.jpg");
				//二维码
				companyCertificate.setQrcode(Base64Img.GetImageStr(pathName, "jpg"));
			} catch (Exception e) {
				logger.error(e.getMessage(), e);
			}
		}

		return companyCertificate;
	}
	@Override
	public CompanyCertificate findById(long id) {
		return this.findById(id,Constants.CERPRINTTYPE_Z);
	}
	@Override
	public void updateAndCreatePDF(CompanyCertificate companyCertificate) {
		User currentUser = arsUtil.getCurrentUser();

		//获得项目变更
		String[] projectname = new String[0];
		String[] projectcontent = new String[0];
		String[] projecttime = new String[0];


		if (null!=companyCertificate.getProjectChange()) {
			if (StringUtil.isNotEmpty(companyCertificate.getProjectChange().getProjectname())) {
				projectname = companyCertificate.getProjectChange().getProjectname().split(",");
			}
			if (StringUtil.isNotEmpty(companyCertificate.getProjectChange().getProjectcontent())) {
				projectcontent = companyCertificate.getProjectChange().getProjectcontent().split(",");
			}
			if (StringUtil.isNotEmpty(companyCertificate.getProjectChange().getProjecttime())) {
				projecttime = companyCertificate.getProjectChange().getProjecttime().split(",");
			}
		}
		int[] a = {projectname.length, projectcontent.length, projecttime.length};
		int counta = StringUtil.getMax(a);


		//先删除原有的
		projectChangeDao.deleteByCidAndType(companyCertificate.getId().toString(),BusinessType.BAFWGS);
		//更新项目变更
		for (int i = 0; i < counta; i++) {
			ProjectChange projectChange = new ProjectChange();
			projectChange.setActive(true);
			projectChange.setCreateTime(new Date());
			projectChange.setUpdateTime(new Date());
			projectChange.setUpdateBy(currentUser.getUsername());
			projectChange.setCertificateId(companyCertificate.getId());
			projectChange.setType(BusinessType.BAFWGS);
			//判断是否非空，非空则保存
			if (companyCertificate.getProjectChange() != null) {
				if (!StringUtil.isEmpty(companyCertificate.getProjectChange().getProjectname())) {
					if (projectname.length > i) {
						projectChange.setProjectname(projectname[i]);
					}

				}
				if (!StringUtil.isEmpty(companyCertificate.getProjectChange().getProjectcontent())) {
					if (projectcontent.length > i) {
						projectChange.setProjectcontent(projectcontent[i]);
					}

				}
				if (!StringUtil.isEmpty(companyCertificate.getProjectChange().getProjecttime())) {
					if (projecttime.length > i) {
						projectChange.setProjecttime(projecttime[i]);
					}

				}
			}
			projectChangeDao.save(projectChange);
		}


		CompanyCertificate dbCompanyCertificate = companyCertificateDao.findById(companyCertificate.getId());
		if (dbCompanyCertificate != null) {
			BeanUtils.copyPropertiesIgnore(companyCertificate, dbCompanyCertificate, true);
			dbCompanyCertificate.setUpdateTime(new Date());
			//更新标识
			dbCompanyCertificate.setUpdateflag(true);
			//线上打印数据标识
			if(StringUtil.isEmpty(dbCompanyCertificate.getHasOld())){
				dbCompanyCertificate.setHasOld(Constants.PRINT_TYPE_OLD_NO);
				dbCompanyCertificate.setPrinttype(Constants.PRINT_TYPE_ONLINE_YES);
			}
			dbCompanyCertificate.setUpdateBy(currentUser.getUsername());
			dbCompanyCertificate.setPdfpath(null);
			dbCompanyCertificate.setPdfpathRevese(null);
			companyCertificateDao.update(dbCompanyCertificate);
		} else {
			new ArsException("查找不到保安服务公司证书信息");
		}
       //生成pdf文档
		PdfFormDto pdfFormDto = new PdfFormDto();
		pdfFormDto.setBusinesstype(BusinessType.BAFWGS);
					pdfFormDto.setBusinessid(companyCertificate.getId());
					try {
						createPDFService.createPDF(pdfFormDto);
					} catch (Exception e) {
						new ArsException("生成证书pdf失败");
					}
}

	@Override
	public void saveOrUpdateForLegalchange(CompanyCertificate companyCertificate) {
		User currentUser = arsUtil.getCurrentUser();
		Legalchange legalchange = legalchangeDao.findById(companyCertificate.getLegalchangeId());
		//2018年10月12日13:38:07 wjb 从配置表中读取XXX公保服
		Syscode syscode = syscodeDAO.selectByPrimaryKey("FWXKZH",currentUser.getCityAreaCode());
		if(null == syscode){
			new ArsException("公保服区域未配置！！");
		}
		//2018年8月22日17:28:43 wjb 如果不包含其他，则其他的名称设为空
		if((null!=companyCertificate.getFwfw() && !companyCertificate.getFwfw().contains("20"))||null == companyCertificate.getFwfw()){
			companyCertificate.setOtherSecScopeType(null);
		}
		//设置许可证号
		SecurityCompany company = securityCompanyDao.findById(companyCertificate.getCompanyid());
		//	companyCertificate.setXkzh(config.getValue() + company.getPublicSecurityLicenseNumber());
		if(null!=company){
			companyCertificate.setXkzh(syscode.getCodename() + company.getPublicSecurityLicenseNumber());
		}else{
			throw new ArsException("内网不存在外网对应的公司!");
		}
		//设置证书类型有效
		companyCertificate.setActive(true);
		companyCertificate.setSlr(currentUser.getUsername());// 受理人
		companyCertificate.setSlrsj(currentUser.getPhone());// 受理人手机号码
		companyCertificate.setCreateTime(new Date());
		companyCertificate.setUpdateTime(new Date());
		companyCertificate.setUpdateBy(currentUser.getUsername());
		companyCertificate.setAreaCode(legalchange.getDistrict());
		companyCertificate.setOrgId(legalchange.getOrgid());
		//线上打印数据标识
		companyCertificate.setHasOld(Constants.PRINT_TYPE_OLD_NO);
		companyCertificate.setPrinttype(Constants.PRINT_TYPE_ONLINE_YES);
		//类型为变更
		companyCertificate.setApplytype(Constants.TYPE_CHANGER);
		//标识
		companyCertificate.setUpdateflag(true);
		companyCertificateDao.save(companyCertificate);
		//生成pdf文档
		PdfFormDto pdfFormDto = new PdfFormDto();
		pdfFormDto.setBusinesstype(BusinessType.BAFWGS);
		pdfFormDto.setBusinessid(companyCertificate.getId());
		try {
			createPDFService.createPDF(pdfFormDto);
		} catch (Exception e) {
			logger.error(e.getMessage(),e);
			e.printStackTrace();
			throw new ArsException("生成证书pdf失败");
		}

		//项目变更信息，更新制证状态
		legalchange.setCardState(Constants.CARDSTATE_YES);
		legalchangeDaoAop.update(legalchange);


		//先删除原有的
		projectChangeDao.deleteByCidAndType(companyCertificate.getId().toString(),BusinessType.BAFWGS);
		//更新项目变更
		if(StringUtil.isNotEmpty(legalchange.getSecurityScopes())) {
			insertProject(Constants.CHANGE_FWFW,legalchange.getSecurityScopes(),companyCertificate.getId());
		}
		//公司名称变更
		if(StringUtil.isNotEmpty(legalchange.getCompanyname())) {
			insertProject(Constants.CHANGE_NAME,legalchange.getCompanyname(),companyCertificate.getId());
		}

		//地址变更
		if(StringUtil.isNotEmpty(legalchange.getAddress())) {
			insertProject(Constants.CHANGE_ADDRESS,legalchange.getAddress(),companyCertificate.getId());
		}

		//地址变更
		if(StringUtil.isNotEmpty(legalchange.getLegalname())) {
			insertProject(Constants.CHANGE_LEGALNAME,legalchange.getLegalname(),companyCertificate.getId());
		}
		//注册资金变更
		if(legalchange.getBgregisteredMoney()!=null) {
			insertProject(Constants.CHANGE_ZJ,legalchange.getBgregisteredMoney().toString(),companyCertificate.getId());
		}

		//更新下一级审批人
		Approval approval = approvalDAO.findBybusinessidAndType(legalchange.getId(),BusinessType.FRBG);
		if(approval!=null){
			approval.setNextPerson(null);
			approvalDAO.update(approval);
		}
	}


	/***
	 * 插入变更项目
	 * @param projectname  项目名称
	 * @param projectcontent 项目内容
	 * @param certificateId 证书ID
	 */
	public void insertProject(String projectname,String projectcontent,Long certificateId){
		//当前用户信息
		User currentUser = arsUtil.getCurrentUser();
		ProjectChange projectChange = new ProjectChange();
		projectChange.setActive(true);
		projectChange.setCreateTime(new Date());
		projectChange.setUpdateTime(new Date());
		projectChange.setUpdateBy(currentUser.getUsername());
		projectChange.setCertificateId(certificateId);
		projectChange.setType(BusinessType.BAFWGS);
		projectChange.setProjectname(projectname);
		projectChange.setProjectcontent(projectcontent);
		projectChange.setProjecttime(DateUtil.convertDateToString(new Date(),DateUtil.FORMAT2));
		projectChangeDao.save(projectChange);


	}
	@Override
	public void saveOrUpdate(CompanyCertificate companyCertificate) {
		User currentUser = arsUtil.getCurrentUser();

		Sponsorlicense sponsorlicense = null;

		if(companyCertificate.getSponsorlicenseid() != null) {
			sponsorlicense = sponsorlicenseDao.findById(companyCertificate.getSponsorlicenseid());
			companyCertificate.setOrgId(sponsorlicense.getOrgid());
			companyCertificate.setAreaCode(sponsorlicense.getDistrict());
		}

	//	Config config =configDao.findByKeyAndName("current_native_short","当前系统省份简称");

		//2018年10月12日13:38:07 wjb 从配置表中读取XXX公保服
		Syscode syscode = syscodeDAO.selectByPrimaryKey("FWXKZH",currentUser.getCityAreaCode());
		if(null == syscode){
			throw new ArsException("公保服区域未配置！！");
		}

		//2018年8月22日17:28:43 wjb 如果不包含其他，则其他的名称设为空
		if((null!=companyCertificate.getFwfw() && !companyCertificate.getFwfw().contains("20"))||null == companyCertificate.getFwfw()){
			companyCertificate.setOtherSecScopeType(null);
		}
		if(StringUtil.isEmpty(companyCertificate.getXkzh())) {
			if (companyCertificate.getCompanyid() != null) {
				SecurityCompany company = securityCompanyDao.findById(companyCertificate.getCompanyid());
			//	companyCertificate.setXkzh(config.getValue() + company.getPublicSecurityLicenseNumber());
				if(null!=company){
					companyCertificate.setXkzh(syscode.getCodename() + company.getPublicSecurityLicenseNumber());
				}else{
					throw new ArsException("内网不存在外网对应的公司!");
				}

			}  else {
				//许可证编号规则：第一个字为省、自治区、直辖市简称，后面八位数字中，前四位是发证年份，后四位是发证顺序号，从0001开始。
				SimpleDateFormat simpleDateFormat;
				simpleDateFormat = new SimpleDateFormat("yyyy");
				Date date = new Date();

				String year="";
				/*if(config!=null&& config.getValue() != null){
					year = config.getValue() + simpleDateFormat.format(date);
				}*/
				if(syscode!=null&& syscode.getCodename() != null){
					year = syscode.getCodename() + simpleDateFormat.format(date);
				}

				CompanyCertificateSearchDto resultDto = new CompanyCertificateSearchDto();
				resultDto.setXkzh(year);
				String maxXkzh_year = companyCertificateDao.searchMaxXkzhCount(resultDto);
				if (StringUtils.isEmpty(maxXkzh_year)) {
					maxXkzh_year = year + "0001";
				} else {
					maxXkzh_year = maxXkzh_year.substring(0,  maxXkzh_year.length()-8)
							+ String.valueOf((Long.valueOf(maxXkzh_year.substring( maxXkzh_year.length()-8)) + 1));
				}
				companyCertificate.setXkzh(maxXkzh_year);

				//根据许可证号查询公司是否存在，若存在提示已存在，程序结束。不存在，则继续流程
				//保安公司账号组成按保安公司所属区域的省份编码+字符串（数字or字母组合，不可特殊字符）。如：陕西省的保安公司，账号组成：sn20170713。
				//String username = configDao.findByKey(Constants.COMPANY_ACCOUNT_ROLE).getValue()+companyCertificate.getXkzh().replace(config.getValue(),"");
				String username = configDao.findByKey(Constants.COMPANY_ACCOUNT_ROLE).getValue()+companyCertificate.getXkzh().replace(syscode.getCodename(),"");
				User existUser = userDao.findByUsername(username,String.valueOf(Constants.PLATFORM_COMPANY));
				if (existUser != null) {
					throw new ArsException("保安服务许可证号已存在!");
				}
			}
		}

		if (companyCertificate.getId() == null) {
			//设置证书类型有效
			companyCertificate.setActive(true);
			companyCertificate.setSlr(currentUser.getUsername());// 受理人
			companyCertificate.setSlrsj(currentUser.getPhone());// 受理人手机号码
			companyCertificate.setCreateTime(new Date());
			companyCertificate.setUpdateTime(new Date());
			companyCertificate.setUpdateBy(currentUser.getUsername());
			companyCertificate.setUpdateflag(true);

			//线上打印数据标识
			companyCertificate.setHasOld(Constants.PRINT_TYPE_OLD_NO);
			companyCertificate.setPrinttype(Constants.PRINT_TYPE_ONLINE_YES);

			if(StringUtil.isEmpty(companyCertificate.getAreaCode())){
				companyCertificate.setOrgId(currentUser.getOrgid());
				companyCertificate.setAreaCode(currentUser.getPolice().getAreaCode());
			}

			//类型为申请
			companyCertificate.setApplytype(Constants.TYPE_APPLY);

			companyCertificateDao.save(companyCertificate);

			//生成pdf文档
			PdfFormDto pdfFormDto = new PdfFormDto();
			pdfFormDto.setBusinesstype(BusinessType.BAFWGS);
			pdfFormDto.setBusinessid(companyCertificate.getId());
			try {
				createPDFService.createPDF(pdfFormDto);
			} catch (Exception e) {
				
				throw new ArsException("生成证书pdf失败");
			}

		} else {
			CompanyCertificate dbCompanyCertificate = companyCertificateDao.findById(companyCertificate.getId());
			if (dbCompanyCertificate != null) {
				companyCertificate.setUpdateBy(currentUser.getUsername());
				companyCertificate.setUpdateTime(new Date());
				companyCertificate.setHasOld(Constants.PRINT_TYPE_OLD_NO);
				companyCertificate.setPrinttype(Constants.PRINT_TYPE_ONLINE_YES);
				//标识
				companyCertificate.setUpdateflag(true);
				//类型为申请
				companyCertificate.setApplytype(Constants.TYPE_APPLY);


				if(StringUtil.isEmpty(dbCompanyCertificate.getAreaCode())
				&& StringUtil.isEmpty(companyCertificate.getAreaCode())){
					companyCertificate.setOrgId(currentUser.getOrgid());
					companyCertificate.setAreaCode(currentUser.getPolice().getAreaCode());
				}

				companyCertificateDao.update(companyCertificate);
			} else {
				new ArsException("查找不到保安服务公司证书信息");
			}
		}


		/***
		 * 如果录入证书，状态改成已制证
		 */
		if (sponsorlicense != null) {
			sponsorlicense.setCardState(Constants.CARD_STATE_YZZ);
			sponsorlicense.setUpdateTime(new Date());
			sponsorlicense.setUpdateBy(currentUser.getUsername());
			sponsorlicenseDaoAop.update(sponsorlicense);


			Config configVersion = configDao.findByKey(Constants.APPROVAL_VERSION_SWITCH);
			//2018年6月13日15:30:56 如果是新审批生成账号
			if(configVersion != null && Constants.APPROVAL_VERSION_NEW.equals(configVersion.getValue())){

				User newUser = new User();
				newUser.setInit(false);
				newUser.setRealname(sponsorlicense.getCompanyname());
				newUser.setPhone(sponsorlicense.getPhone());
				newUser.setPlatform(2);
				SecurityCompany newCompany = new SecurityCompany();
				newCompany.setName(sponsorlicense.getCompanyname());



				//安公司类型 01-保安公司，02-武装押运，03-合资 add subh 2019-02-28 14:51 start
				newCompany.setSponsorlicenseType(sponsorlicense.getSponsorlicenseType());
				//安公司类型 01-保安公司，02-武装押运，03-合资 add subh 2019-02-28 14:51 end

				/*Config current_native_short_config = configDao.findByKey(Constants.CURRENT_NATIVE_SHORT);
				if(current_native_short_config == null){
					throw  new ArsException("当前系统省份简称未配置");
				}

				String current_native_short = configDao.findByKey(Constants.CURRENT_NATIVE_SHORT).getValue();

				newCompany.setPublicSecurityLicenseNumber(companyCertificate.getXkzh().replace(current_native_short,""));*/

				newCompany.setPublicSecurityLicenseNumber(companyCertificate.getXkzh().replace(syscode.getCodename(),""));
				newCompany.setLegalPerson(sponsorlicense.getRepresentative());
				newCompany.setLegalPersonNo(sponsorlicense.getLegalPersonNo());
				newCompany.setLocation(sponsorlicense.getAddress());

				newCompany.setOtherSecScopeType(sponsorlicense.getOtherSecScopeType());



				Approval approval = approvalDAO.findBybusinessidAndType(companyCertificate.getSponsorlicenseid(),BusinessType.BAFWGS);
				if(null!=approval){
					newCompany.setAreaCode(approval.getAreaCode());
				}

				newCompany.setRegisteredMoney(new BigDecimal(sponsorlicense.getRegcapital().toString()));
				newCompany.setEconomicType(sponsorlicense.getEnterprisetype());
				newCompany.setTel(sponsorlicense.getTel());
				newCompany.setSecurityScopeType(sponsorlicense.getManagement());
				newCompany.setUser(newUser);
				newCompany.setOrgId(sponsorlicense.getOrgid().toString());
				Police police = policeDao.findById(sponsorlicense.getOrgid());
				newCompany.setOrgName(policeDao.findOrgNameByOrgIds(police.getPath().split("/")));
				newCompany.setInstitutionType(Constants.BKT_ORGTYPE_GS);
				newCompany.setUpdateflag(true);
				//发证日期
				newCompany.setGiveLicenseDate(companyCertificate.getFzrq());
				//发证机构名称
				newCompany.setGiveLicenseName(companyCertificate.getFzjgmc());
				securityCompanyService.updateCompany(newCompany);
			}
		}
	}

	@Override
	public CompanyCertificateSearchDto search(CompanyCertificateSearchDto dto) {
		CompanyCertificateSearchDto resultDto = new CompanyCertificateSearchDto();
		List<CompanyCertificate> list = companyCertificateDao.search(dto);
		resultDto.setTotalCount(companyCertificateDao.searchCount(dto));
		resultDto.setData(list);
		return resultDto;
	}

	@Override
	public void delete(CompanyCertificate companyCertificate) {
		User currentUser = arsUtil.getCurrentUser();
		companyCertificate.setUpdateBy(currentUser.getUsername());
		companyCertificate.setUpdateTime(new Date());
		companyCertificateDao.delete(companyCertificate);
	}

	@Override
	public CompanyCertificate findBySponsorLicenseId(Long sponsorlicenseid) {
		return companyCertificateDao.findBySponsorLicenseId(sponsorlicenseid);
	}

	@Override
	public void updateCompanyCertificate(CompanyCertificate companyCertificate) {
		User currentUser = arsUtil.getCurrentUser();
		CompanyCertificate dbCompanyCertificate = companyCertificateDao.findByCompanyId(companyCertificate.getCompanyid());

		companyCertificate.setAreaCode(dbCompanyCertificate.getAreaCode());
		companyCertificate.setOrgId(dbCompanyCertificate.getOrgId());

		if(StringUtil.isEmpty(companyCertificate.getAreaCode())){
			SecurityCompany company = securityCompanyDao.findById(companyCertificate.getCompanyid());

			if(company.getOrgId() != null) {
				companyCertificate.setOrgId(Long.parseLong(company.getOrgId()));
				companyCertificate.setAreaCode(company.getAreaCode());
			}else{
				companyCertificate.setOrgId(currentUser.getOrgid());
				companyCertificate.setAreaCode(currentUser.getPolice().getAreaCode());
			}
		}

		companyCertificate.setXkzh(dbCompanyCertificate.getXkzh());
		companyCertificate.setPzwh(dbCompanyCertificate.getPzwh());
		companyCertificate.setFzrq(dbCompanyCertificate.getFzrq());

		companyCertificate.setFzjgmc(dbCompanyCertificate.getFzjgmc());
		companyCertificate.setFrdblx(dbCompanyCertificate.getFrdblx());
		companyCertificate.setZczblx(dbCompanyCertificate.getZczblx());
		companyCertificate.setSponsorlicenseid(dbCompanyCertificate.getSponsorlicenseid());
		companyCertificate.setZzrq(dbCompanyCertificate.getZzrq());

		companyCertificate.setActive(true);
		companyCertificate.setSlr(currentUser.getUsername());// 受理人
		companyCertificate.setSlrsj(currentUser.getPhone());// 受理人手机号码
		companyCertificate.setCreateTime(new Date());
		companyCertificate.setUpdateTime(new Date());
		companyCertificate.setUpdateBy(currentUser.getUsername());
		companyCertificate.setUpdateflag(true);
		//线上打印数据标识
		companyCertificate.setHasOld(Constants.PRINT_TYPE_OLD_NO);
		companyCertificate.setPrinttype(Constants.PRINT_TYPE_ONLINE_YES);
		companyCertificateDao.save(companyCertificate);


	}

	@Override
	public CompanyCertificate findByCompanyname(String companyname) {
		return companyCertificateDao.findByCompanyname(companyname);
	}


	@Override
	public CompanyCertificate findByCompanyId(Long companyId) {
		return companyCertificateDao.findByCompanyId(companyId);
	}

	@Override
	public List<CompanyCertificate> findByXkzh(String xkzh) {
		return companyCertificateDao.findByXkzh(xkzh);
	}

	@Override
	public List<CompanyCertificate> findDataByXkzhHistory(String xkzh) {
		return companyCertificateDao.findDataByXkzhHistory(xkzh);
	}

	@Override
	public void updatePrintedByid(Long id) {
		CompanyCertificate companyCertificate = companyCertificateDao.findById(id);
		if(companyCertificate.getPrintcount()==null||companyCertificate.getPrintcount().equals("")){
			companyCertificate.setPrintcount("1");
		}else{
			int printcount = Integer.parseInt(companyCertificate.getPrintcount())+1;
			companyCertificate.setPrintcount(printcount+"");
		}
		companyCertificate.setPrintTime(new Date());
		companyCertificate.setHasprint(true);
		companyCertificateDao.update(companyCertificate);
	}

	@Override
	public CompanyCertificateSearchDto searchLegalangeChange(CompanyCertificateSearchDto dto) {
		CompanyCertificateSearchDto resultDto = new CompanyCertificateSearchDto();
		List<CompanyCertificate> list = companyCertificateDao.searchLegalangeChange(dto);
		resultDto.setTotalCount(companyCertificateDao.searchLegalangeChangeCount(dto));
		resultDto.setData(list);
		return resultDto;
	}

	/**
	 * 批量生成pdf文件
	 */
	@Override
	public void createPdfBatch() {
		List<CompanyCertificate> list = companyCertificateDao.searchUnPdf();
		if(null!=list && list.size()>0){
			//生成pdf文档
			PdfFormDto pdfFormDto = new PdfFormDto();
			pdfFormDto.setBusinesstype(BusinessType.BAFWGS);
			new Thread(() -> { // 异步处理
				try {
					for (CompanyCertificate companyCertificate : list) {
						pdfFormDto.setBusinessid(companyCertificate.getId());
						try {
							createPDFService.createPDF(pdfFormDto);
						} catch (Exception e) {
							new ArsException("生成证书pdf失败");
						}
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}).start();
		}else{
			new ArsException("没有需要生成PDF的证书数据");
		}
	}

	@Override
	public void searchForPage(CompanyCertificateSearchDto dto, AjaxPageResponse<CompanyCertificate> page) {
		arsUtil.setPoliceSearch(dto);
		companyCertificateDao.searchForPage(dto,page);
	}

	@Override
	public void saveForRepair(CompanyCertificate companyCertificate) {
		User currentUser = arsUtil.getCurrentUser();
		String zkzh = configUtils.getValueByKey(Constants.CURRENT_NATIVE_SHORT);
		zkzh = zkzh + "公保服";
		companyCertificate.setXkzh(companyCertificate.getXkzh().replace(zkzh,""));
		//公司是未驻入系统的，把输入的公司名称保存
		if(Constants.NOT_IN_SYS.equals(companyCertificate.getIsInSystem())) {
			String gsmcDefine = companyCertificate.getGsmcDefine();
			companyCertificate.setGsmc(gsmcDefine);
			companyCertificate.setCompanyid(null);
		}else if(companyCertificate.getCompanyid() != null){
			SecurityCompany company = securityCompanyDao.findById(companyCertificate.getCompanyid());
			if(company != null && StringUtil.isNotEmpty(company.getOrgId())){
				companyCertificate.setOrgId(Long.parseLong(company.getOrgId()));
				companyCertificate.setAreaCode(company.getAreaCode());
			}
		}
	    if(companyCertificate.getId() == null) {
            //设置证书类型有效
            companyCertificate.setActive(true);
            companyCertificate.setSlr(currentUser.getUsername());// 受理人
            companyCertificate.setSlrsj(currentUser.getPhone());// 受理人手机号码
            companyCertificate.setCreateTime(new Date());
            companyCertificate.setUpdateTime(new Date());
            companyCertificate.setUpdateBy(currentUser.getUsername());
            companyCertificate.setUpdateflag(true);
            //线上打印数据标识
            companyCertificate.setHasOld(Constants.PRINT_TYPE_OLD_NO);
            companyCertificate.setPrinttype(Constants.TYPE_PRINT_HZ);
            //类型为申请
            companyCertificate.setApplytype(Constants.TYPE_CHANGER);


            if(StringUtil.isEmpty(companyCertificate.getAreaCode())) {
				companyCertificate.setAreaCode(currentUser.getPolice().getAreacode());
				companyCertificate.setOrgId(currentUser.getOrgid());
			}

            companyCertificateDao.save(companyCertificate);
        }else{
            CompanyCertificate dbCompanyCertificate = companyCertificateDao.findById(companyCertificate.getId());
            BeanUtils.copyPropertiesIgnore(companyCertificate,dbCompanyCertificate,true);
			dbCompanyCertificate.setUpdateflag(true);
			dbCompanyCertificate.setUpdateTime(new Date());
			//修改为非驻入的时候，companyId为空
			if(dbCompanyCertificate.getIsInSystem().equals(Constants.NOT_IN_SYS)) {
				dbCompanyCertificate.setCompanyid(null);
			}

			if(StringUtil.isEmpty(dbCompanyCertificate.getAreaCode())) {
				dbCompanyCertificate.setAreaCode(currentUser.getPolice().getAreacode());
				dbCompanyCertificate.setOrgId(currentUser.getOrgid());
			}

            companyCertificateDao.update(dbCompanyCertificate);
        }

		//生成pdf文档
		PdfFormDto pdfFormDto = new PdfFormDto();
		pdfFormDto.setBusinesstype(BusinessType.BAFWGS);
		pdfFormDto.setBusinessid(companyCertificate.getId());
		try {
			createPDFService.createPDF(pdfFormDto);
		} catch (Exception e) {

			throw new ArsException("生成证书pdf失败");
		}
	}

	/**
	 * 外导内查询
	 * @param searchDto
	 * @return
	 */
	public List<CompanyCertificate> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return companyCertificateDao.searchForDataSynchronization(searchDto);
	}

	/**
	 * 内导外查询
	 * @param startDate
	 * @return
	 */
	public List<CompanyCertificate> findDSOutList(String startDate) {
		return companyCertificateDao.findDSOutList(startDate);
	}

	/**
	 * 内外网数据同步
	 * @param list
	 */
	public void importBatch(List<CompanyCertificate> list) {
		List<CompanyCertificate> dbList = companyCertificateDao.findByBatchId(list);
		//去掉重复的
		//通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
		list.removeAll(dbList);
		if (list.size()>0){
			for (CompanyCertificate companyCertificate : list) {
				companyCertificate.setUpdateflag(false);
				try {
					if(!configUtils.isIntranet()){
						companyCertificate.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, companyCertificate.getUpdateTime(), 1));
					}
					//更新企业信息，发证机构和发证日期
					SecurityCompany company =  securityCompanyDao.findById(companyCertificate.getCompanyid());
					//发证日期
					company.setGiveLicenseDate(companyCertificate.getFzrq());
					//发证机构
					company.setGiveLicenseName(companyCertificate.getFzjgmc());
					securityCompanyDaoAop.update(company);
				} catch (Exception e) {
					logger.error(e.getMessage(),e);
				}
			}
			companyCertificateDao.saveBatch(list);
		}
	}

}
